/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.poifs.crypt;

import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.crypt.Decryptor;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.crypt.EncryptionInfo;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.DirectoryNode;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.DocumentInputStream;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.spec.SecretKeySpec;

public class EcmaDecryptor
extends Decryptor {
    private final EncryptionInfo info;
    private byte[] passwordHash;

    public EcmaDecryptor(EncryptionInfo info) {
        this.info = info;
    }

    private byte[] generateKey(int block) throws NoSuchAlgorithmException {
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        sha1.update(this.passwordHash);
        byte[] blockValue = new byte[4];
        LittleEndian.putInt(blockValue, block);
        byte[] finalHash = sha1.digest(blockValue);
        int requiredKeyLength = this.info.getHeader().getKeySize() / 8;
        byte[] buff = new byte[64];
        Arrays.fill(buff, (byte)54);
        for (int i = 0; i < finalHash.length; ++i) {
            buff[i] = (byte)(buff[i] ^ finalHash[i]);
        }
        sha1.reset();
        byte[] x1 = sha1.digest(buff);
        Arrays.fill(buff, (byte)92);
        for (int i = 0; i < finalHash.length; ++i) {
            buff[i] = (byte)(buff[i] ^ finalHash[i]);
        }
        sha1.reset();
        byte[] x2 = sha1.digest(buff);
        byte[] x3 = new byte[x1.length + x2.length];
        System.arraycopy(x1, 0, x3, 0, x1.length);
        System.arraycopy(x2, 0, x3, x1.length, x2.length);
        return this.truncateOrPad(x3, requiredKeyLength);
    }

    @Override
    public boolean verifyPassword(String password) throws GeneralSecurityException {
        this.passwordHash = this.hashPassword(this.info, password);
        Cipher cipher = this.getCipher();
        byte[] verifier = cipher.doFinal(this.info.getVerifier().getVerifier());
        MessageDigest sha1 = MessageDigest.getInstance("SHA-1");
        byte[] calcVerifierHash = sha1.digest(verifier);
        byte[] verifierHash = this.truncateOrPad(cipher.doFinal(this.info.getVerifier().getVerifierHash()), calcVerifierHash.length);
        return Arrays.equals(calcVerifierHash, verifierHash);
    }

    private byte[] truncateOrPad(byte[] source, int length) {
        byte[] result = new byte[length];
        System.arraycopy(source, 0, result, 0, Math.min(length, source.length));
        if (length > source.length) {
            for (int i = source.length; i < length; ++i) {
                result[i] = 0;
            }
        }
        return result;
    }

    private Cipher getCipher() throws GeneralSecurityException {
        byte[] key = this.generateKey(0);
        Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
        SecretKeySpec skey = new SecretKeySpec(key, "AES");
        cipher.init(2, skey);
        return cipher;
    }

    @Override
    public InputStream getDataStream(DirectoryNode dir) throws IOException, GeneralSecurityException {
        DocumentInputStream dis = dir.createDocumentInputStream("EncryptedPackage");
        long size = dis.readLong();
        return new CipherInputStream(dis, this.getCipher());
    }
}

