/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc;

import com.ahmadullahpk.alldocumentreader.xs.fc.EncryptedDocumentException;
import com.ahmadullahpk.alldocumentreader.xs.fc.fs.storage.LittleEndian;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.exceptions.InvalidFormatException;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.exceptions.InvalidOperationException;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.exceptions.OpenXML4JException;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.exceptions.OpenXML4JRuntimeException;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePartCollection;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePartName;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageProperties;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationship;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationshipCollection;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagingURIHelper;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.RelationshipSource;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.TargetMode;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.internal.ContentType;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.internal.ContentTypeManager;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.internal.FileHelper;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.internal.PackagePropertiesPart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.internal.PartMarshaller;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.internal.PartUnmarshaller;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.internal.ZipHelper;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.internal.marshallers.DefaultMarshaller;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.internal.marshallers.ZipPackagePropertiesMarshaller;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.internal.marshallers.ZipPartMarshaller;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.internal.unmarshallers.PackagePropertiesUnmarshaller;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.internal.unmarshallers.UnmarshallContext;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.util.ZipEntrySource;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.util.ZipFileZipEntrySource;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.util.ZipInputStreamZipEntrySource;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipPackage
implements RelationshipSource,
Closeable {
    private ZipEntrySource zipArchive;
    protected PackagePartCollection partList;
    protected PackageRelationshipCollection relationships;
    protected Hashtable<ContentType, PartMarshaller> partMarshallers;
    protected PartMarshaller defaultPartMarshaller;
    protected Hashtable<ContentType, PartUnmarshaller> partUnmarshallers;
    protected PackagePropertiesPart packageProperties;
    protected ContentTypeManager contentTypeManager;
    protected boolean isDirty = false;
    protected String originalPackagePath;
    protected OutputStream output;

    public ZipPackage(String path) {
        if (path == null || "".equals(path.trim()) || new File(path).exists() && new File(path).isDirectory()) {
            throw new IllegalArgumentException("path");
        }
        this.init();
        try {
            ZipFile zipFile = new ZipFile(new File(path));
            this.zipArchive = new ZipFileZipEntrySource(zipFile);
            this.getParts();
            this.originalPackagePath = new File(path).getAbsolutePath();
        }
        catch (Exception e) {
            File file = new File(path);
            if (file.length() == 0L) {
                throw new EncryptedDocumentException("Format error");
            }
            try {
                FileInputStream in = new FileInputStream(file);
                byte[] b = new byte[16];
                in.read(b);
                long signature = LittleEndian.getLong(b, 0);
                if (signature == -2226271756974174256L) {
                    throw new EncryptedDocumentException("Cannot process encrypted office files!");
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new EncryptedDocumentException("Invalid header signature");
        }
    }

    public ZipPackage(InputStream in) throws IOException {
        try {
            this.init();
            this.zipArchive = new ZipInputStreamZipEntrySource(new ZipInputStream(in));
            this.getParts();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void init() {
        this.partMarshallers = new Hashtable(5);
        this.partUnmarshallers = new Hashtable(2);
        try {
            this.partUnmarshallers.put(new ContentType("application/vnd.openxmlformats-package.core-properties+xml"), new PackagePropertiesUnmarshaller());
            this.defaultPartMarshaller = new DefaultMarshaller();
            this.partMarshallers.put(new ContentType("application/vnd.openxmlformats-package.core-properties+xml"), new ZipPackagePropertiesMarshaller());
        }
        catch (InvalidFormatException e) {
            throw new OpenXML4JRuntimeException("Package.init() : this exception should never happen, if you read this message please send a mail to the developers team. : " + e.getMessage());
        }
    }

    public void flush() {
        if (this.packageProperties != null) {
            this.packageProperties.flush();
        }
    }

    @Override
    public void close() throws IOException {
        ReentrantReadWriteLock l = new ReentrantReadWriteLock();
        try {
            l.writeLock().lock();
            if (this.originalPackagePath != null && !"".equals(this.originalPackagePath.trim())) {
                File targetFile = new File(this.originalPackagePath);
                if (!targetFile.exists() || !this.originalPackagePath.equalsIgnoreCase(targetFile.getAbsolutePath())) {
                    this.save(targetFile);
                } else {
                    this.closeImpl();
                }
            } else if (this.output != null) {
                this.save(this.output);
                this.output.close();
            }
        }
        finally {
            l.writeLock().unlock();
        }
        this.contentTypeManager.clearAll();
    }

    public void revert() {
        this.revertImpl();
    }

    public PackageProperties getPackageProperties() throws InvalidFormatException {
        if (this.packageProperties == null) {
            this.packageProperties = new PackagePropertiesPart(this, PackagingURIHelper.CORE_PROPERTIES_PART_NAME);
        }
        return this.packageProperties;
    }

    public PackagePart getPart(URI partName) {
        if (partName == null) {
            throw new IllegalArgumentException("partName");
        }
        try {
            if (this.partList == null) {
                this.getParts();
            }
            return this.getPartImpl(PackagingURIHelper.createPartName(partName));
        }
        catch (InvalidFormatException e) {
            return null;
        }
    }

    public PackagePart getPart(PackagePartName partName) {
        if (partName == null) {
            throw new IllegalArgumentException("partName");
        }
        if (this.partList == null) {
            try {
                this.getParts();
            }
            catch (InvalidFormatException e) {
                return null;
            }
        }
        return this.getPartImpl(partName);
    }

    public ArrayList<PackagePart> getPartsByContentType(String contentType) {
        ArrayList<PackagePart> retArr = new ArrayList<PackagePart>();
        for (PackagePart part : this.partList.values()) {
            if (!part.getContentType().equals(contentType)) continue;
            retArr.add(part);
        }
        return retArr;
    }

    public ArrayList<PackagePart> getPartsByRelationshipType(String relationshipType) {
        if (relationshipType == null) {
            throw new IllegalArgumentException("relationshipType");
        }
        ArrayList<PackagePart> retArr = new ArrayList<PackagePart>();
        for (PackageRelationship rel : this.getRelationshipsByType(relationshipType)) {
            retArr.add(this.getPart(rel));
        }
        return retArr;
    }

    public List<PackagePart> getPartsByName(Pattern namePattern) {
        if (namePattern == null) {
            throw new IllegalArgumentException("name pattern must not be null");
        }
        ArrayList<PackagePart> result = new ArrayList<PackagePart>();
        for (PackagePart part : this.partList.values()) {
            PackagePartName partName = part.getPartName();
            String name = partName.getName();
            Matcher matcher = namePattern.matcher(name);
            if (!matcher.matches()) continue;
            result.add(part);
        }
        return result;
    }

    public PackagePart getPart(PackageRelationship partRel) {
        PackagePart retPart = null;
        this.ensureRelationships();
        for (PackageRelationship rel : this.relationships) {
            if (!rel.getRelationshipType().equals(partRel.getRelationshipType())) continue;
            try {
                retPart = this.getPart(PackagingURIHelper.createPartName(rel.getTargetURI()));
                break;
            }
            catch (InvalidFormatException e) {
            }
        }
        return retPart;
    }

    public ArrayList<PackagePart> getParts() throws InvalidFormatException {
        if (this.partList == null) {
            try {
                ZipEntry entry;
                this.partList = new PackagePartCollection();
                Enumeration<? extends ZipEntry> entries = this.zipArchive.getEntries();
                while (entries.hasMoreElements()) {
                    entry = entries.nextElement();
                    if (!entry.getName().equalsIgnoreCase("[Content_Types].xml")) continue;
                    InputStream in = this.zipArchive.getInputStream(entry);
                    this.contentTypeManager = new ContentTypeManager(in, this);
                    in.close();
                    break;
                }
                entries = this.zipArchive.getEntries();
                while (entries.hasMoreElements()) {
                    String contentType;
                    entry = entries.nextElement();
                    PackagePartName partName = this.buildPartName(entry);
                    if (partName == null || (contentType = this.contentTypeManager.getContentType(partName)) == null) continue;
                    ZipPackagePart part = new ZipPackagePart(this, entry, partName, contentType);
                    if (contentType.equals("application/vnd.openxmlformats-package.core-properties+xml")) {
                        PartUnmarshaller partUnmarshaller = this.partUnmarshallers.get(contentType);
                        if (partUnmarshaller == null) continue;
                        UnmarshallContext context = new UnmarshallContext(this, part._partName);
                        PackagePart unmarshallPart = partUnmarshaller.unmarshall(context, part.getInputStream());
                        this.partList.put(unmarshallPart._partName, unmarshallPart);
                        if (!(unmarshallPart instanceof PackagePropertiesPart)) continue;
                        this.packageProperties = (PackagePropertiesPart)unmarshallPart;
                        continue;
                    }
                    this.partList.put(partName, part);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        ArrayList<PackagePart> list = new ArrayList<PackagePart>(this.partList.values());
        for (PackagePart part : list) {
            part.loadRelationships();
        }
        return list;
    }

    public PackagePart createPart(PackagePartName partName, String contentType) {
        return this.createPart(partName, contentType, true);
    }

    protected PackagePart createPart(PackagePartName partName, String contentType, boolean loadRelationships) {
        if (partName == null) {
            throw new IllegalArgumentException("partName");
        }
        if (contentType == null || contentType.equals("")) {
            throw new IllegalArgumentException("contentType");
        }
        if (this.partList.containsKey(partName) && !((PackagePart)this.partList.get(partName)).isDeleted()) {
            throw new InvalidOperationException("A part with the name '" + partName.getName() + "' already exists : Packages shall not contain equivalent part names and package implementers shall neither create nor recognize packages with equivalent part names. [M1.12]");
        }
        if (contentType.equals("application/vnd.openxmlformats-package.core-properties+xml") && this.packageProperties != null) {
            throw new InvalidOperationException("OPC Compliance error [M4.1]: you try to add more than one core properties relationship in the package !");
        }
        PackagePart part = this.createPartImpl(partName, contentType, loadRelationships);
        this.contentTypeManager.addContentType(partName, contentType);
        this.partList.put(partName, part);
        this.isDirty = true;
        return part;
    }

    public PackagePart createPart(PackagePartName partName, String contentType, ByteArrayOutputStream content) {
        PackagePart addedPart = this.createPart(partName, contentType);
        if (addedPart == null) {
            return null;
        }
        if (content != null) {
            try {
                OutputStream partOutput = addedPart.getOutputStream();
                if (partOutput == null) {
                    return null;
                }
                partOutput.write(content.toByteArray(), 0, content.size());
                partOutput.close();
            }
            catch (IOException ioe) {
                return null;
            }
        } else {
            return null;
        }
        return addedPart;
    }

    protected PackagePart addPackagePart(PackagePart part) {
        if (part == null) {
            throw new IllegalArgumentException("part");
        }
        if (this.partList.containsKey(part._partName)) {
            if (!((PackagePart)this.partList.get(part._partName)).isDeleted()) {
                throw new InvalidOperationException("A part with the name '" + part._partName.getName() + "' already exists : Packages shall not contain equivalent part names and package implementers shall neither create nor recognize packages with equivalent part names. [M1.12]");
            }
            part.setDeleted(false);
            this.partList.remove(part._partName);
        }
        this.partList.put(part._partName, part);
        this.isDirty = true;
        return part;
    }

    public void removePart(PackagePart part) {
        if (part != null) {
            this.removePart(part.getPartName());
        }
    }

    public void removePart(PackagePartName partName) {
        if (partName == null || !this.containPart(partName)) {
            throw new IllegalArgumentException("partName");
        }
        if (this.partList.containsKey(partName)) {
            ((PackagePart)this.partList.get(partName)).setDeleted(true);
            this.partList.remove(partName);
        }
        this.contentTypeManager.removeContentType(partName);
        if (partName.isRelationshipPartURI()) {
            PackagePart part;
            PackagePartName sourcePartName;
            URI sourceURI = PackagingURIHelper.getSourcePartUriFromRelationshipPartUri(partName.getURI());
            try {
                sourcePartName = PackagingURIHelper.createPartName(sourceURI);
            }
            catch (InvalidFormatException e) {
                return;
            }
            if (sourcePartName.getURI().equals(PackagingURIHelper.PACKAGE_ROOT_URI)) {
                this.clearRelationships();
            } else if (this.containPart(sourcePartName) && (part = this.getPart(sourcePartName)) != null) {
                part.clearRelationships();
            }
        }
        this.isDirty = true;
    }

    public void removePartRecursive(PackagePartName partName) throws InvalidFormatException {
        PackagePart relPart = (PackagePart)this.partList.get(PackagingURIHelper.getRelationshipPartName(partName));
        PackagePart partToRemove = (PackagePart)this.partList.get(partName);
        if (relPart != null) {
            PackageRelationshipCollection partRels = new PackageRelationshipCollection(partToRemove);
            for (PackageRelationship rel : partRels) {
                PackagePartName partNameToRemove = PackagingURIHelper.createPartName(PackagingURIHelper.resolvePartUri(rel.getSourceURI(), rel.getTargetURI()));
                this.removePart(partNameToRemove);
            }
            this.removePart(relPart._partName);
        }
        this.removePart(partToRemove._partName);
    }

    public void deletePart(PackagePartName partName) {
        if (partName == null) {
            throw new IllegalArgumentException("partName");
        }
        this.removePart(partName);
        this.removePart(PackagingURIHelper.getRelationshipPartName(partName));
    }

    public void deletePartRecursive(PackagePartName partName) {
        if (partName == null || !this.containPart(partName)) {
            throw new IllegalArgumentException("partName");
        }
        PackagePart partToDelete = this.getPart(partName);
        this.removePart(partName);
        try {
            for (PackageRelationship relationship : partToDelete.getRelationships()) {
                PackagePartName targetPartName = PackagingURIHelper.createPartName(PackagingURIHelper.resolvePartUri(partName.getURI(), relationship.getTargetURI()));
                this.deletePartRecursive(targetPartName);
            }
        }
        catch (InvalidFormatException e) {
            return;
        }
        PackagePartName relationshipPartName = PackagingURIHelper.getRelationshipPartName(partName);
        if (relationshipPartName != null && this.containPart(relationshipPartName)) {
            this.removePart(relationshipPartName);
        }
    }

    public boolean containPart(PackagePartName partName) {
        return this.getPart(partName) != null;
    }

    @Override
    public PackageRelationship addRelationship(PackagePartName targetPartName, TargetMode targetMode, String relationshipType, String relID) {
        if (relationshipType.equals("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties") && this.packageProperties != null) {
            throw new InvalidOperationException("OPC Compliance error [M4.1]: can't add another core properties part ! Use the built-in package method instead.");
        }
        if (targetPartName.isRelationshipPartURI()) {
            throw new InvalidOperationException("Rule M1.25: The Relationships part shall not have relationships to any other part.");
        }
        this.ensureRelationships();
        PackageRelationship retRel = this.relationships.addRelationship(targetPartName.getURI(), targetMode, relationshipType, relID);
        this.isDirty = true;
        return retRel;
    }

    @Override
    public PackageRelationship addRelationship(PackagePartName targetPartName, TargetMode targetMode, String relationshipType) {
        return this.addRelationship(targetPartName, targetMode, relationshipType, null);
    }

    @Override
    public PackageRelationship addExternalRelationship(String target, String relationshipType) {
        return this.addExternalRelationship(target, relationshipType, null);
    }

    @Override
    public PackageRelationship addExternalRelationship(String target, String relationshipType, String id2) {
        URI targetURI;
        if (target == null) {
            throw new IllegalArgumentException("target");
        }
        if (relationshipType == null) {
            throw new IllegalArgumentException("relationshipType");
        }
        try {
            targetURI = new URI(target);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid target - " + e);
        }
        this.ensureRelationships();
        PackageRelationship retRel = this.relationships.addRelationship(targetURI, TargetMode.EXTERNAL, relationshipType, id2);
        this.isDirty = true;
        return retRel;
    }

    @Override
    public void removeRelationship(String id2) {
        if (this.relationships != null) {
            this.relationships.removeRelationship(id2);
            this.isDirty = true;
        }
    }

    @Override
    public PackageRelationshipCollection getRelationships() {
        return this.getRelationshipsHelper(null);
    }

    @Override
    public PackageRelationshipCollection getRelationshipsByType(String relationshipType) {
        if (relationshipType == null) {
            throw new IllegalArgumentException("relationshipType");
        }
        return this.getRelationshipsHelper(relationshipType);
    }

    private PackageRelationshipCollection getRelationshipsHelper(String id2) {
        this.ensureRelationships();
        return this.relationships.getRelationships(id2);
    }

    @Override
    public void clearRelationships() {
        if (this.relationships != null) {
            this.relationships.clear();
            this.isDirty = true;
        }
    }

    public void ensureRelationships() {
        if (this.relationships == null) {
            try {
                this.relationships = new PackageRelationshipCollection(this);
            }
            catch (InvalidFormatException e) {
                this.relationships = new PackageRelationshipCollection();
            }
        }
    }

    @Override
    public PackageRelationship getRelationship(String id2) {
        return this.relationships.getRelationshipByID(id2);
    }

    @Override
    public boolean hasRelationships() {
        return this.relationships.size() > 0;
    }

    @Override
    public boolean isRelationshipExists(PackageRelationship rel) {
        for (PackageRelationship r : this.getRelationships()) {
            if (r != rel) continue;
            return true;
        }
        return false;
    }

    public void addMarshaller(String contentType, PartMarshaller marshaller) {
        try {
            this.partMarshallers.put(new ContentType(contentType), marshaller);
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
    }

    public void addUnmarshaller(String contentType, PartUnmarshaller unmarshaller) {
        try {
            this.partUnmarshallers.put(new ContentType(contentType), unmarshaller);
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
    }

    public void removeMarshaller(String contentType) {
        this.partMarshallers.remove(contentType);
    }

    public void removeUnmarshaller(String contentType) {
        this.partUnmarshallers.remove(contentType);
    }

    public boolean validatePackage(ZipPackage pkg) throws InvalidFormatException {
        throw new InvalidOperationException("Not implemented yet !!!");
    }

    public void save(File targetFile) throws IOException {
        if (targetFile == null) {
            throw new IllegalArgumentException("targetFile");
        }
        if (targetFile.exists() && targetFile.getAbsolutePath().equals(this.originalPackagePath)) {
            throw new InvalidOperationException("You can't call save(File) to save to the currently open file. To save to the current file, please just call close()");
        }
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(targetFile);
        }
        catch (FileNotFoundException e) {
            throw new IOException(e.getLocalizedMessage());
        }
        this.save(fos);
        fos.close();
    }

    public void save(OutputStream outputStream) throws IOException {
        this.saveImpl(outputStream);
    }

    private PackagePartName buildPartName(ZipEntry entry) {
        try {
            if (entry.getName().equalsIgnoreCase("[Content_Types].xml")) {
                return null;
            }
            return PackagingURIHelper.createPartName(ZipHelper.getOPCNameFromZipItemName(entry.getName()));
        }
        catch (Exception e) {
            return null;
        }
    }

    protected PackagePart createPartImpl(PackagePartName partName, String contentType, boolean loadRelationships) {
        return null;
    }

    protected void closeImpl() throws IOException {
        this.flush();
        if (this.originalPackagePath != null && !"".equals(this.originalPackagePath)) {
            File targetFile = new File(this.originalPackagePath);
            if (targetFile.exists()) {
                File tempFile = File.createTempFile(this.generateTempFileName(FileHelper.getDirectory(targetFile)), ".tmp");
                try {
                    this.save(tempFile);
                    this.zipArchive.close();
                    FileHelper.copyFile(tempFile, targetFile);
                }
                finally {
                    if (!tempFile.delete()) {
                        // empty if block
                    }
                }
            } else {
                throw new InvalidOperationException("Can't close a package not previously open with the open() method !");
            }
        }
    }

    private synchronized String generateTempFileName(File directory) {
        File tmpFilename;
        while ((tmpFilename = new File(directory.getAbsoluteFile() + File.separator + "OpenXML4J" + System.nanoTime())).exists()) {
        }
        return FileHelper.getFilename(tmpFilename.getAbsoluteFile());
    }

    protected void revertImpl() {
        try {
            if (this.zipArchive != null) {
                this.zipArchive.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected PackagePart getPartImpl(PackagePartName partName) {
        if (this.partList.containsKey(partName)) {
            return (PackagePart)this.partList.get(partName);
        }
        return null;
    }

    public void saveImpl(OutputStream outputStream) {
        ZipOutputStream zos = null;
        try {
            zos = !(outputStream instanceof ZipOutputStream) ? new ZipOutputStream(outputStream) : (ZipOutputStream)outputStream;
            if (this.getPartsByRelationshipType("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties").size() == 0 && this.getPartsByRelationshipType("http://schemas.openxmlformats.org/officedocument/2006/relationships/metadata/core-properties").size() == 0) {
                new ZipPackagePropertiesMarshaller().marshall(this.packageProperties, zos);
                this.relationships.addRelationship(this.packageProperties.getPartName().getURI(), TargetMode.INTERNAL, "http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties", null);
                if (!this.contentTypeManager.isContentTypeRegister("application/vnd.openxmlformats-package.core-properties+xml")) {
                    this.contentTypeManager.addContentType(this.packageProperties.getPartName(), "application/vnd.openxmlformats-package.core-properties+xml");
                }
            }
            ZipPartMarshaller.marshallRelationshipPart(this.getRelationships(), PackagingURIHelper.PACKAGE_RELATIONSHIPS_ROOT_PART_NAME, zos);
            this.contentTypeManager.save(zos);
            for (PackagePart part : this.getParts()) {
                if (part.isRelationshipPart()) continue;
                PartMarshaller marshaller = this.partMarshallers.get(part._contentType);
                if (marshaller != null) {
                    if (marshaller.marshall(part, zos)) continue;
                    throw new OpenXML4JException("The part " + part.getPartName().getURI() + " fail to be saved in the stream with marshaller " + marshaller);
                }
                if (this.defaultPartMarshaller.marshall(part, zos)) continue;
                throw new OpenXML4JException("The part " + part.getPartName().getURI() + " fail to be saved in the stream with marshaller " + this.defaultPartMarshaller);
            }
            zos.close();
        }
        catch (Exception e) {
            throw new OpenXML4JRuntimeException("Fail to save: an error occurs while saving the package : " + e.getMessage(), e);
        }
    }

    public ZipEntrySource getZipArchive() {
        return this.zipArchive;
    }
}

