/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc;

import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.exceptions.InvalidFormatException;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.exceptions.InvalidOperationException;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.exceptions.OpenXML4JException;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePartName;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationship;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationshipCollection;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagingURIHelper;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.RelationshipSource;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.TargetMode;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackage;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.internal.ContentType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;

public abstract class PackagePart
implements RelationshipSource {
    protected ZipPackage _container;
    protected PackagePartName _partName;
    protected ContentType _contentType;
    private boolean _isRelationshipPart;
    private boolean _isDeleted;
    private PackageRelationshipCollection _relationships;

    protected PackagePart(ZipPackage pack, PackagePartName partName, ContentType contentType) throws InvalidFormatException {
        this(pack, partName, contentType, true);
    }

    protected PackagePart(ZipPackage pack, PackagePartName partName, ContentType contentType, boolean loadRelationships) throws InvalidFormatException {
        this._partName = partName;
        this._contentType = contentType;
        this._container = pack;
        this._isRelationshipPart = this._partName.isRelationshipPartURI();
        if (loadRelationships) {
            this.loadRelationships();
        }
    }

    public PackagePart(ZipPackage pack, PackagePartName partName, String contentType) throws InvalidFormatException {
        this(pack, partName, new ContentType(contentType));
    }

    @Override
    public PackageRelationship addExternalRelationship(String target, String relationshipType) {
        return this.addExternalRelationship(target, relationshipType, null);
    }

    @Override
    public PackageRelationship addExternalRelationship(String target, String relationshipType, String id2) {
        URI targetURI;
        if (target == null) {
            throw new IllegalArgumentException("target");
        }
        if (relationshipType == null) {
            throw new IllegalArgumentException("relationshipType");
        }
        if (this._relationships == null) {
            this._relationships = new PackageRelationshipCollection();
        }
        try {
            targetURI = new URI(target);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Invalid target - " + e);
        }
        return this._relationships.addRelationship(targetURI, TargetMode.EXTERNAL, relationshipType, id2);
    }

    @Override
    public PackageRelationship addRelationship(PackagePartName targetPartName, TargetMode targetMode, String relationshipType) {
        return this.addRelationship(targetPartName, targetMode, relationshipType, null);
    }

    @Override
    public PackageRelationship addRelationship(PackagePartName targetPartName, TargetMode targetMode, String relationshipType, String id2) {
        if (targetPartName == null) {
            throw new IllegalArgumentException("targetPartName");
        }
        if (targetMode == null) {
            throw new IllegalArgumentException("targetMode");
        }
        if (relationshipType == null) {
            throw new IllegalArgumentException("relationshipType");
        }
        if (this._isRelationshipPart || targetPartName.isRelationshipPartURI()) {
            throw new InvalidOperationException("Rule M1.25: The Relationships part shall not have relationships to any other part.");
        }
        if (this._relationships == null) {
            this._relationships = new PackageRelationshipCollection();
        }
        return this._relationships.addRelationship(targetPartName.getURI(), targetMode, relationshipType, id2);
    }

    public PackageRelationship addRelationship(URI targetURI, TargetMode targetMode, String relationshipType) {
        return this.addRelationship(targetURI, targetMode, relationshipType, null);
    }

    public PackageRelationship addRelationship(URI targetURI, TargetMode targetMode, String relationshipType, String id2) {
        if (targetURI == null) {
            throw new IllegalArgumentException("targetPartName");
        }
        if (targetMode == null) {
            throw new IllegalArgumentException("targetMode");
        }
        if (relationshipType == null) {
            throw new IllegalArgumentException("relationshipType");
        }
        if (this._isRelationshipPart || PackagingURIHelper.isRelationshipPartURI(targetURI)) {
            throw new InvalidOperationException("Rule M1.25: The Relationships part shall not have relationships to any other part.");
        }
        if (this._relationships == null) {
            this._relationships = new PackageRelationshipCollection();
        }
        return this._relationships.addRelationship(targetURI, targetMode, relationshipType, id2);
    }

    @Override
    public void clearRelationships() {
        if (this._relationships != null) {
            this._relationships.clear();
        }
    }

    @Override
    public void removeRelationship(String id2) {
        if (this._relationships != null) {
            this._relationships.removeRelationship(id2);
        }
    }

    @Override
    public PackageRelationshipCollection getRelationships() throws InvalidFormatException {
        return this.getRelationshipsCore(null);
    }

    @Override
    public PackageRelationship getRelationship(String id2) {
        return this._relationships.getRelationshipByID(id2);
    }

    @Override
    public PackageRelationshipCollection getRelationshipsByType(String relationshipType) throws InvalidFormatException {
        return this.getRelationshipsCore(relationshipType);
    }

    private PackageRelationshipCollection getRelationshipsCore(String filter) throws InvalidFormatException {
        if (this._relationships == null) {
            this.throwExceptionIfRelationship();
            this._relationships = new PackageRelationshipCollection(this);
        }
        return new PackageRelationshipCollection(this._relationships, filter);
    }

    @Override
    public boolean hasRelationships() {
        return !this._isRelationshipPart && this._relationships != null && this._relationships.size() > 0;
    }

    @Override
    public boolean isRelationshipExists(PackageRelationship rel) {
        try {
            for (PackageRelationship r : this.getRelationships()) {
                if (r != rel) continue;
                return true;
            }
        }
        catch (InvalidFormatException invalidFormatException) {
            // empty catch block
        }
        return false;
    }

    public InputStream getInputStream() throws IOException {
        InputStream inStream = this.getInputStreamImpl();
        if (inStream == null) {
            throw new IOException("Can't obtain the input stream from " + this._partName.getName());
        }
        return inStream;
    }

    public OutputStream getOutputStream() {
        OutputStream outStream;
        if (this instanceof ZipPackagePart) {
            this._container.removePart(this._partName);
            PackagePart part = this._container.createPart(this._partName, this._contentType.toString(), false);
            if (part == null) {
                throw new InvalidOperationException("Can't create a temporary part !");
            }
            part._relationships = this._relationships;
            outStream = part.getOutputStreamImpl();
        } else {
            outStream = this.getOutputStreamImpl();
        }
        return outStream;
    }

    private void throwExceptionIfRelationship() throws InvalidOperationException {
        if (this._isRelationshipPart) {
            throw new InvalidOperationException("Can do this operation on a relationship part !");
        }
    }

    public void loadRelationships() throws InvalidFormatException {
        if (!(this._relationships != null && this._relationships.size() != 0 || this._isRelationshipPart)) {
            this.throwExceptionIfRelationship();
            this._relationships = new PackageRelationshipCollection(this);
        }
    }

    public PackagePartName getPartName() {
        return this._partName;
    }

    public String getContentType() {
        return this._contentType.toString();
    }

    public void setContentType(String contentType) throws InvalidFormatException {
        if (this._container != null) {
            throw new InvalidOperationException("You can't change the content type of a part.");
        }
        this._contentType = new ContentType(contentType);
    }

    public ZipPackage getPackage() {
        return this._container;
    }

    public boolean isRelationshipPart() {
        return this._isRelationshipPart;
    }

    public boolean isDeleted() {
        return this._isDeleted;
    }

    public void setDeleted(boolean isDeleted) {
        this._isDeleted = isDeleted;
    }

    public String toString() {
        return "Name: " + this._partName + " - Content Type: " + this._contentType.toString();
    }

    protected abstract InputStream getInputStreamImpl() throws IOException;

    protected abstract OutputStream getOutputStreamImpl();

    public abstract boolean save(OutputStream var1) throws OpenXML4JException;

    public abstract boolean load(InputStream var1) throws InvalidFormatException;

    public abstract void close();

    public abstract void flush();
}

