/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.DefaultEscherRecordFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.PictureDescriptor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.HWPFShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.HWPFShapeFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.util.ArrayList;

public class InlineWordArt
extends PictureDescriptor {
    private ArrayList<EscherRecord> escherRecords;

    public InlineWordArt(byte[] _dataStream, int dataBlockStartOffset) {
        super(_dataStream, dataBlockStartOffset);
        short PICTF1BlockSize;
        int dataBlockSize = LittleEndian.getInt(_dataStream, dataBlockStartOffset);
        int dataBlockEndOffset = dataBlockSize + dataBlockStartOffset;
        short PICTFBlockSize = LittleEndian.getShort(_dataStream, dataBlockStartOffset + 4);
        int PICTF1BlockOffset = dataBlockStartOffset + PICTFBlockSize + 4;
        short MM_TYPE = LittleEndian.getShort(_dataStream, dataBlockStartOffset + 4 + 2);
        if (MM_TYPE == 102) {
            int cchPicName = LittleEndian.getUnsignedByte(_dataStream, PICTF1BlockOffset);
            PICTF1BlockOffset += 1 + cchPicName;
        }
        int unknownHeaderOffset = (PICTF1BlockSize = LittleEndian.getShort(_dataStream, PICTF1BlockOffset)) + PICTF1BlockOffset < dataBlockEndOffset ? PICTF1BlockSize + PICTF1BlockOffset : PICTF1BlockOffset;
        this.escherRecords = this.fillEscherRecords(_dataStream, PICTF1BlockOffset - 4, unknownHeaderOffset - PICTF1BlockOffset + 4);
    }

    public HWPFShape getInlineWordArt() {
        if (this.escherRecords != null && this.escherRecords.size() > 0 && this.escherRecords.get(0) instanceof EscherContainerRecord) {
            return HWPFShapeFactory.createShape((EscherContainerRecord)this.escherRecords.get(0), null);
        }
        return null;
    }

    public int getHorizontalScalingFactor() {
        return this.mx;
    }

    public int getVerticalScalingFactor() {
        return this.my;
    }

    public int getDxaGoal() {
        return this.dxaGoal;
    }

    public int getDyaGoal() {
        return this.dyaGoal;
    }

    private ArrayList<EscherRecord> fillEscherRecords(byte[] data, int offset, int size) {
        ArrayList<EscherRecord> escherRecords = new ArrayList<EscherRecord>();
        DefaultEscherRecordFactory recordFactory = new DefaultEscherRecordFactory();
        try {
            int bytesRead;
            for (int pos = offset; pos < offset + size; pos += bytesRead) {
                EscherRecord r = recordFactory.createRecord(data, pos);
                escherRecords.add(r);
                bytesRead = r.fillFields(data, pos, recordFactory);
            }
            return escherRecords;
        }
        catch (Exception e) {
            return null;
        }
    }
}

