/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.BookmarksTables;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.GenericPropertyNode;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.PropertyNode;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.Bookmarks;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.POIBookmark;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class BookmarksImpl
implements Bookmarks {
    private final BookmarksTables bookmarksTables;
    private Map<Integer, List<GenericPropertyNode>> sortedDescriptors = null;
    private int[] sortedStartPositions = null;

    public BookmarksImpl(BookmarksTables bookmarksTables) {
        this.bookmarksTables = bookmarksTables;
    }

    private POIBookmark getBookmark(GenericPropertyNode first) {
        return new BookmarkImpl(first);
    }

    @Override
    public POIBookmark getBookmark(int index) {
        GenericPropertyNode first = this.bookmarksTables.getDescriptorFirst(index);
        return this.getBookmark(first);
    }

    public List<POIBookmark> getBookmarksAt(int startCp) {
        this.updateSortedDescriptors();
        List<GenericPropertyNode> nodes = this.sortedDescriptors.get(startCp);
        if (nodes == null || nodes.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<POIBookmark> result = new ArrayList<POIBookmark>(nodes.size());
        for (GenericPropertyNode node : nodes) {
            result.add(this.getBookmark(node));
        }
        return Collections.unmodifiableList(result);
    }

    @Override
    public int getBookmarksCount() {
        return this.bookmarksTables.getDescriptorsFirstCount();
    }

    @Override
    public Map<Integer, List<POIBookmark>> getBookmarksStartedBetween(int startInclusive, int endExclusive) {
        int endLookupIndex;
        this.updateSortedDescriptors();
        int startLookupIndex = Arrays.binarySearch(this.sortedStartPositions, startInclusive);
        if (startLookupIndex < 0) {
            startLookupIndex = -(startLookupIndex + 1);
        }
        if ((endLookupIndex = Arrays.binarySearch(this.sortedStartPositions, endExclusive)) < 0) {
            endLookupIndex = -(endLookupIndex + 1);
        }
        LinkedHashMap<Integer, List<POIBookmark>> result = new LinkedHashMap<Integer, List<POIBookmark>>();
        for (int lookupIndex = startLookupIndex; lookupIndex < endLookupIndex; ++lookupIndex) {
            int s = this.sortedStartPositions[lookupIndex];
            if (s < startInclusive) continue;
            if (s >= endExclusive) break;
            List<POIBookmark> startedAt = this.getBookmarksAt(s);
            if (startedAt == null) continue;
            result.put(s, startedAt);
        }
        return Collections.unmodifiableMap(result);
    }

    /*
     * WARNING - void declaration
     */
    private void updateSortedDescriptors() {
        if (this.sortedDescriptors != null) {
            return;
        }
        HashMap<Integer, List<GenericPropertyNode>> result = new HashMap<Integer, List<GenericPropertyNode>>();
        for (int b = 0; b < this.bookmarksTables.getDescriptorsFirstCount(); ++b) {
            void var5_5;
            GenericPropertyNode property = this.bookmarksTables.getDescriptorFirst(b);
            Integer positionKey = property.getStart();
            List list = (List)result.get(positionKey);
            if (list == null) {
                LinkedList linkedList = new LinkedList();
                result.put(positionKey, linkedList);
            }
            var5_5.add(property);
        }
        int counter = 0;
        int[] indices = new int[result.size()];
        for (Map.Entry entry : result.entrySet()) {
            indices[counter++] = (Integer)entry.getKey();
            ArrayList updated = new ArrayList((Collection)entry.getValue());
            Collections.sort(updated, PropertyNode.EndComparator.instance);
            entry.setValue(updated);
        }
        Arrays.sort(indices);
        this.sortedDescriptors = result;
        this.sortedStartPositions = indices;
    }

    private final class BookmarkImpl
    implements POIBookmark {
        private final GenericPropertyNode first;

        private BookmarkImpl(GenericPropertyNode first) {
            this.first = first;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            BookmarkImpl other = (BookmarkImpl)obj;
            return !(this.first == null ? other.first != null : !this.first.equals(other.first));
        }

        @Override
        public int getEnd() {
            int currentIndex = BookmarksImpl.this.bookmarksTables.getDescriptorFirstIndex(this.first);
            try {
                GenericPropertyNode descriptorLim = BookmarksImpl.this.bookmarksTables.getDescriptorLim(currentIndex);
                return descriptorLim.getStart();
            }
            catch (IndexOutOfBoundsException exc) {
                return this.first.getEnd();
            }
        }

        @Override
        public String getName() {
            int currentIndex = BookmarksImpl.this.bookmarksTables.getDescriptorFirstIndex(this.first);
            try {
                return BookmarksImpl.this.bookmarksTables.getName(currentIndex);
            }
            catch (ArrayIndexOutOfBoundsException exc) {
                return "";
            }
        }

        @Override
        public int getStart() {
            return this.first.getStart();
        }

        public int hashCode() {
            return 31 + (this.first == null ? 0 : this.first.hashCode());
        }

        @Override
        public void setName(String name) {
            int currentIndex = BookmarksImpl.this.bookmarksTables.getDescriptorFirstIndex(this.first);
            BookmarksImpl.this.bookmarksTables.setName(currentIndex, name);
        }

        public String toString() {
            return "Bookmark [" + this.getStart() + "; " + this.getEnd() + "): name: " + this.getName();
        }
    }
}

