/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.POIListLevel;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.BitField;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.BitFieldFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.Internal;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.util.Arrays;

@Internal
public final class POIListData {
    private int _lsid;
    private int _tplc;
    private short[] _rgistd;
    private byte _info;
    private static BitField _fSimpleList = BitFieldFactory.getInstance(1);
    private static BitField _fRestartHdn = BitFieldFactory.getInstance(2);
    private byte _reserved;
    POIListLevel[] _levels;

    public POIListData(int listID, boolean numbered) {
        int x;
        this._lsid = listID;
        this._rgistd = new short[9];
        for (x = 0; x < 9; ++x) {
            this._rgistd[x] = 4095;
        }
        this._levels = new POIListLevel[9];
        for (x = 0; x < this._levels.length; ++x) {
            this._levels[x] = new POIListLevel(x, numbered);
        }
    }

    POIListData(byte[] buf, int offset) {
        this._lsid = LittleEndian.getInt(buf, offset);
        this._tplc = LittleEndian.getInt(buf, offset += 4);
        offset += 4;
        this._rgistd = new short[9];
        for (int x = 0; x < 9; ++x) {
            this._rgistd[x] = LittleEndian.getShort(buf, offset);
            offset += 2;
        }
        this._info = buf[offset++];
        this._reserved = buf[offset];
        this._levels = _fSimpleList.getValue(this._info) > 0 ? new POIListLevel[1] : new POIListLevel[9];
    }

    public int getLsid() {
        return this._lsid;
    }

    public int numLevels() {
        return this._levels.length;
    }

    public void setLevel(int index, POIListLevel level) {
        this._levels[index] = level;
    }

    public POIListLevel[] getLevels() {
        return this._levels;
    }

    public POIListLevel getLevel(int index) {
        return this._levels[index - 1];
    }

    public int getLevelStyle(int index) {
        return this._rgistd[index];
    }

    public void setLevelStyle(int index, int styleIndex) {
        this._rgistd[index] = (short)styleIndex;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        POIListData lst = (POIListData)obj;
        return lst._info == this._info && Arrays.equals(lst._levels, this._levels) && lst._lsid == this._lsid && lst._reserved == this._reserved && lst._tplc == this._tplc && Arrays.equals(lst._rgistd, this._rgistd);
    }

    int resetListID() {
        this._lsid = (int)(Math.random() * (double)System.currentTimeMillis());
        return this._lsid;
    }

    public byte[] toByteArray() {
        byte[] buf = new byte[28];
        int offset = 0;
        LittleEndian.putInt(buf, this._lsid);
        LittleEndian.putInt(buf, offset += 4, this._tplc);
        offset += 4;
        for (int x = 0; x < 9; ++x) {
            LittleEndian.putShort(buf, offset, this._rgistd[x]);
            offset += 2;
        }
        buf[offset++] = this._info;
        buf[offset] = this._reserved;
        return buf;
    }
}

