/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.FSPA;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.FSPADocumentPart;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.FileInformationBlock;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.GenericPropertyNode;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.PlexOfCps;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.TextPiece;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.Internal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@Internal
public final class FSPATable {
    private final Map<Integer, GenericPropertyNode> _byStart = new LinkedHashMap<Integer, GenericPropertyNode>();

    public FSPATable(byte[] tableStream, FileInformationBlock fib, FSPADocumentPart part) {
        int offset = fib.getFSPAPlcfOffset(part);
        int length = fib.getFSPAPlcfLength(part);
        PlexOfCps plex = new PlexOfCps(tableStream, offset, length, FSPA.getSize());
        for (int i = 0; i < plex.length(); ++i) {
            GenericPropertyNode property = plex.getProperty(i);
            this._byStart.put(property.getStart(), property);
        }
    }

    @Deprecated
    public FSPATable(byte[] tableStream, int fcPlcspa, int lcbPlcspa, List<TextPiece> tpt) {
        if (fcPlcspa == 0) {
            return;
        }
        PlexOfCps plex = new PlexOfCps(tableStream, fcPlcspa, lcbPlcspa, FSPA.FSPA_SIZE);
        for (int i = 0; i < plex.length(); ++i) {
            GenericPropertyNode property = plex.getProperty(i);
            this._byStart.put(property.getStart(), property);
        }
    }

    public FSPA getFspaFromCp(int cp) {
        GenericPropertyNode propertyNode = this._byStart.get(cp);
        if (propertyNode == null) {
            return null;
        }
        return new FSPA(propertyNode.getBytes(), 0);
    }

    public FSPA[] getShapes() {
        ArrayList<FSPA> result = new ArrayList<FSPA>(this._byStart.size());
        for (GenericPropertyNode propertyNode : this._byStart.values()) {
            result.add(new FSPA(propertyNode.getBytes(), 0));
        }
        return result.toArray(new FSPA[result.size()]);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("[FPSA PLC size=").append(this._byStart.size()).append("]\n");
        for (Map.Entry<Integer, GenericPropertyNode> entry : this._byStart.entrySet()) {
            Integer i = entry.getKey();
            buf.append("  ").append(i.toString()).append(" => \t");
            try {
                FSPA fspa = this.getFspaFromCp(i);
                buf.append(fspa.toString());
            }
            catch (Exception exc) {
                buf.append(exc.getMessage());
            }
            buf.append("\n");
        }
        buf.append("[/FSPA PLC]");
        return buf.toString();
    }
}

