/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.util.Internal;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;

@Internal
public final class FIBLongHandler {
    public static final int CBMAC = 0;
    public static final int PRODUCTCREATED = 1;
    public static final int PRODUCTREVISED = 2;
    public static final int CCPTEXT = 3;
    public static final int CCPFTN = 4;
    public static final int CCPHDD = 5;
    public static final int CCPMCR = 6;
    public static final int CCPATN = 7;
    public static final int CCPEDN = 8;
    public static final int CCPTXBX = 9;
    public static final int CCPHDRTXBX = 10;
    public static final int PNFBPCHPFIRST = 11;
    public static final int PNCHPFIRST = 12;
    public static final int CPNBTECHP = 13;
    public static final int PNFBPPAPFIRST = 14;
    public static final int PNPAPFIRST = 15;
    public static final int CPNBTEPAP = 16;
    public static final int PNFBPLVCFIRST = 17;
    public static final int PNLVCFIRST = 18;
    public static final int CPNBTELVC = 19;
    public static final int FCISLANDFIRST = 20;
    public static final int FCISLANDLIM = 21;
    int[] _longs;

    public FIBLongHandler(byte[] mainStream, int offset) {
        int longCount = LittleEndian.getShort(mainStream, offset);
        offset += 2;
        this._longs = new int[longCount];
        for (int x = 0; x < longCount; ++x) {
            this._longs[x] = LittleEndian.getInt(mainStream, offset + x * 4);
        }
    }

    public int getLong(int longCode) {
        return this._longs[longCode];
    }

    public void setLong(int longCode, int value) {
        this._longs[longCode] = value;
    }

    void serialize(byte[] mainStream, int offset) {
        LittleEndian.putShort(mainStream, offset, (short)this._longs.length);
        offset += 2;
        for (int x = 0; x < this._longs.length; ++x) {
            LittleEndian.putInt(mainStream, offset, this._longs[x]);
            offset += 4;
        }
    }

    int sizeInBytes() {
        return this._longs.length * 4 + 2;
    }
}

