/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.BookmarkFirstDescriptor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.FileInformationBlock;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.GenericPropertyNode;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.PlexOfCps;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.SttbfUtils;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.model.io.HWPFOutputStream;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.Internal;
import java.io.IOException;
import java.util.Arrays;

@Internal
public class BookmarksTables {
    private PlexOfCps descriptorsFirst = new PlexOfCps(4);
    private PlexOfCps descriptorsLim = new PlexOfCps(0);
    private String[] names = new String[0];

    public BookmarksTables(byte[] tableStream, FileInformationBlock fib) {
        this.read(tableStream, fib);
    }

    public int getBookmarksCount() {
        return this.descriptorsFirst.length();
    }

    public GenericPropertyNode getDescriptorFirst(int index) throws IndexOutOfBoundsException {
        return this.descriptorsFirst.getProperty(index);
    }

    public int getDescriptorFirstIndex(GenericPropertyNode descriptorFirst) {
        return Arrays.asList(this.descriptorsFirst.toPropertiesArray()).indexOf(descriptorFirst);
    }

    public GenericPropertyNode getDescriptorLim(int index) throws IndexOutOfBoundsException {
        return this.descriptorsLim.getProperty(index);
    }

    public int getDescriptorsFirstCount() {
        return this.descriptorsFirst.length();
    }

    public int getDescriptorsLimCount() {
        return this.descriptorsLim.length();
    }

    public String getName(int index) throws ArrayIndexOutOfBoundsException {
        return this.names[index];
    }

    public int getNamesCount() {
        return this.names.length;
    }

    private void read(byte[] tableStream, FileInformationBlock fib) {
        int namesStart = fib.getFcSttbfbkmk();
        int namesLength = fib.getLcbSttbfbkmk();
        if (namesStart != 0 && namesLength != 0) {
            this.names = SttbfUtils.read(tableStream, namesStart);
        }
        int firstDescriptorsStart = fib.getFcPlcfbkf();
        int firstDescriptorsLength = fib.getLcbPlcfbkf();
        if (firstDescriptorsStart != 0 && firstDescriptorsLength != 0) {
            this.descriptorsFirst = new PlexOfCps(tableStream, firstDescriptorsStart, firstDescriptorsLength, BookmarkFirstDescriptor.getSize());
        }
        int limDescriptorsStart = fib.getFcPlcfbkl();
        int limDescriptorsLength = fib.getLcbPlcfbkl();
        if (limDescriptorsStart != 0 && limDescriptorsLength != 0) {
            this.descriptorsLim = new PlexOfCps(tableStream, limDescriptorsStart, limDescriptorsLength, 0);
        }
    }

    public void setName(int index, String name) {
        if (index < this.names.length) {
            String[] newNames = new String[index + 1];
            System.arraycopy(this.names, 0, newNames, 0, this.names.length);
            this.names = newNames;
        }
        this.names[index] = name;
    }

    public void writePlcfBkmkf(FileInformationBlock fib, HWPFOutputStream tableStream) throws IOException {
        if (this.descriptorsFirst == null || this.descriptorsFirst.length() == 0) {
            fib.setFcPlcfbkf(0);
            fib.setLcbPlcfbkf(0);
            return;
        }
        int start = tableStream.getOffset();
        tableStream.write(this.descriptorsFirst.toByteArray());
        int end = tableStream.getOffset();
        fib.setFcPlcfbkf(start);
        fib.setLcbPlcfbkf(end - start);
    }

    public void writePlcfBkmkl(FileInformationBlock fib, HWPFOutputStream tableStream) throws IOException {
        if (this.descriptorsLim == null || this.descriptorsLim.length() == 0) {
            fib.setFcPlcfbkl(0);
            fib.setLcbPlcfbkl(0);
            return;
        }
        int start = tableStream.getOffset();
        tableStream.write(this.descriptorsLim.toByteArray());
        int end = tableStream.getOffset();
        fib.setFcPlcfbkl(start);
        fib.setLcbPlcfbkl(end - start);
    }

    public void writeSttbfBkmk(FileInformationBlock fib, HWPFOutputStream tableStream) throws IOException {
        if (this.names == null || this.names.length == 0) {
            fib.setFcSttbfbkmk(0);
            fib.setLcbSttbfbkmk(0);
            return;
        }
        int start = tableStream.getOffset();
        SttbfUtils.write(tableStream, this.names);
        int end = tableStream.getOffset();
        fib.setFcSttbfbkmk(start);
        fib.setLcbSttbfbkmk(end - start);
    }
}

