/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.ShapeKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherChildAnchorRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherClientAnchorRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherClientDataRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherPropertyFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSimpleProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpgrRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.CommonObjectDataSubRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.EmbeddedObjectRefSubRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.ObjRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.SubRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFAnchor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFAutoShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFChart;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFClientAnchor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFFreeform;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFLine;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFPicture;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFShapeGroup;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFSimpleShape;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.AWorkbook;
import java.util.List;
import java.util.Map;

public final class HSSFShapeFactory {
    public static HSSFShape createShape(AWorkbook workbook, Map<EscherRecord, Record> shapeToObj, EscherContainerRecord spContainer, HSSFShape parent) {
        if (spContainer.getRecordId() == -4093) {
            return HSSFShapeFactory.createShapeGroup(workbook, shapeToObj, spContainer, parent);
        }
        return HSSFShapeFactory.createSimpeShape(workbook, shapeToObj, spContainer, parent);
    }

    public static HSSFShapeGroup createShapeGroup(AWorkbook workbook, Map<EscherRecord, Record> shapeToObj, EscherContainerRecord spContainer, HSSFShape parent) {
        HSSFShapeGroup group = null;
        List<EscherRecord> childRecords = spContainer.getChildRecords();
        if (childRecords.size() > 0) {
            EscherRecord opt;
            EscherContainerRecord groupContainer = (EscherContainerRecord)childRecords.get(0);
            HSSFAnchor anchor = null;
            if (parent == null) {
                EscherClientAnchorRecord anchorRecord = (EscherClientAnchorRecord)ShapeKit.getEscherChild(groupContainer, -4080);
                if (anchorRecord != null && anchorRecord.getCol2() <= 255 && anchorRecord.getRow2() <= 65535) {
                    anchor = HSSFShape.toClientAnchor(anchorRecord);
                }
            } else {
                EscherChildAnchorRecord childRecord = (EscherChildAnchorRecord)ShapeKit.getEscherChild(groupContainer, -4081);
                if (childRecord != null) {
                    anchor = HSSFShape.toChildAnchor(childRecord);
                }
            }
            if (anchor == null) {
                anchor = new HSSFClientAnchor();
            }
            if ((opt = ShapeKit.getEscherChild(groupContainer, -3806)) != null) {
                EscherPropertyFactory f = new EscherPropertyFactory();
                List<EscherProperty> props = f.createProperties(opt.serialize(), 8, opt.getInstance());
                EscherSimpleProperty p = (EscherSimpleProperty)props.get(0);
                if (p.getPropertyNumber() != 927 || p.getPropertyValue() != 1) {
                    group = new HSSFShapeGroup(groupContainer, parent, anchor);
                }
            } else {
                group = new HSSFShapeGroup(groupContainer, parent, anchor);
            }
            EscherSpgrRecord spgrRecord = (EscherSpgrRecord)ShapeKit.getEscherChild(groupContainer, -4087);
            if (spgrRecord != null) {
                group.setCoordinates(spgrRecord.getRectX1(), spgrRecord.getRectY1(), spgrRecord.getRectX2(), spgrRecord.getRectY2());
            }
            for (int i = 1; i < childRecords.size(); ++i) {
                HSSFShape shape = HSSFShapeFactory.createShape(workbook, shapeToObj, (EscherContainerRecord)childRecords.get(i), group);
                group.addChildShape(shape);
            }
        }
        return group;
    }

    public static HSSFShape createSimpeShape(AWorkbook workbook, Map<EscherRecord, Record> shapeToObj, EscherContainerRecord spContainer, HSSFShape parent) {
        HSSFSimpleShape shape = null;
        HSSFAnchor anchor = null;
        if (parent == null) {
            EscherClientAnchorRecord anchorRecord = (EscherClientAnchorRecord)ShapeKit.getEscherChild(spContainer, -4080);
            if (anchorRecord != null && anchorRecord.getCol2() <= 255 && anchorRecord.getRow2() <= 65535) {
                anchor = HSSFShape.toClientAnchor(anchorRecord);
            }
        } else {
            EscherChildAnchorRecord childRecord = (EscherChildAnchorRecord)ShapeKit.getEscherChild(spContainer, -4081);
            if (childRecord != null) {
                anchor = HSSFShape.toChildAnchor(childRecord);
            }
        }
        EscherSpRecord spRecord = (EscherSpRecord)spContainer.getChildById((short)-4086);
        if (spRecord == null) {
            return null;
        }
        int type = spRecord.getOptions() >> 4;
        switch (type) {
            case 202: {
                if (shapeToObj != null && shapeToObj.size() > 0) {
                    CommonObjectDataSubRecord commonObjectDataSubRecord;
                    EscherClientDataRecord escherClientDataRecord = (EscherClientDataRecord)ShapeKit.getEscherChild(spContainer, -4079);
                    Record record = shapeToObj.get(escherClientDataRecord);
                    if (!(record instanceof ObjRecord) || !(((ObjRecord)record).getSubRecords().get(0) instanceof CommonObjectDataSubRecord) || (commonObjectDataSubRecord = (CommonObjectDataSubRecord)((ObjRecord)record).getSubRecords().get(0)).getObjectType() == 25) break;
                    shape = new HSSFAutoShape(workbook, spContainer, parent, anchor, type);
                    break;
                }
            }
            case 75: {
                EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(spContainer, -4085);
                EscherSimpleProperty prop = (EscherSimpleProperty)opt.lookup(260);
                shape = new HSSFPicture(workbook, spContainer, parent, anchor, opt);
                if (prop == null) break;
                ((HSSFPicture)shape).setPictureIndex(prop.getPropertyValue());
                break;
            }
            case 201: {
                shape = new HSSFChart(workbook, spContainer, parent, anchor);
                break;
            }
            case 20: 
            case 32: 
            case 33: 
            case 34: 
            case 38: {
                shape = new HSSFLine(workbook, spContainer, parent, anchor, type);
                break;
            }
            case 0: 
            case 100: {
                shape = new HSSFFreeform(workbook, spContainer, parent, anchor, type);
                break;
            }
            default: {
                shape = new HSSFAutoShape(workbook, spContainer, parent, anchor, type);
                ((HSSFAutoShape)shape).setAdjustmentValue(spContainer);
            }
        }
        return shape;
    }

    private static boolean isEmbeddedObject(ObjRecord obj) {
        for (SubRecord sub : obj.getSubRecords()) {
            if (!(sub instanceof EmbeddedObjectRefSubRecord)) continue;
            return true;
        }
        return false;
    }
}

