/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.EmbeddedObjectRefSubRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.ObjRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.SubRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.DirectoryEntry;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.Entry;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.HexDump;
import java.io.IOException;

public final class HSSFObjectData {
    private final ObjRecord _record;
    private final DirectoryEntry _root;

    public HSSFObjectData(ObjRecord record, DirectoryEntry root) {
        this._record = record;
        this._root = root;
    }

    public String getOLE2ClassName() {
        return this.findObjectRecord().getOLEClassName();
    }

    public DirectoryEntry getDirectory() throws IOException {
        EmbeddedObjectRefSubRecord subRecord = this.findObjectRecord();
        int streamId = subRecord.getStreamId();
        String streamName = "MBD" + HexDump.toHex(streamId);
        Entry entry = this._root.getEntry(streamName);
        if (entry instanceof DirectoryEntry) {
            return (DirectoryEntry)entry;
        }
        throw new IOException("Stream " + streamName + " was not an OLE2 directory");
    }

    public byte[] getObjectData() {
        return this.findObjectRecord().getObjectData();
    }

    public boolean hasDirectoryEntry() {
        EmbeddedObjectRefSubRecord subRecord = this.findObjectRecord();
        Integer streamId = subRecord.getStreamId();
        return streamId != null && streamId != 0;
    }

    protected EmbeddedObjectRefSubRecord findObjectRecord() {
        for (SubRecord subRecord : this._record.getSubRecords()) {
            if (!(subRecord instanceof EmbeddedObjectRefSubRecord)) continue;
            return (EmbeddedObjectRefSubRecord)subRecord;
        }
        throw new IllegalStateException("Object data does not contain a reference to an embedded object OLE2 directory");
    }
}

