/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.InternalWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.FormatRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.BuiltinFormats;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.DataFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;

public final class HSSFDataFormat
implements DataFormat {
    private static final String[] _builtinFormats = BuiltinFormats.getAll();
    private final Vector<String> _formats = new Vector();
    private final InternalWorkbook _workbook;
    private boolean _movedBuiltins = false;

    HSSFDataFormat(InternalWorkbook workbook) {
        this._workbook = workbook;
        for (FormatRecord r : workbook.getFormats()) {
            this.ensureFormatsSize(r.getIndexCode());
            this._formats.set(r.getIndexCode(), r.getFormatString());
        }
    }

    public static List<String> getBuiltinFormats() {
        return Arrays.asList(_builtinFormats);
    }

    public static short getBuiltinFormat(String format) {
        return (short)BuiltinFormats.getBuiltinFormat(format);
    }

    @Override
    public short getFormat(String pFormat) {
        int i;
        String format = pFormat.toUpperCase().equals("TEXT") ? "@" : pFormat;
        if (!this._movedBuiltins) {
            for (i = 0; i < _builtinFormats.length; ++i) {
                this.ensureFormatsSize(i);
                if (this._formats.get(i) != null) continue;
                this._formats.set(i, _builtinFormats[i]);
            }
            this._movedBuiltins = true;
        }
        for (i = 0; i < this._formats.size(); ++i) {
            if (!format.equals(this._formats.get(i))) continue;
            return (short)i;
        }
        short index = this._workbook.getFormat(format, true);
        this.ensureFormatsSize(index);
        this._formats.set(index, format);
        return index;
    }

    public static String getFormatCode(InternalWorkbook workbook, short index) {
        if (index == -1) {
            return null;
        }
        for (FormatRecord r : workbook.getFormats()) {
            if (index != r.getIndexCode()) continue;
            return r.getFormatString();
        }
        if (_builtinFormats.length > index && _builtinFormats[index] != null) {
            return _builtinFormats[index];
        }
        return null;
    }

    @Override
    public String getFormat(short index) {
        String fmt;
        if (this._movedBuiltins) {
            return this._formats.get(index);
        }
        if (index == -1) {
            return null;
        }
        String string2 = fmt = this._formats.size() > index ? this._formats.get(index) : null;
        if (_builtinFormats.length > index && _builtinFormats[index] != null) {
            if (fmt != null) {
                return fmt;
            }
            return _builtinFormats[index];
        }
        return fmt;
    }

    public static String getBuiltinFormat(short index) {
        return BuiltinFormats.getBuiltinFormat(index);
    }

    public static int getNumberOfBuiltinBuiltinFormats() {
        return _builtinFormats.length;
    }

    private void ensureFormatsSize(int index) {
        if (this._formats.size() <= index) {
            this._formats.setSize(index + 1);
        }
    }
}

