/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.chart;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.RecordInputStream;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.StandardRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.BitField;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.BitFieldFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.HexDump;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndianOutput;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.StringUtil;

public final class DataLabelExtensionRecord
extends StandardRecord {
    public static final short sid = 2155;
    private static final BitField showSeriesName = BitFieldFactory.getInstance(1);
    private static final BitField showCategoryName = BitFieldFactory.getInstance(2);
    private static final BitField showValue = BitFieldFactory.getInstance(4);
    private static final BitField showPercent = BitFieldFactory.getInstance(8);
    private static final BitField showBubbleSizes = BitFieldFactory.getInstance(16);
    private int rt;
    private int grbitFrt;
    private byte[] unused = new byte[8];
    private short grbit;
    private short cchSep;
    private String rgchSep;

    public DataLabelExtensionRecord(RecordInputStream in) {
        this.rt = in.readShort();
        this.grbitFrt = in.readShort();
        in.readFully(this.unused);
        this.grbit = in.readShort();
        this.cchSep = in.readShort();
        byte[] datas = new byte[in.available()];
        in.readFully(datas);
        this.rgchSep = StringUtil.getFromUnicodeLE(datas);
    }

    @Override
    protected int getDataSize() {
        return 12;
    }

    @Override
    public short getSid() {
        return 2155;
    }

    public boolean isShowSeriesName() {
        return showSeriesName.isSet(this.grbit);
    }

    public boolean isShowCategoryName() {
        return showCategoryName.isSet(this.grbit);
    }

    public boolean isShowValue() {
        return showValue.isSet(this.grbit);
    }

    public boolean isShowPercent() {
        return showPercent.isSet(this.grbit);
    }

    public boolean isShowBubbleSizes() {
        return showBubbleSizes.isSet(this.grbit);
    }

    public String getSeparator() {
        return this.rgchSep;
    }

    @Override
    protected void serialize(LittleEndianOutput out) {
        out.writeShort(this.rt);
        out.writeShort(this.grbitFrt);
        out.write(this.unused);
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[DATALABEXT]\n");
        buffer.append("    .rt      =").append(HexDump.shortToHex(this.rt)).append('\n');
        buffer.append("    .grbitFrt=").append(HexDump.shortToHex(this.grbitFrt)).append('\n');
        buffer.append("    .unused  =").append(HexDump.toHex(this.unused)).append('\n');
        buffer.append("[/DATALABEXT]\n");
        return buffer.toString();
    }
}

