/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.aggregates;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.FormulaShifter;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.model.RecordStream;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.CFHeaderRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.aggregates.CFRecordsAggregate;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.record.aggregates.RecordAggregate;
import java.util.ArrayList;
import java.util.List;

public final class ConditionalFormattingTable
extends RecordAggregate {
    private final List _cfHeaders;

    public ConditionalFormattingTable() {
        this._cfHeaders = new ArrayList();
    }

    public ConditionalFormattingTable(RecordStream rs) {
        ArrayList<CFRecordsAggregate> temp = new ArrayList<CFRecordsAggregate>();
        while (rs.peekNextClass() == CFHeaderRecord.class) {
            temp.add(CFRecordsAggregate.createCFAggregate(rs));
        }
        this._cfHeaders = temp;
    }

    @Override
    public void visitContainedRecords(RecordAggregate.RecordVisitor rv) {
        for (int i = 0; i < this._cfHeaders.size(); ++i) {
            CFRecordsAggregate subAgg = (CFRecordsAggregate)this._cfHeaders.get(i);
            subAgg.visitContainedRecords(rv);
        }
    }

    public int add(CFRecordsAggregate cfAggregate) {
        this._cfHeaders.add(cfAggregate);
        return this._cfHeaders.size() - 1;
    }

    public int size() {
        return this._cfHeaders.size();
    }

    public CFRecordsAggregate get(int index) {
        this.checkIndex(index);
        return (CFRecordsAggregate)this._cfHeaders.get(index);
    }

    public void remove(int index) {
        this.checkIndex(index);
        this._cfHeaders.remove(index);
    }

    private void checkIndex(int index) {
        if (index < 0 || index >= this._cfHeaders.size()) {
            throw new IllegalArgumentException("Specified CF index " + index + " is outside the allowable range (0.." + (this._cfHeaders.size() - 1) + ")");
        }
    }

    public void updateFormulasAfterCellShift(FormulaShifter shifter, int externSheetIndex) {
        for (int i = 0; i < this._cfHeaders.size(); ++i) {
            CFRecordsAggregate subAgg = (CFRecordsAggregate)this._cfHeaders.get(i);
            boolean shouldKeep = subAgg.updateFormulasAfterCellShift(shifter, externSheetIndex);
            if (shouldKeep) continue;
            this._cfHeaders.remove(i);
            --i;
        }
    }
}

