/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ErrorEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.EvaluationException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.NotImplementedException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.OperandResolver;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ValueEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.AggregateFunction;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.Count;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.Counta;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.Function;

public class Subtotal
implements Function {
    private static Function findFunction(int functionCode) throws EvaluationException {
        switch (functionCode) {
            case 1: {
                return AggregateFunction.subtotalInstance(AggregateFunction.AVERAGE);
            }
            case 2: {
                return Count.subtotalInstance();
            }
            case 3: {
                return Counta.subtotalInstance();
            }
            case 4: {
                return AggregateFunction.subtotalInstance(AggregateFunction.MAX);
            }
            case 5: {
                return AggregateFunction.subtotalInstance(AggregateFunction.MIN);
            }
            case 6: {
                return AggregateFunction.subtotalInstance(AggregateFunction.PRODUCT);
            }
            case 7: {
                return AggregateFunction.subtotalInstance(AggregateFunction.STDEV);
            }
            case 8: {
                throw new NotImplementedException("STDEVP");
            }
            case 9: {
                return AggregateFunction.subtotalInstance(AggregateFunction.SUM);
            }
            case 10: {
                throw new NotImplementedException("VAR");
            }
            case 11: {
                throw new NotImplementedException("VARP");
            }
        }
        if (functionCode > 100 && functionCode < 112) {
            throw new NotImplementedException("SUBTOTAL - with 'exclude hidden values' option");
        }
        throw EvaluationException.invalidValue();
    }

    @Override
    public ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        Function innerFunc;
        int nInnerArgs = args.length - 1;
        if (nInnerArgs < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            ValueEval ve = OperandResolver.getSingleValue(args[0], srcRowIndex, srcColumnIndex);
            int functionCode = OperandResolver.coerceValueToInt(ve);
            innerFunc = Subtotal.findFunction(functionCode);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        ValueEval[] innerArgs = new ValueEval[nInnerArgs];
        System.arraycopy(args, 1, innerArgs, 0, nInnerArgs);
        return innerFunc.evaluate(innerArgs, srcRowIndex, srcColumnIndex);
    }
}

