/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.CollaboratingWorkbooksEnvironment;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.EvaluationCell;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.EvaluationWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.IStabilityClassifier;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.WorkbookEvaluator;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.BoolEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ErrorEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ForkedEvaluationCell;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ForkedEvaluationWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.NumberEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.StringEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ValueEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.udf.UDFFinder;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.usermodel.HSSFEvaluationWorkbook;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.Workbook;
import com.ahmadullahpk.alldocumentreader.xs.ss.model.XLSModel.AWorkbook;

public final class ForkedEvaluator {
    private WorkbookEvaluator _evaluator;
    private ForkedEvaluationWorkbook _sewb;

    private ForkedEvaluator(EvaluationWorkbook masterWorkbook, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder) {
        this._sewb = new ForkedEvaluationWorkbook(masterWorkbook);
        this._evaluator = new WorkbookEvaluator(this._sewb, stabilityClassifier, udfFinder);
    }

    private static EvaluationWorkbook createEvaluationWorkbook(Workbook wb) {
        if (wb instanceof AWorkbook) {
            return HSSFEvaluationWorkbook.create((AWorkbook)wb);
        }
        throw new IllegalArgumentException("Unexpected workbook type (" + wb.getClass().getName() + ")");
    }

    public static ForkedEvaluator create(Workbook wb, IStabilityClassifier stabilityClassifier) {
        return ForkedEvaluator.create(wb, stabilityClassifier, null);
    }

    public static ForkedEvaluator create(Workbook wb, IStabilityClassifier stabilityClassifier, UDFFinder udfFinder) {
        return new ForkedEvaluator(ForkedEvaluator.createEvaluationWorkbook(wb), stabilityClassifier, udfFinder);
    }

    public void updateCell(String sheetName, int rowIndex, int columnIndex, ValueEval value) {
        ForkedEvaluationCell cell = this._sewb.getOrCreateUpdatableCell(sheetName, rowIndex, columnIndex);
        cell.setValue(value);
        this._evaluator.notifyUpdateCell(cell);
    }

    public void copyUpdatedCells(Workbook workbook) {
        this._sewb.copyUpdatedCells(workbook);
    }

    public ValueEval evaluate(String sheetName, int rowIndex, int columnIndex) {
        EvaluationCell cell = this._sewb.getEvaluationCell(sheetName, rowIndex, columnIndex);
        switch (cell.getCellType()) {
            case 4: {
                return BoolEval.valueOf(cell.getBooleanCellValue());
            }
            case 5: {
                return ErrorEval.valueOf(cell.getErrorCellValue());
            }
            case 2: {
                return this._evaluator.evaluate(cell);
            }
            case 0: {
                return new NumberEval(cell.getNumericCellValue());
            }
            case 1: {
                return new StringEval(cell.getStringCellValue());
            }
            case 3: {
                return null;
            }
        }
        throw new IllegalStateException("Bad cell type (" + cell.getCellType() + ")");
    }

    public static void setupEnvironment(String[] workbookNames, ForkedEvaluator[] evaluators) {
        WorkbookEvaluator[] wbEvals = new WorkbookEvaluator[evaluators.length];
        for (int i = 0; i < wbEvals.length; ++i) {
            wbEvals[i] = evaluators[i]._evaluator;
        }
        CollaboratingWorkbooksEnvironment.setup(workbookNames, wbEvals);
    }
}

