/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.EvaluationCell;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.EvaluationSheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.BlankEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.BoolEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ErrorEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ForkedEvaluationSheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.NumberEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.StringEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ValueEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.ss.usermodel.ICell;

final class ForkedEvaluationCell
implements EvaluationCell {
    private final EvaluationSheet _sheet;
    private final EvaluationCell _masterCell;
    private boolean _booleanValue;
    private int _cellType;
    private int _errorValue;
    private double _numberValue;
    private String _stringValue;

    public ForkedEvaluationCell(ForkedEvaluationSheet sheet, EvaluationCell masterCell) {
        this._sheet = sheet;
        this._masterCell = masterCell;
        this.setValue(BlankEval.instance);
    }

    @Override
    public Object getIdentityKey() {
        return this._masterCell.getIdentityKey();
    }

    public void setValue(ValueEval value) {
        Class<?> cls = value.getClass();
        if (cls == NumberEval.class) {
            this._cellType = 0;
            this._numberValue = ((NumberEval)value).getNumberValue();
            return;
        }
        if (cls == StringEval.class) {
            this._cellType = 1;
            this._stringValue = ((StringEval)value).getStringValue();
            return;
        }
        if (cls == BoolEval.class) {
            this._cellType = 4;
            this._booleanValue = ((BoolEval)value).getBooleanValue();
            return;
        }
        if (cls == ErrorEval.class) {
            this._cellType = 5;
            this._errorValue = ((ErrorEval)value).getErrorCode();
            return;
        }
        if (cls == BlankEval.class) {
            this._cellType = 3;
            return;
        }
        throw new IllegalArgumentException("Unexpected value class (" + cls.getName() + ")");
    }

    public void copyValue(ICell destCell) {
        switch (this._cellType) {
            case 3: {
                destCell.setCellType(3);
                return;
            }
            case 0: {
                destCell.setCellValue(this._numberValue);
                return;
            }
            case 4: {
                destCell.setCellValue(this._booleanValue);
                return;
            }
            case 1: {
                destCell.setCellValue(this._stringValue);
                return;
            }
            case 5: {
                destCell.setCellErrorValue((byte)this._errorValue);
                return;
            }
        }
        throw new IllegalStateException("Unexpected data type (" + this._cellType + ")");
    }

    private void checkCellType(int expectedCellType) {
        if (this._cellType != expectedCellType) {
            throw new RuntimeException("Wrong data type (" + this._cellType + ")");
        }
    }

    @Override
    public int getCellType() {
        return this._cellType;
    }

    @Override
    public boolean getBooleanCellValue() {
        this.checkCellType(4);
        return this._booleanValue;
    }

    @Override
    public int getErrorCellValue() {
        this.checkCellType(5);
        return this._errorValue;
    }

    @Override
    public double getNumericCellValue() {
        this.checkCellType(0);
        return this._numberValue;
    }

    @Override
    public String getStringCellValue() {
        this.checkCellType(1);
        return this._stringValue;
    }

    @Override
    public EvaluationSheet getSheet() {
        return this._sheet;
    }

    @Override
    public int getRowIndex() {
        return this._masterCell.getRowIndex();
    }

    @Override
    public int getColumnIndex() {
        return this._masterCell.getColumnIndex();
    }
}

