/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.atp;

import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.OperationEvaluationContext;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ErrorEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.EvaluationException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.NumberEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.OperandResolver;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.eval.ValueEval;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.FreeRefFunction;
import com.ahmadullahpk.alldocumentreader.xs.fc.hssf.formula.function.NumericFunction;

final class MRound
implements FreeRefFunction {
    public static final FreeRefFunction instance = new MRound();

    private MRound() {
    }

    @Override
    public ValueEval evaluate(ValueEval[] args, OperationEvaluationContext ec) {
        if (args.length != 2) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            double result;
            double number = OperandResolver.coerceValueToDouble(OperandResolver.getSingleValue(args[0], ec.getRowIndex(), ec.getColumnIndex()));
            double multiple = OperandResolver.coerceValueToDouble(OperandResolver.getSingleValue(args[1], ec.getRowIndex(), ec.getColumnIndex()));
            if (multiple == 0.0) {
                result = 0.0;
            } else {
                if (number * multiple < 0.0) {
                    throw new EvaluationException(ErrorEval.NUM_ERROR);
                }
                result = multiple * (double)Math.round(number / multiple);
            }
            NumericFunction.checkValue(result);
            return new NumberEval(result);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
    }
}

