/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.HSLFSlideShow;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.exceptions.CorruptPowerPointFileException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.HeadersFooters;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Hyperlink;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.MasterSheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Notes;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.SlideMaster;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.TitleMaster;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Document;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.DocumentAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExAviMovie;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExControl;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExHyperlink;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExHyperlinkAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExMCIMovie;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExObjList;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExObjListAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExOleObjAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExVideoContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExtendedParagraphHeaderAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExtendedPresRuleContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.FontCollection;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.HeadersFootersContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.MainMaster;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.PersistPtrHolder;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.PositionDependentRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.PositionDependentRecordContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordTypes;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Slide;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.SlideListWithText;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.SlidePersistAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.usermodel.ObjectData;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.usermodel.PictureData;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.usermodel.SoundData;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class SlideShow {
    private HSLFSlideShow _hslfSlideShow;
    private Record[] _records;
    private Record[] _mostRecentCoreRecords;
    private Hashtable<Integer, Integer> _sheetIdToCoreRecordsLookup;
    private Document _documentRecord;
    private SlideMaster[] _masters;
    private TitleMaster[] _titleMasters;
    private com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Slide[] _slides;
    private Notes[] _notes;
    private FontCollection _fonts;
    private boolean isGetThumbnail;

    public SlideShow(HSLFSlideShow hslfSlideShow) {
        this(hslfSlideShow, false);
    }

    public SlideShow(HSLFSlideShow hslfSlideShow, boolean isGetThumbnail) {
        this._hslfSlideShow = hslfSlideShow;
        this._records = this._hslfSlideShow.getRecords();
        this.isGetThumbnail = isGetThumbnail;
        for (Record record : this._records) {
            if (!(record instanceof RecordContainer)) continue;
            RecordContainer.handleParentAwareRecords((RecordContainer)record);
        }
        this.findMostRecentCoreRecords();
        this.buildSlidesAndNotes();
    }

    private void findMostRecentCoreRecords() {
        int i;
        Hashtable<Integer, Integer> mostRecentByBytes = new Hashtable<Integer, Integer>();
        for (int i2 = 0; i2 < this._records.length; ++i2) {
            if (!(this._records[i2] instanceof PersistPtrHolder)) continue;
            PersistPtrHolder pph = (PersistPtrHolder)this._records[i2];
            int[] ids = pph.getKnownSlideIDs();
            for (int j = 0; j < ids.length; ++j) {
                Integer id2 = ids[j];
                if (!mostRecentByBytes.containsKey(id2)) continue;
                mostRecentByBytes.remove(id2);
            }
            Hashtable<Integer, Integer> thisSetOfLocations = pph.getSlideLocationsLookup();
            for (int j = 0; j < ids.length; ++j) {
                Integer id3 = ids[j];
                mostRecentByBytes.put(id3, thisSetOfLocations.get(id3));
            }
        }
        this._mostRecentCoreRecords = new Record[mostRecentByBytes.size()];
        this._sheetIdToCoreRecordsLookup = new Hashtable();
        int[] allIDs = new int[this._mostRecentCoreRecords.length];
        Enumeration ids = mostRecentByBytes.keys();
        for (i = 0; i < allIDs.length; ++i) {
            Integer id4 = (Integer)ids.nextElement();
            allIDs[i] = id4;
        }
        Arrays.sort(allIDs);
        for (i = 0; i < allIDs.length; ++i) {
            this._sheetIdToCoreRecordsLookup.put(allIDs[i], i);
        }
        for (i = 0; i < this._records.length; ++i) {
            if (!(this._records[i] instanceof PositionDependentRecord)) continue;
            PositionDependentRecord pdr = (PositionDependentRecord)((Object)this._records[i]);
            Integer recordAt = pdr.getLastOnDiskOffset();
            for (int j = 0; j < allIDs.length; ++j) {
                Integer thisID = allIDs[j];
                Integer thatRecordAt = (Integer)mostRecentByBytes.get(thisID);
                if (!thatRecordAt.equals(recordAt)) continue;
                Integer storeAtI = this._sheetIdToCoreRecordsLookup.get(thisID);
                int storeAt = storeAtI;
                if (pdr instanceof PositionDependentRecordContainer) {
                    PositionDependentRecordContainer pdrc = (PositionDependentRecordContainer)this._records[i];
                    pdrc.setSheetId(thisID);
                }
                this._mostRecentCoreRecords[storeAt] = this._records[i];
            }
        }
        for (i = 0; i < this._mostRecentCoreRecords.length; ++i) {
            if (this._mostRecentCoreRecords[i] == null || this._mostRecentCoreRecords[i].getRecordType() != (long)RecordTypes.Document.typeID) continue;
            this._documentRecord = (Document)this._mostRecentCoreRecords[i];
            this._fonts = this._documentRecord.getEnvironment().getFontCollection();
        }
    }

    private Record getCoreRecordForSAS(SlideListWithText.SlideAtomsSet sas) {
        SlidePersistAtom spa = sas.getSlidePersistAtom();
        int refID = spa.getRefID();
        return this.getCoreRecordForRefID(refID);
    }

    private Record getCoreRecordForRefID(int refID) {
        Integer coreRecordId = this._sheetIdToCoreRecordsLookup.get(refID);
        if (coreRecordId != null) {
            Record r = this._mostRecentCoreRecords[coreRecordId];
            return r;
        }
        return null;
    }

    private void buildSlidesAndNotes() {
        ExtendedPresRuleContainer extendedPresRule;
        Slide[] slidesRecords;
        com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Notes[] notesRecords;
        if (this._documentRecord == null) {
            throw new CorruptPowerPointFileException("The PowerPoint file didn't contain a Document Record in its PersistPtr blocks. It is probably corrupt.");
        }
        SlideListWithText masterSLWT = this._documentRecord.getMasterSlideListWithText();
        SlideListWithText slidesSLWT = this._documentRecord.getSlideSlideListWithText();
        SlideListWithText notesSLWT = this._documentRecord.getNotesSlideListWithText();
        SlideListWithText.SlideAtomsSet[] masterSets = new SlideListWithText.SlideAtomsSet[]{};
        if (masterSLWT != null) {
            masterSets = masterSLWT.getSlideAtomsSets();
            ArrayList<MasterSheet> mmr = new ArrayList<MasterSheet>();
            ArrayList<MasterSheet> tmr = new ArrayList<MasterSheet>();
            for (int i = 0; i < masterSets.length; ++i) {
                MasterSheet master;
                Record r = this.getCoreRecordForSAS(masterSets[i]);
                SlideListWithText.SlideAtomsSet sas = masterSets[i];
                int sheetNo = sas.getSlidePersistAtom().getSlideIdentifier();
                if (r instanceof Slide) {
                    master = new TitleMaster((Slide)r, sheetNo);
                    master.setSlideShow(this);
                    tmr.add(master);
                    continue;
                }
                if (!(r instanceof MainMaster)) continue;
                master = new SlideMaster((MainMaster)r, sheetNo);
                ((SlideMaster)master).setSlideShow(this);
                mmr.add(master);
            }
            this._masters = new SlideMaster[mmr.size()];
            mmr.toArray(this._masters);
            this._titleMasters = new TitleMaster[tmr.size()];
            tmr.toArray(this._titleMasters);
        }
        SlideListWithText.SlideAtomsSet[] notesSets = new SlideListWithText.SlideAtomsSet[]{};
        Hashtable<Integer, Integer> slideIdToNotes = new Hashtable<Integer, Integer>();
        if (notesSLWT == null) {
            notesRecords = new com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Notes[]{};
        } else {
            notesSets = notesSLWT.getSlideAtomsSets();
            ArrayList<com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Notes> notesRecordsL = new ArrayList<com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Notes>();
            for (int i = 0; i < notesSets.length; ++i) {
                Record r = this.getCoreRecordForSAS(notesSets[i]);
                if (!(r instanceof com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Notes)) continue;
                com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Notes notesRecord = (com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Notes)r;
                notesRecordsL.add(notesRecord);
                SlidePersistAtom spa = notesSets[i].getSlidePersistAtom();
                Integer slideId = spa.getSlideIdentifier();
                slideIdToNotes.put(slideId, i);
            }
            notesRecords = new com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Notes[notesRecordsL.size()];
            notesRecords = notesRecordsL.toArray(notesRecords);
        }
        SlideListWithText.SlideAtomsSet[] slidesSets = new SlideListWithText.SlideAtomsSet[]{};
        if (slidesSLWT == null) {
            slidesRecords = new Slide[]{};
        } else {
            slidesSets = slidesSLWT.getSlideAtomsSets();
            slidesRecords = new Slide[slidesSets.length];
            for (int i = 0; i < slidesSets.length; ++i) {
                Record r = this.getCoreRecordForSAS(slidesSets[i]);
                if (!(r instanceof Slide)) continue;
                slidesRecords[i] = (Slide)r;
            }
        }
        this._notes = new Notes[this.isGetThumbnail ? Math.min(notesRecords.length, 1) : notesRecords.length];
        for (int i = 0; i < this._notes.length; ++i) {
            this._notes[i] = new Notes(notesRecords[i]);
            this._notes[i].setSlideShow(this);
        }
        ExtendedPresRuleContainer.ExtendedParaAtomsSet[] extendedParaAtomsSets = null;
        if (this._documentRecord.getList() != null && (extendedPresRule = this._documentRecord.getList().getExtendedPresRuleContainer()) != null) {
            extendedParaAtomsSets = extendedPresRule.getExtendedParaAtomsSets();
        }
        this._slides = new com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Slide[this.isGetThumbnail ? 1 : slidesRecords.length];
        for (int i = 0; i < this._slides.length; ++i) {
            Integer notesPos;
            SlideListWithText.SlideAtomsSet sas = slidesSets[i];
            int slideIdentifier = sas.getSlidePersistAtom().getSlideIdentifier();
            Vector<ExtendedPresRuleContainer.ExtendedParaAtomsSet> extendedSets = new Vector<ExtendedPresRuleContainer.ExtendedParaAtomsSet>();
            if (extendedParaAtomsSets != null) {
                for (int j = 0; j < extendedParaAtomsSets.length; ++j) {
                    ExtendedParagraphHeaderAtom paraHeaderAtom = extendedParaAtomsSets[j].getExtendedParaHeaderAtom();
                    if (paraHeaderAtom == null || paraHeaderAtom.getRefSlideID() != slideIdentifier) continue;
                    extendedSets.add(extendedParaAtomsSets[j]);
                }
            }
            ExtendedPresRuleContainer.ExtendedParaAtomsSet[] extendedAtoms = null;
            if (extendedSets.size() > 0) {
                extendedAtoms = extendedSets.toArray(new ExtendedPresRuleContainer.ExtendedParaAtomsSet[extendedSets.size()]);
            }
            Notes notes = null;
            int noteId = slidesRecords[i].getSlideAtom().getNotesID();
            if (noteId != 0 && (notesPos = (Integer)slideIdToNotes.get(noteId)) != null && notesPos < this._notes.length) {
                notes = this._notes[notesPos];
            }
            this._slides[i] = new com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Slide(slidesRecords[i], notes, sas, extendedAtoms, slideIdentifier, i + 1);
            this._slides[i].setSlideShow(this);
            this._slides[i].setSlideShowSlideInfoAtom(slidesRecords[i].getSlideShowSlideInfoAtom());
            this._slides[i].setSlideProgTagsContainer(slidesRecords[i].getSlideProgTagsContainer());
        }
    }

    public void write(OutputStream out) throws IOException {
    }

    public Record[] getMostRecentCoreRecords() {
        return this._mostRecentCoreRecords;
    }

    public com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Slide[] getSlides() {
        return this._slides;
    }

    public Notes[] getNotes() {
        return this._notes;
    }

    public SlideMaster[] getSlidesMasters() {
        return this._masters;
    }

    public TitleMaster[] getTitleMasters() {
        return this._titleMasters;
    }

    public PictureData[] getPictureData() {
        return this._hslfSlideShow.getPictures();
    }

    public ObjectData[] getEmbeddedObjects() {
        return this._hslfSlideShow.getEmbeddedObjects();
    }

    public SoundData[] getSoundData() {
        return SoundData.find(this._documentRecord);
    }

    public Dimension getPageSize() {
        DocumentAtom docatom = this._documentRecord.getDocumentAtom();
        int pgx = (int)((float)docatom.getSlideSizeX() * 72.0f / 576.0f);
        int pgy = (int)((float)docatom.getSlideSizeY() * 72.0f / 576.0f);
        return new Dimension(pgx, pgy);
    }

    public void setPageSize(Dimension pgsize) {
        DocumentAtom docatom = this._documentRecord.getDocumentAtom();
        docatom.setSlideSizeX((long)((float)(pgsize.width * 576) / 72.0f));
        docatom.setSlideSizeY((long)((float)(pgsize.height * 576) / 72.0f));
    }

    protected FontCollection getFontCollection() {
        return this._fonts;
    }

    public Document getDocumentRecord() {
        return this._documentRecord;
    }

    public void reorderSlide(int oldSlideNumber, int newSlideNumber) {
        if (oldSlideNumber < 1 || newSlideNumber < 1) {
            throw new IllegalArgumentException("Old and new slide numbers must be greater than 0");
        }
        if (oldSlideNumber > this._slides.length || newSlideNumber > this._slides.length) {
            throw new IllegalArgumentException("Old and new slide numbers must not exceed the number of slides (" + this._slides.length + ")");
        }
        SlideListWithText slwt = this._documentRecord.getSlideSlideListWithText();
        SlideListWithText.SlideAtomsSet[] sas = slwt.getSlideAtomsSets();
        SlideListWithText.SlideAtomsSet tmp = sas[oldSlideNumber - 1];
        sas[oldSlideNumber - 1] = sas[newSlideNumber - 1];
        sas[newSlideNumber - 1] = tmp;
        ArrayList<Record> lst = new ArrayList<Record>();
        for (int i = 0; i < sas.length; ++i) {
            lst.add(sas[i].getSlidePersistAtom());
            Record[] r = sas[i].getSlideRecords();
            for (int j = 0; j < r.length; ++j) {
                lst.add(r[j]);
            }
            this._slides[i].setSlideNumber(i + 1);
        }
        Record[] r = lst.toArray(new Record[lst.size()]);
        slwt.setChildRecord(r);
    }

    public com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Slide removeSlide(int index) {
        int notesId;
        int lastSlideIdx = this._slides.length - 1;
        if (index < 0 || index > lastSlideIdx) {
            throw new IllegalArgumentException("Slide index (" + index + ") is out of range (0.." + lastSlideIdx + ")");
        }
        SlideListWithText slwt = this._documentRecord.getSlideSlideListWithText();
        SlideListWithText.SlideAtomsSet[] sas = slwt.getSlideAtomsSets();
        com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Slide removedSlide = null;
        ArrayList<Record> records = new ArrayList<Record>();
        ArrayList<SlideListWithText.SlideAtomsSet> sa = new ArrayList<SlideListWithText.SlideAtomsSet>();
        ArrayList<com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Slide> sl = new ArrayList<com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Slide>();
        ArrayList<Notes> nt = new ArrayList<Notes>();
        for (Notes notes : this.getNotes()) {
            nt.add(notes);
        }
        int num = 0;
        for (int i = 0; i < this._slides.length; ++i) {
            if (i != index) {
                sl.add(this._slides[i]);
                sa.add(sas[i]);
                this._slides[i].setSlideNumber(num++);
                records.add(sas[i].getSlidePersistAtom());
                records.addAll(Arrays.asList(sas[i].getSlideRecords()));
                continue;
            }
            removedSlide = this._slides[i];
            nt.remove(this._slides[i].getNotesSheet());
        }
        if (sa.size() == 0) {
            this._documentRecord.removeSlideListWithText(slwt);
        } else {
            slwt.setSlideAtomsSets(sa.toArray(new SlideListWithText.SlideAtomsSet[sa.size()]));
            slwt.setChildRecord(records.toArray(new Record[records.size()]));
        }
        this._slides = sl.toArray(new com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Slide[sl.size()]);
        if (removedSlide != null && (notesId = removedSlide.getSlideRecord().getSlideAtom().getNotesID()) != 0) {
            SlideListWithText nslwt = this._documentRecord.getNotesSlideListWithText();
            records = new ArrayList();
            ArrayList<SlideListWithText.SlideAtomsSet> na = new ArrayList<SlideListWithText.SlideAtomsSet>();
            for (SlideListWithText.SlideAtomsSet ns : nslwt.getSlideAtomsSets()) {
                if (ns.getSlidePersistAtom().getSlideIdentifier() == notesId) continue;
                na.add(ns);
                records.add(ns.getSlidePersistAtom());
                if (ns.getSlideRecords() == null) continue;
                records.addAll(Arrays.asList(ns.getSlideRecords()));
            }
            if (na.size() == 0) {
                this._documentRecord.removeSlideListWithText(nslwt);
            } else {
                nslwt.setSlideAtomsSets(na.toArray(new SlideListWithText.SlideAtomsSet[na.size()]));
                nslwt.setChildRecord(records.toArray(new Record[records.size()]));
            }
        }
        this._notes = nt.toArray(new Notes[nt.size()]);
        return removedSlide;
    }

    public int getNumberOfFonts() {
        return this.getDocumentRecord().getEnvironment().getFontCollection().getNumberOfFonts();
    }

    public HeadersFooters getSlideHeadersFooters() {
        String tag = this.getSlidesMasters()[0].getProgrammableTag();
        boolean ppt2007 = "___PPT12".equals(tag);
        HeadersFootersContainer hdd = null;
        Record[] ch = this._documentRecord.getChildRecords();
        for (int i = 0; i < ch.length; ++i) {
            if (!(ch[i] instanceof HeadersFootersContainer) || ((HeadersFootersContainer)ch[i]).getOptions() != 63) continue;
            hdd = (HeadersFootersContainer)ch[i];
            break;
        }
        boolean newRecord = false;
        if (hdd == null) {
            hdd = new HeadersFootersContainer(63);
            newRecord = true;
        }
        return new HeadersFooters(hdd, this, newRecord, ppt2007);
    }

    public HeadersFooters getNotesHeadersFooters() {
        String tag = this.getSlidesMasters()[0].getProgrammableTag();
        boolean ppt2007 = "___PPT12".equals(tag);
        HeadersFootersContainer hdd = null;
        Record[] ch = this._documentRecord.getChildRecords();
        for (int i = 0; i < ch.length; ++i) {
            if (!(ch[i] instanceof HeadersFootersContainer) || ((HeadersFootersContainer)ch[i]).getOptions() != 79) continue;
            hdd = (HeadersFootersContainer)ch[i];
            break;
        }
        boolean newRecord = false;
        if (hdd == null) {
            hdd = new HeadersFootersContainer(79);
            newRecord = true;
        }
        if (ppt2007 && this._notes.length > 0) {
            return new HeadersFooters(hdd, this._notes[0], newRecord, ppt2007);
        }
        return new HeadersFooters(hdd, this, newRecord, ppt2007);
    }

    public int addMovie(String path, int type) {
        ExObjList lst = (ExObjList)this._documentRecord.findFirstOfType(RecordTypes.ExObjList.typeID);
        if (lst == null) {
            lst = new ExObjList();
            this._documentRecord.addChildAfter(lst, this._documentRecord.getDocumentAtom());
        }
        ExObjListAtom objAtom = lst.getExObjListAtom();
        int objectId = (int)objAtom.getObjectIDSeed() + 1;
        objAtom.setObjectIDSeed(objectId);
        ExMCIMovie mci = switch (type) {
            case 1 -> new ExMCIMovie();
            case 2 -> new ExAviMovie();
            default -> throw new IllegalArgumentException("Unsupported Movie: " + type);
        };
        lst.appendChildRecord(mci);
        ExVideoContainer exVideo = mci.getExVideo();
        exVideo.getExMediaAtom().setObjectId(objectId);
        exVideo.getExMediaAtom().setMask(0xE80000);
        exVideo.getPathAtom().setText(path);
        return objectId;
    }

    public int addControl(String name, String progId) {
        ExObjList lst = (ExObjList)this._documentRecord.findFirstOfType(RecordTypes.ExObjList.typeID);
        if (lst == null) {
            lst = new ExObjList();
            this._documentRecord.addChildAfter(lst, this._documentRecord.getDocumentAtom());
        }
        ExObjListAtom objAtom = lst.getExObjListAtom();
        int objectId = (int)objAtom.getObjectIDSeed() + 1;
        objAtom.setObjectIDSeed(objectId);
        ExControl ctrl = new ExControl();
        ExOleObjAtom oleObj = ctrl.getExOleObjAtom();
        oleObj.setObjID(objectId);
        oleObj.setDrawAspect(1);
        oleObj.setType(2);
        oleObj.setSubType(0);
        ctrl.setProgId(progId);
        ctrl.setMenuName(name);
        ctrl.setClipboardName(name);
        lst.addChildAfter(ctrl, objAtom);
        return objectId;
    }

    public int addHyperlink(Hyperlink link) {
        ExObjList lst = (ExObjList)this._documentRecord.findFirstOfType(RecordTypes.ExObjList.typeID);
        if (lst == null) {
            lst = new ExObjList();
            this._documentRecord.addChildAfter(lst, this._documentRecord.getDocumentAtom());
        }
        ExObjListAtom objAtom = lst.getExObjListAtom();
        int objectId = (int)objAtom.getObjectIDSeed() + 1;
        objAtom.setObjectIDSeed(objectId);
        ExHyperlink ctrl = new ExHyperlink();
        ExHyperlinkAtom obj = ctrl.getExHyperlinkAtom();
        obj.setNumber(objectId);
        ctrl.setLinkURL(link.getAddress());
        ctrl.setLinkTitle(link.getTitle());
        lst.addChildAfter(ctrl, objAtom);
        link.setId(objectId);
        return objectId;
    }

    public int getSlideCount() {
        return this._slides.length;
    }

    public com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Slide getSlide(int index) {
        if (index < 0 || index >= this.getSlideCount()) {
            return null;
        }
        return this._slides[index];
    }

    public void dispose() {
        if (this._hslfSlideShow != null) {
            this._hslfSlideShow.dispose();
            this._hslfSlideShow = null;
        }
        if (this._records != null) {
            for (Record rd : this._records) {
                rd.dispose();
            }
            this._records = null;
        }
        if (this._mostRecentCoreRecords != null) {
            for (Record rd : this._mostRecentCoreRecords) {
                rd.dispose();
            }
            this._mostRecentCoreRecords = null;
        }
        if (this._sheetIdToCoreRecordsLookup != null) {
            this._sheetIdToCoreRecordsLookup.clear();
            this._sheetIdToCoreRecordsLookup = null;
        }
        if (this._documentRecord != null) {
            this._documentRecord.dispose();
            this._documentRecord = null;
        }
        if (this._masters != null) {
            for (SlideMaster sm : this._masters) {
                sm.dispose();
            }
            this._masters = null;
        }
        if (this._titleMasters != null) {
            for (TitleMaster tm : this._titleMasters) {
                tm.dispose();
            }
            this._titleMasters = null;
        }
        if (this._slides != null) {
            for (com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Slide slide : this._slides) {
                slide.dispose();
            }
            this._slides = null;
        }
        if (this._notes != null) {
            for (Notes note : this._notes) {
                note.dispose();
            }
            this._notes = null;
        }
        if (this._fonts != null) {
            this._fonts.dispose();
            this._fonts = null;
        }
    }
}

