/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.usermodel;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.MasterSheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.TextRun;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.textproperties.BitMaskTextProp;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.textproperties.CharFlagsTextProp;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.textproperties.ParagraphFlagsTextProp;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.textproperties.TextProp;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.textproperties.TextPropCollection;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ColorSchemeAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.usermodel.SlideShow;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Color;

public final class RichTextRun {
    private TextRun parentRun;
    private SlideShow slideShow;
    private int startPos;
    private int length;
    private String _fontname;
    private TextPropCollection paragraphStyle;
    private TextPropCollection characterStyle;
    private boolean sharingParagraphStyle;
    private boolean sharingCharacterStyle;

    public RichTextRun(TextRun parent, int startAt, int len) {
        this(parent, startAt, len, null, null, false, false);
    }

    public RichTextRun(TextRun parent, int startAt, int len, TextPropCollection pStyle, TextPropCollection cStyle, boolean pShared, boolean cShared) {
        this.parentRun = parent;
        this.startPos = startAt;
        this.length = len;
        this.paragraphStyle = pStyle;
        this.characterStyle = cStyle;
        this.sharingParagraphStyle = pShared;
        this.sharingCharacterStyle = cShared;
    }

    public void supplyTextProps(TextPropCollection pStyle, TextPropCollection cStyle, boolean pShared, boolean cShared) {
        if (this.paragraphStyle != null || this.characterStyle != null) {
            throw new IllegalStateException("Can't call supplyTextProps if run already has some");
        }
        this.paragraphStyle = pStyle;
        this.characterStyle = cStyle;
        this.sharingParagraphStyle = pShared;
        this.sharingCharacterStyle = cShared;
    }

    public void supplySlideShow(SlideShow ss) {
        this.slideShow = ss;
        if (this._fontname != null) {
            this.setFontName(this._fontname);
            this._fontname = null;
        }
    }

    public int getLength() {
        return this.length;
    }

    public int getStartIndex() {
        return this.startPos;
    }

    public int getEndIndex() {
        return this.startPos + this.length;
    }

    public String getText() {
        String text = this.parentRun.getText();
        int end = Math.min(text.length(), this.startPos + this.length);
        return text.substring(this.startPos, end);
    }

    public String getRawText() {
        return this.parentRun.getRawText().substring(this.startPos, this.startPos + this.length);
    }

    public void setText(String text) {
        String s = this.parentRun.normalize(text);
        this.setRawText(s);
    }

    public void setRawText(String text) {
        this.length = text.length();
        this.parentRun.changeTextInRichTextRun(this, text);
    }

    public void updateStartPosition(int startAt) {
        this.startPos = startAt;
    }

    private boolean isCharFlagsTextPropVal(int index) {
        return this.getFlag(true, index);
    }

    private boolean getFlag(boolean isCharacter, int index) {
        Sheet sheet;
        String propname;
        TextPropCollection props;
        if (isCharacter) {
            props = this.characterStyle;
            propname = CharFlagsTextProp.NAME;
        } else {
            props = this.paragraphStyle;
            propname = ParagraphFlagsTextProp.NAME;
        }
        BitMaskTextProp prop = null;
        if (props != null) {
            prop = (BitMaskTextProp)props.findByName(propname);
        }
        if (prop == null && (sheet = this.parentRun.getSheet()) != null) {
            int txtype = this.parentRun.getRunType();
            MasterSheet master = sheet.getMasterSheet();
            if (master != null) {
                prop = (BitMaskTextProp)master.getStyleAttribute(txtype, this.getIndentLevel(), propname, isCharacter);
            }
        }
        return prop == null ? false : prop.getSubValue(index);
    }

    private void setCharFlagsTextPropVal(int index, boolean value) {
        if (this.getFlag(true, index) != value) {
            this.setFlag(true, index, value);
        }
    }

    public void setFlag(boolean isCharacter, int index, boolean value) {
        String propname;
        TextPropCollection props;
        if (isCharacter) {
            props = this.characterStyle;
            propname = CharFlagsTextProp.NAME;
        } else {
            props = this.paragraphStyle;
            propname = ParagraphFlagsTextProp.NAME;
        }
        if (props == null) {
            this.parentRun.ensureStyleAtomPresent();
            props = isCharacter ? this.characterStyle : this.paragraphStyle;
        }
        BitMaskTextProp prop = (BitMaskTextProp)this.fetchOrAddTextProp(props, propname);
        prop.setSubValue(value, index);
    }

    private TextProp fetchOrAddTextProp(TextPropCollection textPropCol, String textPropName) {
        TextProp tp = textPropCol.findByName(textPropName);
        if (tp == null) {
            tp = textPropCol.addWithName(textPropName);
        }
        return tp;
    }

    private int getCharTextPropVal(String propName) {
        TextProp prop = null;
        if (this.characterStyle != null) {
            prop = this.characterStyle.findByName(propName);
        }
        if (prop == null) {
            Sheet sheet = this.parentRun.getSheet();
            int txtype = this.parentRun.getRunType();
            MasterSheet master = sheet.getMasterSheet();
            if (master != null) {
                prop = master.getStyleAttribute(txtype, this.getIndentLevel(), propName, true);
            }
        }
        if (prop == null && propName.equalsIgnoreCase("font.color")) {
            return Color.BLACK.getRGB();
        }
        return prop == null ? -1 : prop.getValue();
    }

    private int getParaTextPropVal(String propName) {
        TextProp prop = null;
        boolean hardAttribute = false;
        if (this.paragraphStyle != null) {
            prop = this.paragraphStyle.findByName(propName);
        }
        if (prop == null && !hardAttribute) {
            Sheet sheet = this.parentRun.getSheet();
            int txtype = this.parentRun.getRunType();
            MasterSheet master = sheet.getMasterSheet();
            if (master != null) {
                prop = master.getStyleAttribute(txtype, this.getIndentLevel(), propName, false);
            }
        }
        return prop == null ? -1 : prop.getValue();
    }

    public void setParaTextPropVal(String propName, int val) {
        if (this.paragraphStyle == null) {
            this.parentRun.ensureStyleAtomPresent();
        }
        TextProp tp = this.fetchOrAddTextProp(this.paragraphStyle, propName);
        tp.setValue(val);
    }

    public void setCharTextPropVal(String propName, int val) {
        if (this.characterStyle == null) {
            this.parentRun.ensureStyleAtomPresent();
        }
        TextProp tp = this.fetchOrAddTextProp(this.characterStyle, propName);
        tp.setValue(val);
    }

    public boolean isBold() {
        return this.isCharFlagsTextPropVal(0);
    }

    public void setBold(boolean bold) {
        this.setCharFlagsTextPropVal(0, bold);
    }

    public boolean isItalic() {
        return this.isCharFlagsTextPropVal(1);
    }

    public void setItalic(boolean italic) {
        this.setCharFlagsTextPropVal(1, italic);
    }

    public boolean isUnderlined() {
        return this.isCharFlagsTextPropVal(2);
    }

    public void setUnderlined(boolean underlined) {
        this.setCharFlagsTextPropVal(2, underlined);
    }

    public boolean isShadowed() {
        return this.isCharFlagsTextPropVal(4);
    }

    public void setShadowed(boolean flag) {
        this.setCharFlagsTextPropVal(4, flag);
    }

    public boolean isEmbossed() {
        return this.isCharFlagsTextPropVal(9);
    }

    public void setEmbossed(boolean flag) {
        this.setCharFlagsTextPropVal(9, flag);
    }

    public boolean isStrikethrough() {
        return this.isCharFlagsTextPropVal(8);
    }

    public void setStrikethrough(boolean flag) {
        this.setCharFlagsTextPropVal(8, flag);
    }

    public int getSuperscript() {
        int val = this.getCharTextPropVal("superscript");
        return val == -1 ? 0 : val;
    }

    public void setSuperscript(int val) {
        this.setCharTextPropVal("superscript", val);
    }

    public int getFontSize() {
        return this.getCharTextPropVal("font.size");
    }

    public void setFontSize(int fontSize) {
        this.setCharTextPropVal("font.size", fontSize);
    }

    public int getFontIndex() {
        return this.getCharTextPropVal("font.index");
    }

    public void setFontIndex(int idx) {
        this.setCharTextPropVal("font.index", idx);
    }

    public void setFontName(String fontName) {
        if (this.slideShow == null) {
            this._fontname = fontName;
        } else {
            int fontIdx = this.slideShow.getFontCollection().addFont(fontName);
            this.setCharTextPropVal("font.index", fontIdx);
        }
    }

    public String getFontName() {
        if (this.slideShow == null) {
            return this._fontname;
        }
        int fontIdx = this.getCharTextPropVal("font.index");
        if (fontIdx == -1) {
            return null;
        }
        return this.slideShow.getFontCollection().getFontWithId(fontIdx);
    }

    public Color getFontColor() {
        int rgb = this.getCharTextPropVal("font.color");
        int cidx = rgb >> 24;
        if (rgb % 0x1000000 == 0) {
            ColorSchemeAtom ca = this.parentRun.getSheet().getColorScheme();
            if (cidx >= 0 && cidx <= 7) {
                rgb = ca.getColor(cidx);
            }
        }
        Color tmp = new Color(rgb, true);
        return new Color(tmp.getBlue(), tmp.getGreen(), tmp.getRed());
    }

    public void setFontColor(int bgr) {
        this.setCharTextPropVal("font.color", bgr);
    }

    public void setFontColor(Color color2) {
        int rgb = new Color(color2.getBlue(), color2.getGreen(), color2.getRed(), 254).getRGB();
        this.setFontColor(rgb);
    }

    public void setAlignment(int align) {
        this.setParaTextPropVal("alignment", align);
    }

    public int getAlignment() {
        return this.getParaTextPropVal("alignment");
    }

    public int getIndentLevel() {
        return this.paragraphStyle == null ? 0 : (int)this.paragraphStyle.getReservedField();
    }

    public void setIndentLevel(int level) {
        if (this.paragraphStyle != null) {
            this.paragraphStyle.setReservedField((short)level);
        }
    }

    public void setBullet(boolean flag) {
        this.setFlag(false, 0, flag);
    }

    public boolean isBullet() {
        return this.getFlag(false, 0);
    }

    public boolean isBulletHard() {
        return this.getFlag(false, 0);
    }

    public void setBulletChar(char c) {
        this.setParaTextPropVal("bullet.char", c);
    }

    public char getBulletChar() {
        return (char)this.getParaTextPropVal("bullet.char");
    }

    public void setBulletOffset(int offset) {
        this.setParaTextPropVal("bullet.offset", (int)((float)(offset * 576) / 72.0f));
    }

    public int getBulletOffset() {
        return (int)((float)this.getParaTextPropVal("bullet.offset") * 72.0f / 576.0f);
    }

    public void setTextOffset(int offset) {
        this.setParaTextPropVal("text.offset", (int)((float)(offset * 576) / 72.0f));
    }

    public int getTextOffset() {
        return (int)((float)this.getParaTextPropVal("text.offset") * 72.0f / 576.0f);
    }

    public void setBulletSize(int size) {
        this.setParaTextPropVal("bullet.size", size);
    }

    public int getBulletSize() {
        return this.getParaTextPropVal("bullet.size");
    }

    public void setBulletColor(Color color2) {
        int rgb = new Color(color2.getBlue(), color2.getGreen(), color2.getRed(), 254).getRGB();
        this.setParaTextPropVal("bullet.color", rgb);
    }

    public Color getBulletColor() {
        int rgb = this.getParaTextPropVal("bullet.color");
        if (rgb == -1) {
            return this.getFontColor();
        }
        int cidx = rgb >> 24;
        if (rgb % 0x1000000 == 0) {
            ColorSchemeAtom ca = this.parentRun.getSheet().getColorScheme();
            if (cidx >= 0 && cidx <= 7) {
                rgb = ca.getColor(cidx);
            }
        }
        Color tmp = new Color(rgb, true);
        return new Color(tmp.getBlue(), tmp.getGreen(), tmp.getRed());
    }

    public void setBulletFont(int idx) {
        this.setParaTextPropVal("bullet.font", idx);
        this.setFlag(false, 1, true);
    }

    public int getBulletFont() {
        return this.getParaTextPropVal("bullet.font");
    }

    public void setLineSpacing(int val) {
        this.setParaTextPropVal("linespacing", val);
    }

    public int getLineSpacing() {
        int val = this.getParaTextPropVal("linespacing");
        return val == -1 ? 0 : val;
    }

    public void setSpaceBefore(int val) {
        this.setParaTextPropVal("spacebefore", val);
    }

    public int getSpaceBefore() {
        int val = this.getParaTextPropVal("spacebefore");
        return val == -1 ? 0 : val;
    }

    public void setSpaceAfter(int val) {
        this.setParaTextPropVal("spaceafter", val);
    }

    public int getSpaceAfter() {
        int val = this.getParaTextPropVal("spaceafter");
        return val == -1 ? 0 : val;
    }

    public TextPropCollection _getRawParagraphStyle() {
        return this.paragraphStyle;
    }

    public TextPropCollection _getRawCharacterStyle() {
        return this.characterStyle;
    }

    public boolean _isParagraphStyleShared() {
        return this.sharingParagraphStyle;
    }

    public boolean _isCharacterStyleShared() {
        return this.sharingCharacterStyle;
    }

    public void dispose() {
        this.parentRun = null;
        this.slideShow = null;
        this._fontname = null;
        if (this.paragraphStyle != null) {
            this.paragraphStyle.dispose();
            this.paragraphStyle = null;
        }
        if (this.characterStyle != null) {
            this.characterStyle.dispose();
            this.characterStyle = null;
        }
    }
}

