/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ColorSchemeAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.HeadersFootersContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.PPDrawing;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.SheetContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.SlideAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.SlideProgTagsContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.SlideShowSlideInfoAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;

public final class Slide
extends SheetContainer {
    private byte[] _header = new byte[8];
    private static long _type = 1006L;
    private SlideAtom slideAtom;
    private PPDrawing ppDrawing;
    private ColorSchemeAtom _colorScheme;
    private SlideShowSlideInfoAtom ssSlideInfoAtom;
    private SlideProgTagsContainer propTagsContainer;
    private HeadersFootersContainer headersFootersContainer;

    public SlideAtom getSlideAtom() {
        return this.slideAtom;
    }

    @Override
    public PPDrawing getPPDrawing() {
        return this.ppDrawing;
    }

    public HeadersFootersContainer getHeadersFootersContainer() {
        return this.headersFootersContainer;
    }

    protected Slide(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        for (int i = 0; i < this._children.length; ++i) {
            if (this._children[i] instanceof SlideAtom) {
                this.slideAtom = (SlideAtom)this._children[i];
            } else if (this._children[i] instanceof PPDrawing) {
                this.ppDrawing = (PPDrawing)this._children[i];
            } else if (this._children[i] instanceof SlideShowSlideInfoAtom) {
                this.ssSlideInfoAtom = (SlideShowSlideInfoAtom)this._children[i];
            } else if (this._children[i] instanceof SlideProgTagsContainer) {
                this.propTagsContainer = (SlideProgTagsContainer)this._children[i];
            } else if (this._children[i] instanceof HeadersFootersContainer) {
                this.headersFootersContainer = (HeadersFootersContainer)this._children[i];
            }
            if (this.ppDrawing == null || !(this._children[i] instanceof ColorSchemeAtom)) continue;
            this._colorScheme = (ColorSchemeAtom)this._children[i];
        }
    }

    public Slide() {
        LittleEndian.putUShort(this._header, 0, 15);
        LittleEndian.putUShort(this._header, 2, (int)_type);
        LittleEndian.putInt(this._header, 4, 0);
        this.slideAtom = new SlideAtom();
        this.ppDrawing = new PPDrawing();
        ColorSchemeAtom colorAtom = new ColorSchemeAtom();
        this._children = new Record[]{this.slideAtom, this.ppDrawing, colorAtom};
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public ColorSchemeAtom getColorScheme() {
        return this._colorScheme;
    }

    public SlideShowSlideInfoAtom getSlideShowSlideInfoAtom() {
        return this.ssSlideInfoAtom;
    }

    public SlideProgTagsContainer getSlideProgTagsContainer() {
        return this.propTagsContainer;
    }

    @Override
    public void dispose() {
        super.dispose();
        this._header = null;
        if (this.slideAtom != null) {
            this.slideAtom.dispose();
            this.slideAtom = null;
        }
        if (this.ppDrawing != null) {
            this.ppDrawing.dispose();
            this.ppDrawing = null;
        }
        if (this._colorScheme != null) {
            this._colorScheme.dispose();
            this._colorScheme = null;
        }
        if (this.ssSlideInfoAtom != null) {
            this.ssSlideInfoAtom.dispose();
            this.ssSlideInfoAtom = null;
        }
        if (this.propTagsContainer != null) {
            this.propTagsContainer.dispose();
            this.propTagsContainer = null;
        }
    }
}

