/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ParentAwareRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.ArrayUtil;
import java.util.ArrayList;

public abstract class RecordContainer
extends Record {
    protected Record[] _children;
    private Boolean changingChildRecordsLock = Boolean.TRUE;

    @Override
    public Record[] getChildRecords() {
        return this._children;
    }

    @Override
    public boolean isAnAtom() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int findChildLocation(Record child) {
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            for (int i = 0; i < this._children.length; ++i) {
                if (!this._children[i].equals(child)) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void appendChild(Record newChild) {
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            Record[] nc = new Record[this._children.length + 1];
            System.arraycopy(this._children, 0, nc, 0, this._children.length);
            nc[this._children.length] = newChild;
            this._children = nc;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addChildAt(Record newChild, int position) {
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            this.appendChild(newChild);
            this.moveChildRecords(this._children.length - 1, position, 1);
        }
    }

    private void moveChildRecords(int oldLoc, int newLoc, int number) {
        if (oldLoc == newLoc) {
            return;
        }
        if (number == 0) {
            return;
        }
        if (oldLoc + number > this._children.length) {
            throw new IllegalArgumentException("Asked to move more records than there are!");
        }
        ArrayUtil.arrayMoveWithin(this._children, oldLoc, newLoc, number);
    }

    public Record findFirstOfType(long type) {
        for (int i = 0; i < this._children.length; ++i) {
            if (this._children[i].getRecordType() != type) continue;
            return this._children[i];
        }
        return null;
    }

    public Record removeChild(Record ch) {
        Record rm = null;
        ArrayList<Record> lst = new ArrayList<Record>();
        for (Record r : this._children) {
            if (r != ch) {
                lst.add(r);
                continue;
            }
            rm = r;
        }
        this._children = lst.toArray(new Record[lst.size()]);
        return rm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendChildRecord(Record newChild) {
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            this.appendChild(newChild);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildAfter(Record newChild, Record after) {
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            int loc = this.findChildLocation(after);
            if (loc == -1) {
                throw new IllegalArgumentException("Asked to add a new child after another record, but that record wasn't one of our children!");
            }
            this.addChildAt(newChild, loc + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addChildBefore(Record newChild, Record before) {
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            int loc = this.findChildLocation(before);
            if (loc == -1) {
                throw new IllegalArgumentException("Asked to add a new child before another record, but that record wasn't one of our children!");
            }
            this.addChildAt(newChild, loc);
        }
    }

    public void moveChildBefore(Record child, Record before) {
        this.moveChildrenBefore(child, 1, before);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveChildrenBefore(Record firstChild, int number, Record before) {
        if (number < 1) {
            return;
        }
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            int newLoc = this.findChildLocation(before);
            if (newLoc == -1) {
                throw new IllegalArgumentException("Asked to move children before another record, but that record wasn't one of our children!");
            }
            int oldLoc = this.findChildLocation(firstChild);
            if (oldLoc == -1) {
                throw new IllegalArgumentException("Asked to move a record that wasn't a child!");
            }
            this.moveChildRecords(oldLoc, newLoc, number);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveChildrenAfter(Record firstChild, int number, Record after) {
        if (number < 1) {
            return;
        }
        Boolean bl = this.changingChildRecordsLock;
        synchronized (bl) {
            int newLoc = this.findChildLocation(after);
            if (newLoc == -1) {
                throw new IllegalArgumentException("Asked to move children before another record, but that record wasn't one of our children!");
            }
            ++newLoc;
            int oldLoc = this.findChildLocation(firstChild);
            if (oldLoc == -1) {
                throw new IllegalArgumentException("Asked to move a record that wasn't a child!");
            }
            this.moveChildRecords(oldLoc, newLoc, number);
        }
    }

    public void setChildRecord(Record[] records) {
        this._children = records;
    }

    public static void handleParentAwareRecords(RecordContainer br) {
        for (Record record : br.getChildRecords()) {
            if (record instanceof ParentAwareRecord) {
                ((ParentAwareRecord)((Object)record)).setParentRecord(br);
            }
            if (!(record instanceof RecordContainer)) continue;
            RecordContainer.handleParentAwareRecords((RecordContainer)record);
        }
    }

    @Override
    public void dispose() {
        if (this._children != null) {
            for (Record rec : this._children) {
                if (rec == null) continue;
                rec.dispose();
            }
            this._children = null;
        }
    }
}

