/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExVideoContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordTypes;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.POILogger;

public class ExMCIMovie
extends RecordContainer {
    private byte[] _header = new byte[8];
    private ExVideoContainer exVideo;

    protected ExMCIMovie(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        this.findInterestingChildren();
    }

    public ExMCIMovie() {
        this._header[0] = 15;
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        this.exVideo = new ExVideoContainer();
        this._children = new Record[]{this.exVideo};
    }

    private void findInterestingChildren() {
        if (this._children[0] instanceof ExVideoContainer) {
            this.exVideo = (ExVideoContainer)this._children[0];
        } else {
            this.logger.log(POILogger.ERROR, "First child record wasn't a ExVideoContainer, was of type " + this._children[0].getRecordType());
        }
    }

    @Override
    public long getRecordType() {
        return RecordTypes.ExMCIMovie.typeID;
    }

    public ExVideoContainer getExVideo() {
        return this.exVideo;
    }

    @Override
    public void dispose() {
        super.dispose();
        this._header = null;
        if (this.exVideo != null) {
            this.exVideo.dispose();
            this.exVideo = null;
        }
    }
}

