/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.DocumentAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Environment;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExObjList;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.List;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.PPDrawingGroup;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.PositionDependentRecordContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordTypes;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.SlideListWithText;
import java.util.ArrayList;

public final class Document
extends PositionDependentRecordContainer {
    private byte[] _header = new byte[8];
    private static long _type = 1000L;
    private DocumentAtom documentAtom;
    private Environment environment;
    private PPDrawingGroup ppDrawing;
    private SlideListWithText[] slwts;
    private ExObjList exObjList;
    private List list;

    public DocumentAtom getDocumentAtom() {
        return this.documentAtom;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public PPDrawingGroup getPPDrawingGroup() {
        return this.ppDrawing;
    }

    public ExObjList getExObjList() {
        return this.exObjList;
    }

    public SlideListWithText[] getSlideListWithTexts() {
        return this.slwts;
    }

    public SlideListWithText getMasterSlideListWithText() {
        for (int i = 0; i < this.slwts.length; ++i) {
            if (this.slwts[i].getInstance() != 1) continue;
            return this.slwts[i];
        }
        return null;
    }

    public SlideListWithText getSlideSlideListWithText() {
        for (int i = 0; i < this.slwts.length; ++i) {
            if (this.slwts[i].getInstance() != 0) continue;
            return this.slwts[i];
        }
        return null;
    }

    public SlideListWithText getNotesSlideListWithText() {
        for (int i = 0; i < this.slwts.length; ++i) {
            if (this.slwts[i].getInstance() != 2) continue;
            return this.slwts[i];
        }
        return null;
    }

    public List getList() {
        return this.list;
    }

    protected Document(byte[] source, int start, int len) {
        int i;
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        if (!(this._children[0] instanceof DocumentAtom)) {
            throw new IllegalStateException("The first child of a Document must be a DocumentAtom");
        }
        this.documentAtom = (DocumentAtom)this._children[0];
        int slwtcount = 0;
        for (i = 1; i < this._children.length; ++i) {
            if (this._children[i] instanceof SlideListWithText) {
                ++slwtcount;
                continue;
            }
            if (this._children[i] instanceof Environment) {
                this.environment = (Environment)this._children[i];
                continue;
            }
            if (this._children[i] instanceof PPDrawingGroup) {
                this.ppDrawing = (PPDrawingGroup)this._children[i];
                continue;
            }
            if (this._children[i] instanceof ExObjList) {
                this.exObjList = (ExObjList)this._children[i];
                continue;
            }
            if (!(this._children[i] instanceof List)) continue;
            this.list = (List)this._children[i];
        }
        this.slwts = new SlideListWithText[slwtcount];
        slwtcount = 0;
        for (i = 1; i < this._children.length; ++i) {
            if (!(this._children[i] instanceof SlideListWithText)) continue;
            this.slwts[slwtcount] = (SlideListWithText)this._children[i];
            ++slwtcount;
        }
    }

    public void addSlideListWithText(SlideListWithText slwt) {
        Record endDoc = this._children[this._children.length - 1];
        if (endDoc.getRecordType() != (long)RecordTypes.EndDocument.typeID) {
            throw new IllegalStateException("The last child record of a Document should be EndDocument, but it was " + endDoc);
        }
        this.addChildBefore(slwt, endDoc);
        int newSize = this.slwts.length + 1;
        SlideListWithText[] nl = new SlideListWithText[newSize];
        System.arraycopy(this.slwts, 0, nl, 0, this.slwts.length);
        nl[nl.length - 1] = slwt;
        this.slwts = nl;
    }

    public void removeSlideListWithText(SlideListWithText slwt) {
        ArrayList<SlideListWithText> lst = new ArrayList<SlideListWithText>();
        for (SlideListWithText s : this.slwts) {
            if (s != slwt) {
                lst.add(s);
                continue;
            }
            this.removeChild(slwt);
        }
        this.slwts = lst.toArray(new SlideListWithText[lst.size()]);
    }

    @Override
    public long getRecordType() {
        return _type;
    }

    @Override
    public void dispose() {
        this._header = null;
        if (this.documentAtom != null) {
            this.documentAtom.dispose();
            this.documentAtom = null;
        }
        if (this.environment != null) {
            this.environment.dispose();
            this.environment = null;
        }
        if (this.ppDrawing != null) {
            this.ppDrawing.dispose();
            this.ppDrawing = null;
        }
        if (this.slwts != null) {
            for (SlideListWithText swt : this.slwts) {
                swt.dispose();
            }
            this.slwts = null;
        }
        if (this.exObjList != null) {
            this.exObjList.dispose();
            this.exObjList = null;
        }
        if (this.list != null) {
            this.list.dispose();
            this.list = null;
        }
    }
}

