/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record;

import com.ahmadullahpk.alldocumentreader.xs.fc.fs.filesystem.CFBFileSystem;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.exceptions.CorruptPowerPointFileException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.exceptions.EncryptedPowerPointFileException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.exceptions.OldPowerPointFormatException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.OldWordFileFormatException;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.POIFSFileSystem;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.StringUtil;
import java.io.IOException;

public class CurrentUserAtom {
    public static final byte[] atomHeader = new byte[]{0, 0, -10, 15};
    public static final byte[] headerToken = new byte[]{95, -64, -111, -29};
    public static final byte[] encHeaderToken = new byte[]{-33, -60, -47, -13};
    public static final byte[] ppt97FileVer = new byte[]{8, 0, -13, 3, 3, 0};
    private int docFinalVersion;
    private byte docMajorNo;
    private byte docMinorNo;
    private long currentEditOffset;
    private String lastEditUser;
    private long releaseVersion;
    private byte[] _contents;

    public int getDocFinalVersion() {
        return this.docFinalVersion;
    }

    public byte getDocMajorNo() {
        return this.docMajorNo;
    }

    public byte getDocMinorNo() {
        return this.docMinorNo;
    }

    public long getReleaseVersion() {
        return this.releaseVersion;
    }

    public void setReleaseVersion(long rv) {
        this.releaseVersion = rv;
    }

    public long getCurrentEditOffset() {
        return this.currentEditOffset;
    }

    public void setCurrentEditOffset(long id2) {
        this.currentEditOffset = id2;
    }

    public String getLastEditUsername() {
        return this.lastEditUser;
    }

    public void setLastEditUsername(String u) {
        this.lastEditUser = u;
    }

    public CurrentUserAtom() {
        this._contents = new byte[0];
        this.docFinalVersion = 1012;
        this.docMajorNo = (byte)3;
        this.docMinorNo = 0;
        this.releaseVersion = 8L;
        this.currentEditOffset = 0L;
        this.lastEditUser = "Apache POI";
    }

    public CurrentUserAtom(POIFSFileSystem fs) throws IOException {
    }

    public CurrentUserAtom(CFBFileSystem cfbFS) throws IOException {
        this._contents = cfbFS.getPropertyRawData("Current User");
        if (this._contents == null || this._contents.length > 131072) {
            throw new CorruptPowerPointFileException("The Current User stream is implausably long. It's normally 28-200 bytes long, but was " + this._contents.length + " bytes");
        }
        if (this._contents.length < 28) {
            if (this._contents.length >= 4) {
                int size = LittleEndian.getInt(this._contents);
                System.err.println(size);
                if (size + 4 == this._contents.length) {
                    throw new OldPowerPointFormatException("Based on the Current User stream, you seem to have supplied a PowerPoint95 file, which isn't supported");
                }
            }
            throw new CorruptPowerPointFileException("The Current User stream must be at least 28 bytes long, but was only " + this._contents.length);
        }
        this.init();
    }

    public CurrentUserAtom(byte[] b) {
        this._contents = b;
        this.init();
    }

    private void init() {
        int len;
        int start;
        if (this._contents[12] == encHeaderToken[0] && this._contents[13] == encHeaderToken[1] && this._contents[14] == encHeaderToken[2] && this._contents[15] == encHeaderToken[3]) {
            throw new EncryptedPowerPointFileException("Cannot process encrypted office files!");
        }
        this.currentEditOffset = LittleEndian.getUInt(this._contents, 16);
        this.docFinalVersion = LittleEndian.getUShort(this._contents, 22);
        this.docMajorNo = this._contents[24];
        this.docMinorNo = this._contents[25];
        long usernameLen = LittleEndian.getUShort(this._contents, 20);
        if (usernameLen > 512L) {
            System.err.println("Warning - invalid username length " + usernameLen + " found, treating as if there was no username set");
            usernameLen = 0L;
        }
        if (this._contents.length >= 28 + (int)usernameLen + 4) {
            this.releaseVersion = LittleEndian.getUInt(this._contents, 28 + (int)usernameLen);
            if (this.releaseVersion == 0L) {
                throw new OldWordFileFormatException("The document is too old - Word 95 or older. Try HWPFOldDocument instead?");
            }
        } else {
            this.releaseVersion = 0L;
        }
        if (this._contents.length >= (start = 28 + (int)usernameLen + 4) + (len = 2 * (int)usernameLen)) {
            byte[] textBytes = new byte[len];
            System.arraycopy(this._contents, start, textBytes, 0, len);
            this.lastEditUser = StringUtil.getFromUnicodeLE(textBytes);
        } else {
            byte[] textBytes = new byte[(int)usernameLen];
            System.arraycopy(this._contents, 28, textBytes, 0, (int)usernameLen);
            this.lastEditUser = StringUtil.getFromCompressedUnicode(textBytes, 0, (int)usernameLen);
        }
    }

    public void dispose() {
        this._contents = null;
        this.lastEditUser = null;
    }
}

