/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordTypes;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.util.SystemTimeUtils;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;

public final class Comment2000Atom
extends RecordAtom {
    private byte[] _header = new byte[8];
    private byte[] _data;

    protected Comment2000Atom() {
        this._data = new byte[28];
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        LittleEndian.putInt(this._header, 4, this._data.length);
    }

    protected Comment2000Atom(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._data = new byte[len - 8];
        System.arraycopy(source, start + 8, this._data, 0, len - 8);
    }

    public int getNumber() {
        return LittleEndian.getInt(this._data, 0);
    }

    public void setNumber(int number) {
        LittleEndian.putInt(this._data, 0, number);
    }

    public Date getDate() {
        return SystemTimeUtils.getDate(this._data, 4);
    }

    public void setDate(Date date) {
        SystemTimeUtils.storeDate(date, this._data, 4);
    }

    public int getXOffset() {
        return LittleEndian.getInt(this._data, 20);
    }

    public void setXOffset(int xOffset) {
        LittleEndian.putInt(this._data, 20, xOffset);
    }

    public int getYOffset() {
        return LittleEndian.getInt(this._data, 24);
    }

    public void setYOffset(int yOffset) {
        LittleEndian.putInt(this._data, 24, yOffset);
    }

    @Override
    public long getRecordType() {
        return RecordTypes.Comment2000Atom.typeID;
    }

    public void writeOut(OutputStream out) throws IOException {
        out.write(this._header);
        out.write(this._data);
    }

    @Override
    public void dispose() {
        this._header = null;
        this._data = null;
    }
}

