/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.AnimationInfoAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordTypes;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;

public final class AnimationInfo
extends RecordContainer {
    private byte[] _header = new byte[8];
    private AnimationInfoAtom animationAtom;

    protected AnimationInfo(byte[] source, int start, int len) {
        System.arraycopy(source, start, this._header, 0, 8);
        this._children = Record.findChildRecords(source, start + 8, len - 8);
        this.findInterestingChildren();
    }

    private void findInterestingChildren() {
        if (this._children[0] instanceof AnimationInfoAtom) {
            this.animationAtom = (AnimationInfoAtom)this._children[0];
        }
    }

    public AnimationInfo() {
        this._header[0] = 15;
        LittleEndian.putShort(this._header, 2, (short)this.getRecordType());
        this._children = new Record[1];
        this.animationAtom = new AnimationInfoAtom();
        this._children[0] = this.animationAtom;
    }

    @Override
    public long getRecordType() {
        return RecordTypes.AnimationInfo.typeID;
    }

    public AnimationInfoAtom getAnimationInfoAtom() {
        return this.animationAtom;
    }

    @Override
    public void dispose() {
        super.dispose();
        this._header = null;
        if (this.animationAtom != null) {
            this.animationAtom.dispose();
            this.animationAtom = null;
        }
    }
}

