/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.textproperties;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.textproperties.CharFlagsTextProp;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.textproperties.TextProp;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.StyleTextPropAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.util.LinkedList;

public class TextPropCollection {
    private int charactersCovered;
    private short reservedField;
    private LinkedList<TextProp> textPropList;
    private int maskSpecial = 0;

    public int getSpecialMask() {
        return this.maskSpecial;
    }

    public int getCharactersCovered() {
        return this.charactersCovered;
    }

    public LinkedList<TextProp> getTextPropList() {
        return this.textPropList;
    }

    public TextProp findByName(String textPropName) {
        for (int i = 0; i < this.textPropList.size(); ++i) {
            TextProp prop = this.textPropList.get(i);
            if (!prop.getName().equals(textPropName)) continue;
            return prop;
        }
        return null;
    }

    public TextProp addWithName(String name) {
        int i;
        TextProp base = null;
        for (i = 0; i < StyleTextPropAtom.characterTextPropTypes.length; ++i) {
            if (!StyleTextPropAtom.characterTextPropTypes[i].getName().equals(name)) continue;
            base = StyleTextPropAtom.characterTextPropTypes[i];
        }
        for (i = 0; i < StyleTextPropAtom.paragraphTextPropTypes.length; ++i) {
            if (!StyleTextPropAtom.paragraphTextPropTypes[i].getName().equals(name)) continue;
            base = StyleTextPropAtom.paragraphTextPropTypes[i];
        }
        if (base == null) {
            throw new IllegalArgumentException("No TextProp with name " + name + " is defined to add from");
        }
        TextProp textProp = (TextProp)base.clone();
        int pos = 0;
        for (int i2 = 0; i2 < this.textPropList.size(); ++i2) {
            TextProp curProp = this.textPropList.get(i2);
            if (textProp.getMask() <= curProp.getMask()) continue;
            ++pos;
        }
        this.textPropList.add(pos, textProp);
        return textProp;
    }

    public int buildTextPropList(int containsField, TextProp[] potentialProperties, byte[] data, int dataOffset) {
        int bytesPassed = 0;
        for (int i = 0; i < potentialProperties.length; ++i) {
            if ((containsField & potentialProperties[i].getMask()) == 0) continue;
            if (dataOffset + bytesPassed >= data.length) {
                this.maskSpecial |= potentialProperties[i].getMask();
                return bytesPassed;
            }
            TextProp prop = (TextProp)potentialProperties[i].clone();
            int val = 0;
            if (prop.getSize() == 2) {
                val = LittleEndian.getShort(data, dataOffset + bytesPassed);
            } else if (prop.getSize() == 4) {
                val = LittleEndian.getInt(data, dataOffset + bytesPassed);
            } else if (prop.getSize() == 0) {
                this.maskSpecial |= potentialProperties[i].getMask();
                continue;
            }
            if (CharFlagsTextProp.NAME.equals(prop.getName()) && val < 0) {
                val = 0;
            }
            prop.setValue(val);
            bytesPassed += prop.getSize();
            if ("tabStops".equals(prop.getName())) {
                bytesPassed += val * 4;
            }
            this.textPropList.add(prop);
        }
        return bytesPassed;
    }

    public TextPropCollection(int charactersCovered, short reservedField) {
        this.charactersCovered = charactersCovered;
        this.reservedField = reservedField;
        this.textPropList = new LinkedList();
    }

    public TextPropCollection(int textSize) {
        this.charactersCovered = textSize;
        this.reservedField = (short)-1;
        this.textPropList = new LinkedList();
    }

    public void updateTextSize(int textSize) {
        this.charactersCovered = textSize;
    }

    public short getReservedField() {
        return this.reservedField;
    }

    public void setReservedField(short val) {
        this.reservedField = val;
    }

    public void dispose() {
        if (this.textPropList != null) {
            for (int i = 0; i < this.textPropList.size(); ++i) {
                this.textPropList.get(i).dispose();
            }
            this.textPropList.clear();
            this.textPropList = null;
        }
    }
}

