/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.ShapeKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSimpleProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherTextboxRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.MasterSheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Shape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.ShapeGroup;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.SimpleShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.TextRun;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.EscherTextboxWrapper;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.InteractiveInfo;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.InteractiveInfoAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.OEPlaceholderAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.OutlineTextRefAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.PPDrawing;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordTypes;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RoundTripHFPlaceholder12;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.StyleTextPropAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.TextCharsAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.TextHeaderAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.TextRulerAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.TxInteractiveInfoAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.usermodel.RichTextRun;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.Rectangle2D;

public abstract class TextShape
extends SimpleShape {
    public static final int AnchorTop = 0;
    public static final int AnchorMiddle = 1;
    public static final int AnchorBottom = 2;
    public static final int AnchorTopCentered = 3;
    public static final int AnchorMiddleCentered = 4;
    public static final int AnchorBottomCentered = 5;
    public static final int AnchorTopBaseline = 6;
    public static final int AnchorBottomBaseline = 7;
    public static final int AnchorTopCenteredBaseline = 8;
    public static final int AnchorBottomCenteredBaseline = 9;
    public static final int WrapSquare = 0;
    public static final int WrapByPoints = 1;
    public static final int WrapNone = 2;
    public static final int WrapTopBottom = 3;
    public static final int WrapThrough = 4;
    public static final int AlignLeft = 0;
    public static final int AlignCenter = 1;
    public static final int AlignRight = 2;
    public static final int AlignJustify = 3;
    protected TextRun _txtrun;
    protected EscherTextboxWrapper _txtbox;

    protected TextShape(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    public TextShape(Shape parent) {
        super(null, parent);
        this._escherContainer = this.createSpContainer(parent instanceof ShapeGroup);
    }

    public TextShape() {
        this(null);
    }

    public TextRun createTextRun() {
        this._txtbox = this.getEscherTextboxWrapper();
        if (this._txtbox == null) {
            this._txtbox = new EscherTextboxWrapper();
        }
        this._txtrun = this.getTextRun();
        if (this._txtrun == null) {
            TextHeaderAtom tha = new TextHeaderAtom();
            tha.setParentRecord(this._txtbox);
            this._txtbox.appendChildRecord(tha);
            TextCharsAtom tca = new TextCharsAtom();
            this._txtbox.appendChildRecord(tca);
            StyleTextPropAtom sta = new StyleTextPropAtom(0);
            this._txtbox.appendChildRecord(sta);
            this._txtrun = new TextRun(tha, tca, sta);
            this._txtrun._records = new Record[]{tha, tca, sta};
            this._txtrun.setText("");
            this._escherContainer.addChildRecord(this._txtbox.getEscherRecord());
            this.setDefaultTextProperties(this._txtrun);
        }
        return this._txtrun;
    }

    protected void setDefaultTextProperties(TextRun _txtrun) {
    }

    public String getText() {
        TextRun tx = this.getTextRun();
        return tx == null ? null : tx.getText();
    }

    public void setText(String text) {
        TextRun tx = this.getTextRun();
        if (tx == null) {
            tx = this.createTextRun();
        }
        tx.setText(text);
        this.setTextId(text.hashCode());
    }

    @Override
    protected void afterInsert(Sheet sh) {
        super.afterInsert(sh);
        EscherTextboxWrapper _txtbox = this.getEscherTextboxWrapper();
        if (_txtbox != null) {
            PPDrawing ppdrawing = sh.getPPDrawing();
            ppdrawing.addTextboxWrapper(_txtbox);
            if (this.getAnchor().equals(new Rectangle()) && !"".equals(this.getText())) {
                this.resizeToFitText();
            }
        }
        if (this._txtrun != null) {
            this._txtrun.setShapeId(this.getShapeId());
            sh.onAddTextShape(this);
        }
    }

    protected EscherTextboxWrapper getEscherTextboxWrapper() {
        EscherTextboxRecord textRecord;
        if (this._txtbox == null && (textRecord = (EscherTextboxRecord)ShapeKit.getEscherChild(this._escherContainer, -4083)) != null) {
            this._txtbox = new EscherTextboxWrapper(textRecord);
        }
        return this._txtbox;
    }

    public byte getMetaCharactersType() {
        EscherTextboxWrapper clientTextBox = this.getEscherTextboxWrapper();
        if (clientTextBox != null) {
            Record[] children = clientTextBox.getChildRecords();
            for (int i = 0; i < children.length; ++i) {
                if (children[i] == null) continue;
                long rType = children[i].getRecordType();
                if (rType == (long)RecordTypes.SlideNumberMCAtom.typeID) {
                    return 1;
                }
                if (rType == (long)RecordTypes.DateTimeMCAtom.typeID) {
                    return 2;
                }
                if (rType == (long)RecordTypes.GenericDateMCAtom.typeID) {
                    return 3;
                }
                if (rType == (long)RecordTypes.RTFDateTimeMCAtom.typeID) {
                    return 5;
                }
                if (rType != (long)RecordTypes.FooterMCAtom.typeID) continue;
                return 4;
            }
        }
        return -1;
    }

    public Rectangle2D resizeToFitText() {
        Rectangle2D anchor = this.getAnchor2D();
        return anchor;
    }

    public int getVerticalAlignment() {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 135);
        int valign = 0;
        if (prop == null) {
            int type = this.getTextRun().getRunType();
            MasterSheet master = this.getSheet().getMasterSheet();
            TextShape masterShape = null;
            if (master != null && this.getPlaceholderAtom() != null) {
                masterShape = master.getPlaceholderByTextType(type);
            }
            if (masterShape != null) {
                valign = masterShape.getVerticalAlignment();
            } else {
                switch (type) {
                    case 0: 
                    case 6: {
                        valign = 1;
                        break;
                    }
                    default: {
                        valign = 0;
                    }
                }
            }
        } else {
            valign = prop.getPropertyValue();
        }
        return valign;
    }

    public void setVerticalAlignment(int align) {
        this.setEscherProperty((short)135, align);
    }

    public void setHorizontalAlignment(int align) {
        TextRun tx = this.getTextRun();
        if (tx != null) {
            tx.getRichTextRuns()[0].setAlignment(align);
        }
    }

    public int getHorizontalAlignment() {
        TextRun tx = this.getTextRun();
        return tx == null ? -1 : tx.getRichTextRuns()[0].getAlignment();
    }

    public float getMarginBottom() {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 132);
        int val = prop == null ? 45720 : prop.getPropertyValue();
        return (float)val / 12700.0f;
    }

    public void setMarginBottom(float margin) {
        this.setEscherProperty((short)132, (int)(margin * 12700.0f));
    }

    public float getMarginLeft() {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 129);
        int val = prop == null ? 91440 : prop.getPropertyValue();
        return (float)val / 12700.0f;
    }

    public void setMarginLeft(float margin) {
        this.setEscherProperty((short)129, (int)(margin * 12700.0f));
    }

    public float getMarginRight() {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 131);
        int val = prop == null ? 91440 : prop.getPropertyValue();
        return (float)val / 12700.0f;
    }

    public void setMarginRight(float margin) {
        this.setEscherProperty((short)131, (int)(margin * 12700.0f));
    }

    public float getMarginTop() {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 130);
        int val = prop == null ? 45720 : prop.getPropertyValue();
        return (float)val / 12700.0f;
    }

    public void setMarginTop(float margin) {
        this.setEscherProperty((short)130, (int)(margin * 12700.0f));
    }

    public int getWordWrap() {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 133);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    public void setWordWrap(int wrap) {
        this.setEscherProperty((short)133, wrap);
    }

    public int getTextId() {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 128);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    public void setTextId(int id2) {
        this.setEscherProperty((short)128, id2);
    }

    public TextRun getTextRun() {
        if (this._txtrun == null) {
            this.initTextRun();
        }
        return this._txtrun;
    }

    @Override
    public void setSheet(Sheet sheet) {
        this._sheet = sheet;
        TextRun tx = this.getTextRun();
        if (tx != null) {
            tx.setSheet(this._sheet);
            RichTextRun[] rt = tx.getRichTextRuns();
            for (int i = 0; i < rt.length; ++i) {
                rt[i].supplySlideShow(this._sheet.getSlideShow());
            }
        }
    }

    protected void initTextRun() {
        EscherTextboxWrapper txtbox = this.getEscherTextboxWrapper();
        Sheet sheet = this.getSheet();
        if (sheet == null || txtbox == null) {
            return;
        }
        OutlineTextRefAtom ota = null;
        Record[] child = txtbox.getChildRecords();
        for (int i = 0; i < child.length; ++i) {
            if (!(child[i] instanceof OutlineTextRefAtom)) continue;
            ota = (OutlineTextRefAtom)child[i];
            break;
        }
        TextRun[] runs = this._sheet.getTextRuns();
        if (ota != null) {
            int idx = ota.getTextIndex();
            for (int i = 0; i < runs.length; ++i) {
                if (runs[i].getIndex() != idx || runs[i].getShapeId() >= 0) continue;
                this._txtrun = runs[i];
                break;
            }
        } else {
            EscherSpRecord escherSpRecord = (EscherSpRecord)this._escherContainer.getChildById((short)-4086);
            int shapeId = escherSpRecord.getShapeId();
            if (runs != null) {
                for (int i = 0; i < runs.length; ++i) {
                    if (runs[i].getShapeId() != shapeId) continue;
                    this._txtrun = runs[i];
                    break;
                }
            }
        }
        if (this._txtrun != null) {
            for (int i = 0; i < child.length; ++i) {
                if (this._txtrun._ruler == null && child[i] instanceof TextRulerAtom) {
                    this._txtrun._ruler = (TextRulerAtom)child[i];
                }
                for (Record r : this._txtrun.getRecords()) {
                    if (child[i].getRecordType() != r.getRecordType()) continue;
                    child[i] = r;
                }
            }
        }
    }

    public OEPlaceholderAtom getPlaceholderAtom() {
        return (OEPlaceholderAtom)this.getClientDataRecord(RecordTypes.OEPlaceholderAtom.typeID);
    }

    public int getPlaceholderId() {
        int placeholderId = 0;
        OEPlaceholderAtom oep = this.getPlaceholderAtom();
        if (oep != null) {
            placeholderId = oep.getPlaceholderId();
        } else {
            RoundTripHFPlaceholder12 hldr = (RoundTripHFPlaceholder12)this.getClientDataRecord(RecordTypes.RoundTripHFPlaceholder12.typeID);
            if (hldr != null) {
                placeholderId = hldr.getPlaceholderId();
            }
        }
        return placeholderId;
    }

    public void setHyperlink(int linkId, int beginIndex, int endIndex) {
        InteractiveInfo info = new InteractiveInfo();
        InteractiveInfoAtom infoAtom = info.getInteractiveInfoAtom();
        infoAtom.setAction((byte)4);
        infoAtom.setHyperlinkType((byte)8);
        infoAtom.setHyperlinkID(linkId);
        this._txtbox.appendChildRecord(info);
        TxInteractiveInfoAtom txiatom = new TxInteractiveInfoAtom();
        txiatom.setStartIndex(beginIndex);
        txiatom.setEndIndex(endIndex);
        this._txtbox.appendChildRecord(txiatom);
    }

    @Override
    public Sheet getSheet() {
        return this._sheet;
    }

    public String getUnicodeGeoText() {
        return ShapeKit.getUnicodeGeoText(this._escherContainer);
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this._txtrun != null) {
            this._txtrun.dispose();
            this._txtrun = null;
        }
        if (this._txtbox != null) {
            this._txtbox.dispose();
            this._txtbox = null;
        }
    }
}

