/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.TextRun;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.TextShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.usermodel.RichTextRun;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.POILogFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.POILogger;
import java.awt.font.TextAttribute;
import java.text.AttributedString;

public final class TextPainter {
    protected POILogger logger = POILogFactory.getLogger(this.getClass());
    protected static final char DEFAULT_BULLET_CHAR = '\u25a0';
    protected TextShape _shape;

    public TextPainter(TextShape shape) {
        this._shape = shape;
    }

    public AttributedString getAttributedString(TextRun txrun) {
        String text = txrun.getText();
        text = text.replace('\t', ' ');
        text = text.replace('\u00a0', ' ');
        AttributedString at = new AttributedString(text);
        RichTextRun[] rt = txrun.getRichTextRuns();
        for (int i = 0; i < rt.length; ++i) {
            int superScript;
            int end;
            int start = rt[i].getStartIndex();
            if (start == (end = rt[i].getEndIndex())) {
                this.logger.log(POILogger.INFO, "Skipping RichTextRun with zero length");
                continue;
            }
            at.addAttribute(TextAttribute.FAMILY, rt[i].getFontName(), start, end);
            at.addAttribute(TextAttribute.SIZE, new Float(rt[i].getFontSize()), start, end);
            at.addAttribute(TextAttribute.FOREGROUND, rt[i].getFontColor(), start, end);
            if (rt[i].isBold()) {
                at.addAttribute(TextAttribute.WEIGHT, TextAttribute.WEIGHT_BOLD, start, end);
            }
            if (rt[i].isItalic()) {
                at.addAttribute(TextAttribute.POSTURE, TextAttribute.POSTURE_OBLIQUE, start, end);
            }
            if (rt[i].isUnderlined()) {
                at.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, start, end);
                at.addAttribute(TextAttribute.INPUT_METHOD_UNDERLINE, TextAttribute.UNDERLINE_LOW_TWO_PIXEL, start, end);
            }
            if (rt[i].isStrikethrough()) {
                at.addAttribute(TextAttribute.STRIKETHROUGH, TextAttribute.STRIKETHROUGH_ON, start, end);
            }
            if ((superScript = rt[i].getSuperscript()) == 0) continue;
            at.addAttribute(TextAttribute.SUPERSCRIPT, superScript > 0 ? TextAttribute.SUPERSCRIPT_SUPER : TextAttribute.SUPERSCRIPT_SUB, start, end);
        }
        return at;
    }

    public static class TextElement {
        public AttributedString _text;
        public int _textOffset;
        public AttributedString _bullet;
        public int _bulletOffset;
        public int _align;
        public float ascent;
        public float descent;
        public float advance;
        public int textStartIndex;
        public int textEndIndex;
    }
}

