/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.ShapeKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherDgRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherDggRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Background;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Comment;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.HeadersFooters;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.MasterSheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Notes;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Placeholder;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.SlideMaster;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.TextBox;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.TextRun;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.TextShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.TitleMaster;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ColorSchemeAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Comment2000;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExtendedParagraphHeaderAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExtendedPresRuleContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.HeadersFootersContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordTypes;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.SlideAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.SlideListWithText;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.SlideProgTagsContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.SlideShowSlideInfoAtom;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import java.util.Vector;

public final class Slide
extends Sheet {
    private int _slideNo;
    private SlideListWithText.SlideAtomsSet _atomSet;
    private TextRun[] _runs;
    private Notes _notes;
    private ExtendedPresRuleContainer.ExtendedParaAtomsSet[] _extendedAtomsSets;
    private SlideShowSlideInfoAtom ssSlideInfoAtom;
    private SlideProgTagsContainer propTagsContainer;

    public Slide(com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Slide slide, Notes notes, SlideListWithText.SlideAtomsSet atomSet, ExtendedPresRuleContainer.ExtendedParaAtomsSet[] extendedAtomsSets, int slideIdentifier, int slideNumber) {
        super(slide, slideIdentifier);
        this._notes = notes;
        this._atomSet = atomSet;
        this._slideNo = slideNumber;
        this._extendedAtomsSets = extendedAtomsSets;
        TextRun[] _otherRuns = Slide.findTextRuns(this.getPPDrawing());
        Vector textRuns = new Vector();
        if (this._atomSet != null) {
            Slide.findTextRuns(this._atomSet.getSlideRecords(), textRuns);
        }
        this._runs = new TextRun[textRuns.size() + _otherRuns.length];
        int i = 0;
        for (i = 0; i < textRuns.size(); ++i) {
            this._runs[i] = (TextRun)textRuns.get(i);
            this._runs[i].setSheet(this);
        }
        for (int k = 0; k < _otherRuns.length; ++k) {
            this._runs[i] = _otherRuns[k];
            this._runs[i].setSheet(this);
            ++i;
        }
        if (this._extendedAtomsSets != null) {
            block2: for (i = 0; i < this._runs.length; ++i) {
                if (this._runs[i].getExtendedParagraphAtom() != null) continue;
                int type = this._runs[i].getRunType();
                for (int j = 0; j < this._extendedAtomsSets.length; ++j) {
                    ExtendedParagraphHeaderAtom paraHeaderAtom = this._extendedAtomsSets[j].getExtendedParaHeaderAtom();
                    if (paraHeaderAtom == null || paraHeaderAtom.getTextType() != type) continue;
                    this._runs[i].setExtendedParagraphAtom(this._extendedAtomsSets[j].getExtendedParaAtom());
                    continue block2;
                }
            }
        }
    }

    public Slide(int sheetNumber, int sheetRefId, int slideNumber) {
        super(new com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Slide(), sheetNumber);
        this._slideNo = slideNumber;
        this.getSheetContainer().setSheetId(sheetRefId);
    }

    public void setNotes(Notes notes) {
        this._notes = notes;
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        if (notes == null) {
            sa.setNotesID(0);
        } else {
            sa.setNotesID(notes._getSheetNumber());
        }
    }

    public void setSlideNumber(int newSlideNumber) {
        this._slideNo = newSlideNumber;
    }

    @Override
    public void onCreate() {
        EscherDggRecord dgg = this.getSlideShow().getDocumentRecord().getPPDrawingGroup().getEscherDggRecord();
        EscherContainerRecord dgContainer = (EscherContainerRecord)this.getSheetContainer().getPPDrawing().getEscherRecords()[0];
        EscherDgRecord dg = (EscherDgRecord)ShapeKit.getEscherChild(dgContainer, -4088);
        int dgId = dgg.getMaxDrawingGroupId() + 1;
        dg.setOptions((short)(dgId << 4));
        dgg.setDrawingsSaved(dgg.getDrawingsSaved() + 1);
        dgg.setMaxDrawingGroupId(dgId);
        for (EscherContainerRecord c : dgContainer.getChildContainers()) {
            EscherSpRecord spr = null;
            switch (c.getRecordId()) {
                case -4093: {
                    EscherContainerRecord dc = (EscherContainerRecord)c.getChild(0);
                    spr = (EscherSpRecord)dc.getChildById((short)-4086);
                    break;
                }
                case -4092: {
                    spr = (EscherSpRecord)c.getChildById((short)-4086);
                }
            }
            if (spr == null) continue;
            spr.setShapeId(this.allocateShapeId());
        }
        dg.setNumShapes(1);
    }

    public TextBox addTitle() {
        Placeholder pl = new Placeholder();
        pl.setShapeType(1);
        pl.getTextRun().setRunType(0);
        pl.setText("Click to edit title");
        pl.setAnchor(new Rectangle(54, 48, 612, 90));
        this.addShape(pl);
        return pl;
    }

    public String getTitle() {
        TextRun[] txt = this.getTextRuns();
        for (int i = 0; i < txt.length; ++i) {
            int type = txt[i].getRunType();
            if (type != 6 && type != 0) continue;
            String title = txt[i].getText();
            return title;
        }
        return null;
    }

    @Override
    public TextRun[] getTextRuns() {
        return this._runs;
    }

    public int getSlideNumber() {
        return this._slideNo;
    }

    public com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Slide getSlideRecord() {
        return (com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Slide)this.getSheetContainer();
    }

    public Notes getNotesSheet() {
        return this._notes;
    }

    protected SlideListWithText.SlideAtomsSet getSlideAtomsSet() {
        return this._atomSet;
    }

    @Override
    public MasterSheet getMasterSheet() {
        TitleMaster[] titleMaster;
        SlideMaster[] master = this.getSlideShow().getSlidesMasters();
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        int masterId = sa.getMasterID();
        MasterSheet sheet = null;
        for (int i = 0; i < master.length; ++i) {
            if (masterId != master[i]._getSheetNumber()) continue;
            sheet = master[i];
            break;
        }
        if (sheet == null && (titleMaster = this.getSlideShow().getTitleMasters()) != null) {
            for (int i = 0; i < titleMaster.length; ++i) {
                if (masterId != titleMaster[i]._getSheetNumber()) continue;
                sheet = titleMaster[i];
                break;
            }
        }
        return sheet;
    }

    public void setMasterSheet(MasterSheet master) {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        int sheetNo = master._getSheetNumber();
        sa.setMasterID(sheetNo);
    }

    public HeadersFooters getSlideHeadersFooters() {
        HeadersFootersContainer container = this.getSlideRecord().getHeadersFootersContainer();
        if (container != null) {
            return new HeadersFooters(container, this, false, false);
        }
        return null;
    }

    public void setFollowMasterBackground(boolean flag) {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        sa.setFollowMasterBackground(flag);
    }

    public boolean getFollowMasterBackground() {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        return sa.getFollowMasterBackground();
    }

    public void setFollowMasterObjects(boolean flag) {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        sa.setFollowMasterObjects(flag);
    }

    public boolean getFollowMasterScheme() {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        return sa.getFollowMasterScheme();
    }

    public void setFollowMasterScheme(boolean flag) {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        sa.setFollowMasterScheme(flag);
    }

    public boolean getFollowMasterObjects() {
        SlideAtom sa = this.getSlideRecord().getSlideAtom();
        return sa.getFollowMasterObjects();
    }

    @Override
    public Background getBackground() {
        if (this.getFollowMasterBackground()) {
            return this.getMasterSheet().getBackground();
        }
        return super.getBackground();
    }

    @Override
    public ColorSchemeAtom getColorScheme() {
        if (this.getFollowMasterScheme()) {
            return this.getMasterSheet().getColorScheme();
        }
        return super.getColorScheme();
    }

    public Comment[] getComments() {
        RecordContainer binaryTags;
        RecordContainer progBinaryTag;
        RecordContainer progTags = (RecordContainer)this.getSheetContainer().findFirstOfType(RecordTypes.SlideProgTagsContainer.typeID);
        if (progTags != null && (progBinaryTag = (RecordContainer)progTags.findFirstOfType(RecordTypes.SlideProgBinaryTagContainer.typeID)) != null && (binaryTags = (RecordContainer)progBinaryTag.findFirstOfType(RecordTypes.BinaryTagDataBlob.typeID)) != null) {
            int count = 0;
            for (int i = 0; i < binaryTags.getChildRecords().length; ++i) {
                if (!(binaryTags.getChildRecords()[i] instanceof Comment2000)) continue;
                ++count;
            }
            Comment[] comments = new Comment[count];
            count = 0;
            for (int i = 0; i < binaryTags.getChildRecords().length; ++i) {
                if (!(binaryTags.getChildRecords()[i] instanceof Comment2000)) continue;
                comments[i] = new Comment((Comment2000)binaryTags.getChildRecords()[i]);
                ++count;
            }
            return comments;
        }
        return new Comment[0];
    }

    @Override
    protected void onAddTextShape(TextShape shape) {
        TextRun run = shape.getTextRun();
        if (this._runs == null) {
            this._runs = new TextRun[]{run};
        } else {
            TextRun[] tmp = new TextRun[this._runs.length + 1];
            System.arraycopy(this._runs, 0, tmp, 0, this._runs.length);
            tmp[tmp.length - 1] = run;
            this._runs = tmp;
        }
    }

    public void setExtendedAtom(ExtendedPresRuleContainer.ExtendedParaAtomsSet[] extendAtomsSets) {
        this._extendedAtomsSets = extendAtomsSets;
    }

    public void setSlideShowSlideInfoAtom(SlideShowSlideInfoAtom ssSlideInfoAtom) {
        this.ssSlideInfoAtom = ssSlideInfoAtom;
    }

    public SlideShowSlideInfoAtom getSlideShowSlideInfoAtom() {
        return this.ssSlideInfoAtom;
    }

    public void setSlideProgTagsContainer(SlideProgTagsContainer propTagsContainer) {
        this.propTagsContainer = propTagsContainer;
    }

    public SlideProgTagsContainer getSlideProgTagsContainer() {
        return this.propTagsContainer;
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this._atomSet != null) {
            this._atomSet.dispose();
            this._atomSet = null;
        }
        if (this._runs != null) {
            for (TextRun tr : this._runs) {
                tr.dispose();
            }
            this._runs = null;
        }
        if (this._notes != null) {
            this._notes.dispose();
            this._notes = null;
        }
        if (this._extendedAtomsSets != null) {
            for (ExtendedPresRuleContainer.ExtendedParaAtomsSet eps : this._extendedAtomsSets) {
                eps.dispose();
            }
            this._extendedAtomsSets = null;
        }
        if (this.ssSlideInfoAtom != null) {
            this.ssSlideInfoAtom.dispose();
            this.ssSlideInfoAtom = null;
        }
        if (this.propTagsContainer != null) {
            this.propTagsContainer.dispose();
            this.propTagsContainer = null;
        }
    }
}

