/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.ShapeKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.DefaultEscherRecordFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherChildAnchorRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherClientAnchorRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherClientDataRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSimpleProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.exceptions.HSLFException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Hyperlink;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Shape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.ShapeGroup;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.InteractiveInfo;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.InteractiveInfoAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Color;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.AffineTransform;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.Rectangle2D;
import java.io.ByteArrayOutputStream;

public abstract class SimpleShape
extends Shape {
    protected Record[] _clientRecords;
    protected EscherClientDataRecord _clientData;

    protected SimpleShape(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    @Override
    public Rectangle2D getLogicalAnchor2D() {
        int angle;
        Rectangle2D anchor = this.getAnchor2D();
        if (this._parent != null) {
            Rectangle2D clientAnchor = ((ShapeGroup)this._parent).getClientAnchor2D(this._parent);
            Rectangle2D spgrAnchor = ((ShapeGroup)this._parent).getCoordinates();
            double scalex = spgrAnchor.getWidth() / clientAnchor.getWidth();
            double scaley = spgrAnchor.getHeight() / clientAnchor.getHeight();
            double x = clientAnchor.getX() + (anchor.getX() - spgrAnchor.getX()) / scalex;
            double y = clientAnchor.getY() + (anchor.getY() - spgrAnchor.getY()) / scaley;
            double width = anchor.getWidth() / scalex;
            double height = anchor.getHeight() / scaley;
            anchor = new Rectangle2D.Double(x, y, width, height);
        }
        if ((angle = this.getRotation()) != 0) {
            double centerX = anchor.getX() + anchor.getWidth() / 2.0;
            double centerY = anchor.getY() + anchor.getHeight() / 2.0;
            AffineTransform trans = new AffineTransform();
            trans.translate(centerX, centerY);
            trans.rotate(Math.toRadians(angle));
            trans.translate(-centerX, -centerY);
            Rectangle2D rect = trans.createTransformedShape(anchor).getBounds2D();
            if (anchor.getWidth() < anchor.getHeight() && rect.getWidth() > rect.getHeight() || anchor.getWidth() > anchor.getHeight() && rect.getWidth() < rect.getHeight()) {
                trans = new AffineTransform();
                trans.translate(centerX, centerY);
                trans.rotate(1.5707963267948966);
                trans.translate(-centerX, -centerY);
                anchor = trans.createTransformedShape(anchor).getBounds2D();
            }
        }
        return anchor;
    }

    protected Record getClientDataRecord(int recordType) {
        Record[] records = this.getClientRecords();
        if (records != null) {
            for (int i = 0; i < records.length; ++i) {
                if (records[i].getRecordType() != (long)recordType) continue;
                return records[i];
            }
        }
        return null;
    }

    protected Record[] getClientRecords() {
        if (this._clientData == null) {
            EscherRecord r = ShapeKit.getEscherChild(this.getSpContainer(), -4079);
            if (r != null && !(r instanceof EscherClientDataRecord)) {
                byte[] data = r.serialize();
                r = new EscherClientDataRecord();
                r.fillFields(data, 0, new DefaultEscherRecordFactory());
            }
            this._clientData = (EscherClientDataRecord)r;
        }
        if (this._clientData != null && this._clientRecords == null) {
            byte[] data = this._clientData.getRemainingData();
            this._clientRecords = Record.findChildRecords(data, 0, data.length);
        }
        return this._clientRecords;
    }

    @Override
    protected EscherContainerRecord createSpContainer(boolean isChild) {
        EscherRecord anchor;
        this._escherContainer = new EscherContainerRecord();
        this._escherContainer.setRecordId((short)-4092);
        this._escherContainer.setOptions((short)15);
        EscherSpRecord sp = new EscherSpRecord();
        int flags = 2560;
        if (isChild) {
            flags |= 2;
        }
        sp.setFlags(flags);
        this._escherContainer.addChildRecord(sp);
        EscherOptRecord opt = new EscherOptRecord();
        opt.setRecordId((short)-4085);
        this._escherContainer.addChildRecord(opt);
        if (isChild) {
            anchor = new EscherChildAnchorRecord();
        } else {
            anchor = new EscherClientAnchorRecord();
            byte[] header = new byte[16];
            LittleEndian.putUShort(header, 0, 0);
            LittleEndian.putUShort(header, 2, 0);
            LittleEndian.putInt(header, 4, 8);
            anchor.fillFields(header, 0, null);
        }
        this._escherContainer.addChildRecord(anchor);
        return this._escherContainer;
    }

    public void setLineWidth(double width) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
        SimpleShape.setEscherProperty(opt, (short)459, (int)(width * 12700.0));
    }

    public void setLineColor(Color color2) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
        if (color2 == null) {
            SimpleShape.setEscherProperty(opt, (short)511, 524288);
        } else {
            int rgb = new Color(color2.getBlue(), color2.getGreen(), color2.getRed(), 0).getRGB();
            SimpleShape.setEscherProperty(opt, (short)448, rgb);
            SimpleShape.setEscherProperty(opt, (short)511, color2 == null ? 0x180010 : 0x180018);
        }
    }

    public int getLineDashing() {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 462);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    public void setLineDashing(int pen) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
        SimpleShape.setEscherProperty(opt, (short)462, pen);
    }

    public void setLineStyle(int style2) {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
        SimpleShape.setEscherProperty(opt, (short)461, style2 == 0 ? -1 : style2);
    }

    public int getLineStyle() {
        EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)ShapeKit.getEscherProperty(opt, 461);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    public void setFillColor(Color color2) {
        this.getFill().setForegroundColor(color2);
    }

    public void setRotation(int theta) {
        this.setEscherProperty((short)4, theta << 16);
    }

    protected void updateClientData() {
        if (this._clientData != null && this._clientRecords != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                for (int i = 0; i < this._clientRecords.length; ++i) {
                }
            }
            catch (Exception e) {
                throw new HSLFException(e);
            }
            this._clientData.setRemainingData(out.toByteArray());
        }
    }

    public void setHyperlink(Hyperlink link) {
        if (link.getId() == -1) {
            throw new HSLFException("You must call SlideShow.addHyperlink(Hyperlink link) first");
        }
        EscherClientDataRecord cldata = new EscherClientDataRecord();
        cldata.setOptions((short)15);
        this.getSpContainer().addChildRecord(cldata);
        InteractiveInfo info = new InteractiveInfo();
        InteractiveInfoAtom infoAtom = info.getInteractiveInfoAtom();
        switch (link.getType()) {
            case 2: {
                infoAtom.setAction((byte)3);
                infoAtom.setJump((byte)3);
                infoAtom.setHyperlinkType((byte)2);
                break;
            }
            case 3: {
                infoAtom.setAction((byte)3);
                infoAtom.setJump((byte)4);
                infoAtom.setHyperlinkType((byte)3);
                break;
            }
            case 0: {
                infoAtom.setAction((byte)3);
                infoAtom.setJump((byte)1);
                infoAtom.setHyperlinkType((byte)0);
                break;
            }
            case 1: {
                infoAtom.setAction((byte)3);
                infoAtom.setJump((byte)2);
                infoAtom.setHyperlinkType((byte)1);
                break;
            }
            case 8: {
                infoAtom.setAction((byte)4);
                infoAtom.setJump((byte)0);
                infoAtom.setHyperlinkType((byte)8);
            }
        }
        infoAtom.setHyperlinkID(link.getId());
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this._clientRecords != null) {
            for (Record rec : this._clientRecords) {
                rec.dispose();
            }
            this._clientRecords = null;
        }
        if (this._clientData != null) {
            this._clientData.dispose();
            this._clientData = null;
        }
    }
}

