/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.ShapeKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherPropertyFactory;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSimpleProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.AutoShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Freeform;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Line;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.OLEShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Picture;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Shape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.ShapeGroup;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.SimpleShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Table;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.TextBox;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.InteractiveInfo;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.OEShapeAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordTypes;
import java.util.Iterator;
import java.util.List;

public final class ShapeFactory {
    public static Shape createShape(EscherContainerRecord spContainer, Shape parent) {
        if (spContainer.getRecordId() == -4093) {
            return ShapeFactory.createShapeGroup(spContainer, parent);
        }
        return ShapeFactory.createSimpeShape(spContainer, parent);
    }

    public static ShapeGroup createShapeGroup(EscherContainerRecord spContainer, Shape parent) {
        ShapeGroup group;
        block5: {
            group = null;
            EscherRecord opt = ShapeKit.getEscherChild((EscherContainerRecord)spContainer.getChild(0), -3806);
            if (opt != null) {
                try {
                    EscherPropertyFactory f = new EscherPropertyFactory();
                    List<EscherProperty> props = f.createProperties(opt.serialize(), 8, opt.getInstance());
                    EscherSimpleProperty p = (EscherSimpleProperty)props.get(0);
                    if (p.getPropertyNumber() == 927 && p.getPropertyValue() == 1) {
                        group = new Table(spContainer, parent);
                        break block5;
                    }
                    group = new ShapeGroup(spContainer, parent);
                }
                catch (Exception e) {
                    group = new ShapeGroup(spContainer, parent);
                }
            } else {
                group = new ShapeGroup(spContainer, parent);
            }
        }
        return group;
    }

    public static Shape createSimpeShape(EscherContainerRecord spContainer, Shape parent) {
        SimpleShape shape = null;
        EscherSpRecord spRecord = (EscherSpRecord)spContainer.getChildById((short)-4086);
        int type = spRecord.getOptions() >> 4;
        switch (type) {
            case 202: {
                shape = new TextBox(spContainer, parent);
                break;
            }
            case 75: 
            case 201: {
                InteractiveInfo info = (InteractiveInfo)ShapeFactory.getClientDataRecord(spContainer, RecordTypes.InteractiveInfo.typeID);
                OEShapeAtom oes = (OEShapeAtom)ShapeFactory.getClientDataRecord(spContainer, RecordTypes.OEShapeAtom.typeID);
                if ((info == null || info.getInteractiveInfoAtom() == null) && oes != null) {
                    shape = new OLEShape(spContainer, parent);
                }
                if (shape != null) break;
                shape = new Picture(spContainer, parent);
                break;
            }
            case 20: 
            case 32: 
            case 33: 
            case 34: 
            case 38: {
                shape = new Line(spContainer, parent);
                break;
            }
            case 0: 
            case 100: {
                EscherProperty prop;
                EscherOptRecord opt = (EscherOptRecord)ShapeKit.getEscherChild(spContainer, -4085);
                if (opt == null || (prop = ShapeKit.getEscherProperty(opt, 325)) == null) break;
                shape = new Freeform(spContainer, parent);
                break;
            }
            default: {
                shape = new AutoShape(spContainer, parent);
            }
        }
        shape.setShapeId(spRecord.getShapeId());
        return shape;
    }

    protected static Record getClientDataRecord(EscherContainerRecord spContainer, int recordType) {
        Record oep = null;
        Iterator<EscherRecord> it = spContainer.getChildIterator();
        while (it.hasNext()) {
            EscherRecord obj = it.next();
            if (obj.getRecordId() != -4079) continue;
            byte[] data = obj.serialize();
            Record[] records = Record.findChildRecords(data, 8, data.length - 8);
            for (int j = 0; j < records.length; ++j) {
                if (records[j].getRecordType() != (long)recordType) continue;
                return records[j];
            }
        }
        return oep;
    }
}

