/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.ShapeKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherChildAnchorRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherClientAnchorRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSimpleProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSpRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Fill;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Hyperlink;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.ShapeTypes;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Sheet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ColorSchemeAtom;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Color;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.List;

public abstract class Shape {
    protected EscherContainerRecord _escherContainer;
    protected Shape _parent;
    protected Sheet _sheet;
    protected Fill _fill;

    protected Shape(EscherContainerRecord escherRecord, Shape parent) {
        this._escherContainer = escherRecord;
        this._parent = parent;
    }

    public Shape getParent() {
        return this._parent;
    }

    public int getShapeType() {
        return ShapeKit.getShapeType(this._escherContainer);
    }

    public int getShapeId() {
        return ShapeKit.getShapeId(this._escherContainer);
    }

    public boolean isHidden() {
        return ShapeKit.isHidden(this._escherContainer);
    }

    public int getMasterShapeID() {
        return ShapeKit.getMasterShapeID(this._escherContainer);
    }

    public Rectangle2D getAnchor2D() {
        Rectangle2D.Float anchor = null;
        EscherSpRecord spRecord = (EscherSpRecord)this._escherContainer.getChildById((short)-4086);
        int flags = spRecord.getFlags();
        if ((flags & 2) != 0) {
            EscherChildAnchorRecord rec = (EscherChildAnchorRecord)ShapeKit.getEscherChild(this._escherContainer, -4081);
            if (rec == null) {
                EscherClientAnchorRecord clrec = (EscherClientAnchorRecord)ShapeKit.getEscherChild(this._escherContainer, -4080);
                anchor = new Rectangle2D.Float((float)clrec.getCol1() * 72.0f / 576.0f, (float)clrec.getFlag() * 72.0f / 576.0f, (float)(clrec.getDx1() - clrec.getCol1()) * 72.0f / 576.0f, (float)(clrec.getRow1() - clrec.getFlag()) * 72.0f / 576.0f);
            } else {
                anchor = new Rectangle2D.Float((float)rec.getDx1() * 72.0f / 576.0f, (float)rec.getDy1() * 72.0f / 576.0f, (float)(rec.getDx2() - rec.getDx1()) * 72.0f / 576.0f, (float)(rec.getDy2() - rec.getDy1()) * 72.0f / 576.0f);
            }
        } else {
            EscherClientAnchorRecord rec = (EscherClientAnchorRecord)ShapeKit.getEscherChild(this._escherContainer, -4080);
            anchor = new Rectangle2D.Float((float)rec.getCol1() * 72.0f / 576.0f, (float)rec.getFlag() * 72.0f / 576.0f, (float)(rec.getDx1() - rec.getCol1()) * 72.0f / 576.0f, (float)(rec.getRow1() - rec.getFlag()) * 72.0f / 576.0f);
        }
        return anchor;
    }

    public Rectangle getAnchor() {
        Rectangle2D anchor2d = this.getAnchor2D();
        return anchor2d.getBounds();
    }

    public EscherContainerRecord getSpContainer() {
        return this._escherContainer;
    }

    public Sheet getSheet() {
        return this._sheet;
    }

    public void setSheet(Sheet sheet) {
        this._sheet = sheet;
    }

    protected Color getColor(int rgb, int alpha) {
        if (rgb >= 0x8000000) {
            int idx = rgb - 0x8000000;
            ColorSchemeAtom ca = this.getSheet().getColorScheme();
            if (idx >= 0 && idx <= 7) {
                rgb = ca.getColor(idx);
            }
        }
        Color tmp = new Color(rgb, true);
        return new Color(tmp.getBlue(), tmp.getGreen(), tmp.getRed(), alpha);
    }

    public Fill getFill() {
        if (this._fill == null) {
            this._fill = new Fill(this);
        }
        return this._fill;
    }

    public Hyperlink getHyperlink() {
        return Hyperlink.find(this);
    }

    public static EscherRecord getEscherChild(EscherContainerRecord owner, int recordId) {
        Iterator<EscherRecord> iterator = owner.getChildIterator();
        while (iterator.hasNext()) {
            EscherRecord escherRecord = iterator.next();
            if (escherRecord.getRecordId() != recordId) continue;
            return escherRecord;
        }
        return null;
    }

    public static EscherProperty getEscherProperty(EscherOptRecord opt, int propId) {
        if (opt != null) {
            for (EscherProperty prop : opt.getEscherProperties()) {
                if (prop.getPropertyNumber() != propId) continue;
                return prop;
            }
        }
        return null;
    }

    public static void setEscherProperty(EscherOptRecord opt, short propId, int value) {
        List<EscherProperty> props = opt.getEscherProperties();
        Iterator<EscherProperty> iterator = props.iterator();
        while (iterator.hasNext()) {
            EscherProperty prop = iterator.next();
            if (prop.getId() != propId) continue;
            iterator.remove();
        }
        if (value != -1) {
            opt.addEscherProperty(new EscherSimpleProperty(propId, value));
            opt.sortProperties();
        }
    }

    public void setEscherProperty(short propId, int value) {
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this._escherContainer, -4085);
        Shape.setEscherProperty(opt, propId, value);
    }

    public int getEscherProperty(short propId) {
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)Shape.getEscherProperty(opt, propId);
        return prop == null ? 0 : prop.getPropertyValue();
    }

    public int getEscherProperty(short propId, int defaultValue) {
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this._escherContainer, -4085);
        EscherSimpleProperty prop = (EscherSimpleProperty)Shape.getEscherProperty(opt, propId);
        return prop == null ? defaultValue : prop.getPropertyValue();
    }

    public Float[] getAdjustmentValue() {
        return ShapeKit.getAdjustmentValue(this._escherContainer);
    }

    public int getStartArrowType() {
        EscherSimpleProperty prop;
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this._escherContainer, -4085);
        if (opt != null && (prop = (EscherSimpleProperty)Shape.getEscherProperty(opt, 464)) != null && prop.getPropertyValue() > 0) {
            return prop.getPropertyValue();
        }
        return 0;
    }

    public int getStartArrowWidth() {
        return ShapeKit.getStartArrowWidth(this._escherContainer);
    }

    public int getStartArrowLength() {
        return ShapeKit.getStartArrowLength(this._escherContainer);
    }

    public int getEndArrowType() {
        EscherSimpleProperty prop;
        EscherOptRecord opt = (EscherOptRecord)Shape.getEscherChild(this._escherContainer, -4085);
        if (opt != null && (prop = (EscherSimpleProperty)Shape.getEscherProperty(opt, 465)) != null && prop.getPropertyValue() > 0) {
            return prop.getPropertyValue();
        }
        return 0;
    }

    public int getEndArrowWidth() {
        return ShapeKit.getEndArrowWidth(this._escherContainer);
    }

    public int getEndArrowLength() {
        return ShapeKit.getEndArrowLength(this._escherContainer);
    }

    public boolean hasLine() {
        return ShapeKit.hasLine(this.getSpContainer());
    }

    public double getLineWidth() {
        return ShapeKit.getLineWidth(this.getSpContainer());
    }

    public Color getLineColor() {
        return ShapeKit.getLineColor(this.getSpContainer(), this.getSheet(), 2);
    }

    public Color getFillColor() {
        return this.getFill().getForegroundColor();
    }

    public boolean getFlipHorizontal() {
        return ShapeKit.getFlipHorizontal(this.getSpContainer());
    }

    public boolean getFlipVertical() {
        return ShapeKit.getFlipVertical(this.getSpContainer());
    }

    public int getRotation() {
        return ShapeKit.getRotation(this.getSpContainer());
    }

    public void dispose() {
        this._parent = null;
        this._sheet = null;
        if (this._escherContainer != null) {
            this._escherContainer.dispose();
            this._escherContainer = null;
        }
        if (this._fill != null) {
            this._fill.dispose();
            this._fill = null;
        }
    }

    protected abstract EscherContainerRecord createSpContainer(boolean var1);

    public String getShapeName() {
        return ShapeTypes.typeName(this.getShapeType());
    }

    public void setShapeType(int type) {
        EscherSpRecord spRecord = (EscherSpRecord)this._escherContainer.getChildById((short)-4086);
        spRecord.setOptions((short)(type << 4 | 2));
    }

    public Rectangle2D getLogicalAnchor2D() {
        return this.getAnchor2D();
    }

    public void setAnchor(Rectangle2D anchor) {
        EscherSpRecord spRecord = (EscherSpRecord)this._escherContainer.getChildById((short)-4086);
        int flags = spRecord.getFlags();
        if ((flags & 2) != 0) {
            EscherChildAnchorRecord rec = (EscherChildAnchorRecord)ShapeKit.getEscherChild(this._escherContainer, -4081);
            rec.setDx1((int)(anchor.getX() * 576.0 / 72.0));
            rec.setDy1((int)(anchor.getY() * 576.0 / 72.0));
            rec.setDx2((int)((anchor.getWidth() + anchor.getX()) * 576.0 / 72.0));
            rec.setDy2((int)((anchor.getHeight() + anchor.getY()) * 576.0 / 72.0));
        } else {
            EscherClientAnchorRecord rec = (EscherClientAnchorRecord)ShapeKit.getEscherChild(this._escherContainer, -4080);
            rec.setFlag((short)(anchor.getY() * 576.0 / 72.0));
            rec.setCol1((short)(anchor.getX() * 576.0 / 72.0));
            rec.setDx1((short)((anchor.getWidth() + anchor.getX()) * 576.0 / 72.0));
            rec.setRow1((short)((anchor.getHeight() + anchor.getY()) * 576.0 / 72.0));
        }
    }

    public void moveTo(float x, float y) {
        Rectangle2D anchor = this.getAnchor2D();
        anchor.setRect(x, y, anchor.getWidth(), anchor.getHeight());
        this.setAnchor(anchor);
    }

    protected void afterInsert(Sheet sh) {
    }

    public void setShapeId(int id2) {
        EscherSpRecord spRecord = (EscherSpRecord)this._escherContainer.getChildById((short)-4086);
        if (spRecord != null) {
            spRecord.setShapeId(id2);
        }
    }

    public com.ahmadullahpk.alldocumentreader.xs.java.awt.Shape getOutline() {
        return this.getLogicalAnchor2D();
    }
}

