/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model;

import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherContainerRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Picture;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.model.Shape;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.AnimationInfo;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.AnimationInfoAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExMCIMovie;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExObjList;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.ExVideoContainer;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.OEShapeAtom;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.Record;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.record.RecordTypes;
import com.ahmadullahpk.alldocumentreader.xs.fc.hslf.usermodel.SlideShow;

public final class MovieShape
extends Picture {
    public static final int DEFAULT_MOVIE_THUMBNAIL = -1;
    public static final int MOVIE_MPEG = 1;
    public static final int MOVIE_AVI = 2;

    public MovieShape(int movieIdx, int pictureIdx) {
        super(pictureIdx, null);
        this.setMovieIndex(movieIdx);
        this.setAutoPlay(true);
    }

    public MovieShape(int movieIdx, int idx, Shape parent) {
        super(idx, parent);
        this.setMovieIndex(movieIdx);
    }

    protected MovieShape(EscherContainerRecord escherRecord, Shape parent) {
        super(escherRecord, parent);
    }

    @Override
    protected EscherContainerRecord createSpContainer(int idx, boolean isChild) {
        this._escherContainer = super.createSpContainer(idx, isChild);
        return this._escherContainer;
    }

    public void setMovieIndex(int idx) {
        OEShapeAtom oe = (OEShapeAtom)this.getClientDataRecord(RecordTypes.OEShapeAtom.typeID);
        oe.setOptions(idx);
        AnimationInfo an = (AnimationInfo)this.getClientDataRecord(RecordTypes.AnimationInfo.typeID);
        if (an != null) {
            AnimationInfoAtom ai = an.getAnimationInfoAtom();
            ai.setDimColor(0x7000000);
            ai.setFlag(4, true);
            ai.setFlag(256, true);
            ai.setFlag(1024, true);
            ai.setOrderID(idx + 1);
        }
    }

    public void setAutoPlay(boolean flag) {
        AnimationInfo an = (AnimationInfo)this.getClientDataRecord(RecordTypes.AnimationInfo.typeID);
        if (an != null) {
            an.getAnimationInfoAtom().setFlag(4, flag);
            this.updateClientData();
        }
    }

    public boolean isAutoPlay() {
        AnimationInfo an = (AnimationInfo)this.getClientDataRecord(RecordTypes.AnimationInfo.typeID);
        if (an != null) {
            return an.getAnimationInfoAtom().getFlag(4);
        }
        return false;
    }

    public String getPath() {
        OEShapeAtom oe = (OEShapeAtom)this.getClientDataRecord(RecordTypes.OEShapeAtom.typeID);
        int idx = oe.getOptions();
        SlideShow ppt = this.getSheet().getSlideShow();
        ExObjList lst = (ExObjList)ppt.getDocumentRecord().findFirstOfType(RecordTypes.ExObjList.typeID);
        if (lst == null) {
            return null;
        }
        Record[] r = lst.getChildRecords();
        for (int i = 0; i < r.length; ++i) {
            ExMCIMovie mci;
            ExVideoContainer exVideo;
            int objectId;
            if (!(r[i] instanceof ExMCIMovie) || (objectId = (exVideo = (mci = (ExMCIMovie)r[i]).getExVideo()).getExMediaAtom().getObjectId()) != idx) continue;
            return exVideo.getPathAtom().getText();
        }
        return null;
    }
}

