/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hpsf;

import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.DocumentSummaryInformation;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.HPSFRuntimeException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.MarkUnsupportedException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.MutablePropertySet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.MutableSection;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.NoPropertySetStreamException;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.PropertySet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.SectionIDMap;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.SummaryInformation;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.UnexpectedPropertySetTypeException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class PropertySetFactory {
    public static PropertySet create(InputStream stream) throws NoPropertySetStreamException, MarkUnsupportedException, UnsupportedEncodingException, IOException {
        PropertySet ps = new PropertySet(stream);
        try {
            if (ps.isSummaryInformation()) {
                return new SummaryInformation(ps);
            }
            if (ps.isDocumentSummaryInformation()) {
                return new DocumentSummaryInformation(ps);
            }
            return ps;
        }
        catch (UnexpectedPropertySetTypeException ex) {
            throw new Error(ex.toString());
        }
    }

    public static SummaryInformation newSummaryInformation() {
        MutablePropertySet ps = new MutablePropertySet();
        MutableSection s = (MutableSection)ps.getFirstSection();
        s.setFormatID(SectionIDMap.SUMMARY_INFORMATION_ID);
        try {
            return new SummaryInformation((PropertySet)ps);
        }
        catch (UnexpectedPropertySetTypeException ex) {
            throw new HPSFRuntimeException(ex);
        }
    }

    public static DocumentSummaryInformation newDocumentSummaryInformation() {
        MutablePropertySet ps = new MutablePropertySet();
        MutableSection s = (MutableSection)ps.getFirstSection();
        s.setFormatID(SectionIDMap.DOCUMENT_SUMMARY_INFORMATION_ID[0]);
        try {
            return new DocumentSummaryInformation((PropertySet)ps);
        }
        catch (UnexpectedPropertySetTypeException ex) {
            throw new HPSFRuntimeException(ex);
        }
    }
}

