/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.hpsf;

import com.ahmadullahpk.alldocumentreader.xs.fc.POIDocument;
import com.ahmadullahpk.alldocumentreader.xs.fc.POITextExtractor;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.CustomProperties;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.DocumentSummaryInformation;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.Property;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.PropertyIDMap;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.SpecialPropertySet;
import com.ahmadullahpk.alldocumentreader.xs.fc.hpsf.SummaryInformation;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.NPOIFSFileSystem;
import com.ahmadullahpk.alldocumentreader.xs.fc.poifs.filesystem.POIFSFileSystem;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;

public class HPSFPropertiesExtractor
extends POITextExtractor {
    public HPSFPropertiesExtractor(POITextExtractor mainExtractor) {
        super(mainExtractor);
    }

    public HPSFPropertiesExtractor(POIDocument doc) {
        super(doc);
    }

    public HPSFPropertiesExtractor(POIFSFileSystem fs) {
        super(new PropertiesOnlyDocument(fs));
    }

    public HPSFPropertiesExtractor(NPOIFSFileSystem fs) {
        super(new PropertiesOnlyDocument(fs));
    }

    public String getDocumentSummaryInformationText() {
        CustomProperties cps;
        DocumentSummaryInformation dsi = this.document.getDocumentSummaryInformation();
        StringBuffer text = new StringBuffer();
        text.append(HPSFPropertiesExtractor.getPropertiesText(dsi));
        CustomProperties customProperties = cps = dsi == null ? null : dsi.getCustomProperties();
        if (cps != null) {
            for (String key : cps.nameSet()) {
                String val = HPSFPropertiesExtractor.getPropertyValueText(cps.get(key));
                text.append(key + " = " + val + "\n");
            }
        }
        return text.toString();
    }

    public String getSummaryInformationText() {
        SummaryInformation si = this.document.getSummaryInformation();
        return HPSFPropertiesExtractor.getPropertiesText(si);
    }

    private static String getPropertiesText(SpecialPropertySet ps) {
        if (ps == null) {
            return "";
        }
        StringBuffer text = new StringBuffer();
        PropertyIDMap idMap = ps.getPropertySetIDMap();
        Property[] props = ps.getProperties();
        for (int i = 0; i < props.length; ++i) {
            String type = Long.toString(props[i].getID());
            Object typeObj = idMap.get(props[i].getID());
            if (typeObj != null) {
                type = typeObj.toString();
            }
            String val = HPSFPropertiesExtractor.getPropertyValueText(props[i].getValue());
            text.append(type + " = " + val + "\n");
        }
        return text.toString();
    }

    private static String getPropertyValueText(Object val) {
        if (val == null) {
            return "(not set)";
        }
        if (val instanceof byte[]) {
            byte[] b = (byte[])val;
            if (b.length == 0) {
                return "";
            }
            if (b.length == 1) {
                return Byte.toString(b[0]);
            }
            if (b.length == 2) {
                return Integer.toString(LittleEndian.getUShort(b));
            }
            if (b.length == 4) {
                return Long.toString(LittleEndian.getUInt(b));
            }
            return new String(b);
        }
        return val.toString();
    }

    @Override
    public String getText() {
        return this.getSummaryInformationText() + this.getDocumentSummaryInformationText();
    }

    @Override
    public POITextExtractor getMetadataTextExtractor() {
        throw new IllegalStateException("You already have the Metadata Text Extractor, not recursing!");
    }

    public static void main(String[] args) throws IOException {
        for (String file : args) {
            HPSFPropertiesExtractor ext = new HPSFPropertiesExtractor(new NPOIFSFileSystem(new File(file)));
            System.out.println(ext.getText());
        }
    }

    private static final class PropertiesOnlyDocument
    extends POIDocument {
        public PropertiesOnlyDocument(NPOIFSFileSystem fs) {
            super(fs.getRoot());
        }

        public PropertiesOnlyDocument(POIFSFileSystem fs) {
            super(fs);
        }

        @Override
        public void write(OutputStream out) {
            throw new IllegalStateException("Unable to write, only for properties!");
        }
    }
}

