/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.fs.storage;

import com.ahmadullahpk.alldocumentreader.xs.fc.fs.filesystem.BlockSize;
import com.ahmadullahpk.alldocumentreader.xs.fc.fs.storage.BlockAllocationTableReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.fs.storage.RawDataBlock;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class BlockList {
    private RawDataBlock[] _blocks;
    private BlockAllocationTableReader _bat;

    public BlockList(InputStream stream, BlockSize bigBlockSize) throws IOException {
        byte[] b;
        int count;
        ArrayList<RawDataBlock> blocks = new ArrayList<RawDataBlock>();
        int size = bigBlockSize.getBigBlockSize();
        while ((count = stream.read(b = new byte[size])) > 0) {
            RawDataBlock block = new RawDataBlock(b);
            blocks.add(block);
            if (count == size) continue;
            break;
        }
        this._blocks = blocks.toArray(new RawDataBlock[blocks.size()]);
    }

    public BlockList(RawDataBlock[] _blocks) {
        this._blocks = _blocks;
    }

    public void zap(int index) {
        if (index >= 0 && index < this._blocks.length) {
            this._blocks[index] = null;
        }
    }

    protected RawDataBlock get(int index) {
        return this._blocks[index];
    }

    public RawDataBlock remove(int index) throws IOException {
        if (index < 0 || index >= this._blocks.length) {
            return null;
        }
        RawDataBlock result = this._blocks[index];
        this._blocks[index] = null;
        return result;
    }

    public RawDataBlock[] fetchBlocks(int startBlock, int headerPropertiesStartBlock) throws IOException {
        if (this._bat == null) {
            throw new IOException("Improperly initialized list: no block allocation table provided");
        }
        return this._bat.fetchBlocks(startBlock, headerPropertiesStartBlock, this);
    }

    public void setBAT(BlockAllocationTableReader bat) throws IOException {
        this._bat = bat;
    }

    public int blockCount() {
        return this._blocks.length;
    }
}

