/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.dom4j;

import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Attribute;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.CDATA;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Comment;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Document;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.DocumentType;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Entity;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.InvalidXPathException;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Namespace;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.NodeFilter;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.ProcessingInstruction;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.QName;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Text;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.XPath;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.rule.Pattern;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.tree.AbstractDocument;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.tree.DefaultAttribute;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.tree.DefaultCDATA;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.tree.DefaultComment;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.tree.DefaultDocument;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.tree.DefaultDocumentType;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.tree.DefaultElement;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.tree.DefaultEntity;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.tree.DefaultProcessingInstruction;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.tree.DefaultText;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.tree.QNameCache;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.util.SimpleSingleton;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.util.SingletonStrategy;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.xpath.DefaultXPath;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.xpath.XPathPattern;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.List;
import java.util.Map;

public class DocumentFactory
implements Serializable {
    private static SingletonStrategy singleton = null;
    protected transient QNameCache cache;
    private static String packageName = "com.ahmadullahpk.alldocumentreader";
    private Map xpathNamespaceURIs;

    private static SingletonStrategy createSingleton() {
        SingletonStrategy result;
        String documentFactoryClassName = "";
        String docDef1 = packageName + ".xs.fc.dom4j.factory";
        String docDef2 = packageName + ".xs.fc.dom4j.DocumentFactory";
        String keyOne = packageName + ".xs.fc.dom4j.DocumentFactory.singleton.strategy";
        String keyTwo = packageName + ".xs.fc.dom4j.util.SimpleSingleton";
        try {
            documentFactoryClassName = System.getProperty(docDef1, docDef2);
            System.out.println(docDef1);
            System.out.println(docDef2);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            String singletonClass = System.getProperty(keyOne, keyTwo);
            Class<?> clazz = Class.forName(singletonClass);
            result = (SingletonStrategy)clazz.newInstance();
        }
        catch (Exception e) {
            result = new SimpleSingleton();
        }
        result.setSingletonClassName(documentFactoryClassName);
        return result;
    }

    public DocumentFactory() {
        this.init();
    }

    public static synchronized DocumentFactory getInstance() {
        if (singleton == null) {
            singleton = DocumentFactory.createSingleton();
        }
        return (DocumentFactory)singleton.instance();
    }

    public Document createDocument() {
        DefaultDocument answer = new DefaultDocument();
        answer.setDocumentFactory(this);
        return answer;
    }

    public Document createDocument(String encoding) {
        Document answer = this.createDocument();
        if (answer instanceof AbstractDocument) {
            ((AbstractDocument)answer).setXMLEncoding(encoding);
        }
        return answer;
    }

    public Document createDocument(Element rootElement) {
        Document answer = this.createDocument();
        answer.setRootElement(rootElement);
        return answer;
    }

    public DocumentType createDocType(String name, String publicId, String systemId) {
        return new DefaultDocumentType(name, publicId, systemId);
    }

    public Element createElement(QName qname) {
        return new DefaultElement(qname);
    }

    public Element createElement(String name) {
        return this.createElement(this.createQName(name));
    }

    public Element createElement(String qualifiedName, String namespaceURI) {
        return this.createElement(this.createQName(qualifiedName, namespaceURI));
    }

    public Attribute createAttribute(Element owner, QName qname, String value) {
        return new DefaultAttribute(qname, value);
    }

    public Attribute createAttribute(Element owner, String name, String value) {
        return this.createAttribute(owner, this.createQName(name), value);
    }

    public CDATA createCDATA(String text) {
        return new DefaultCDATA(text);
    }

    public Comment createComment(String text) {
        return new DefaultComment(text);
    }

    public Text createText(String text) {
        if (text == null) {
            String msg = "Adding text to an XML document must not be null";
            throw new IllegalArgumentException(msg);
        }
        return new DefaultText(text);
    }

    public Entity createEntity(String name, String text) {
        return new DefaultEntity(name, text);
    }

    public Namespace createNamespace(String prefix, String uri) {
        return Namespace.get(prefix, uri);
    }

    public ProcessingInstruction createProcessingInstruction(String target, String data) {
        return new DefaultProcessingInstruction(target, data);
    }

    public ProcessingInstruction createProcessingInstruction(String target, Map data) {
        return new DefaultProcessingInstruction(target, data);
    }

    public QName createQName(String localName, Namespace namespace) {
        return this.cache.get(localName, namespace);
    }

    public QName createQName(String localName) {
        return this.cache.get(localName);
    }

    public QName createQName(String name, String prefix, String uri) {
        return this.cache.get(name, Namespace.get(prefix, uri));
    }

    public QName createQName(String qualifiedName, String uri) {
        return this.cache.get(qualifiedName, uri);
    }

    public XPath createXPath(String xpathExpression) throws InvalidXPathException {
        DefaultXPath xpath = new DefaultXPath(xpathExpression);
        if (this.xpathNamespaceURIs != null) {
            xpath.setNamespaceURIs(this.xpathNamespaceURIs);
        }
        return xpath;
    }

    public NodeFilter createXPathFilter(String xpathFilterExpression) {
        return this.createXPath(xpathFilterExpression);
    }

    public Pattern createPattern(String xpathPattern) {
        return new XPathPattern(xpathPattern);
    }

    public List getQNames() {
        return this.cache.getQNames();
    }

    public Map getXPathNamespaceURIs() {
        return this.xpathNamespaceURIs;
    }

    public void setXPathNamespaceURIs(Map namespaceURIs) {
        this.xpathNamespaceURIs = namespaceURIs;
    }

    protected static DocumentFactory createSingleton(String className) {
        try {
            Class<?> theClass = Class.forName(className, true, DocumentFactory.class.getClassLoader());
            return (DocumentFactory)theClass.newInstance();
        }
        catch (Throwable e) {
            System.out.println("WARNING: Cannot load DocumentFactory: " + className);
            return new DocumentFactory();
        }
    }

    protected QName intern(QName qname) {
        return this.cache.intern(qname);
    }

    protected QNameCache createQNameCache() {
        return new QNameCache(this);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.init();
    }

    protected void init() {
        this.cache = this.createQNameCache();
    }
}

