/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.doc;

import android.graphics.Color;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PointF;
import com.ahmadullahpk.alldocumentreader.xs.common.PaintKit;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.AutoShapeDataKit;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.ExtendPath;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.ArrowPathAndTail;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.LineArrowPathBuilder;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.BackgroundAndFill;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.Gradient;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.LinearGradientShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.PatternShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.RadialGradientShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.TileShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bookmark.Bookmark;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Border;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Borders;
import com.ahmadullahpk.alldocumentreader.xs.common.borders.Line;
import com.ahmadullahpk.alldocumentreader.xs.common.bulletnumber.ListData;
import com.ahmadullahpk.alldocumentreader.xs.common.bulletnumber.ListLevel;
import com.ahmadullahpk.alldocumentreader.xs.common.pictureefftect.PictureEffectInfo;
import com.ahmadullahpk.alldocumentreader.xs.common.pictureefftect.PictureEffectInfoFactory;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AbstractShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.GroupShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.IShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.PictureShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WPAbstractShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WPAutoShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WPChartShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WPGroupShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WPPictureShape;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.WatermarkShape;
import com.ahmadullahpk.alldocumentreader.xs.fc.FCKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.LineKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.doc.PathWithArrow;
import com.ahmadullahpk.alldocumentreader.xs.fc.doc.VMLPathParser;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Document;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.ElementHandler;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.ElementPath;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.io.SAXReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.exceptions.InvalidFormatException;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationship;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackage;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.ReaderKit;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.ThemeReader;
import com.ahmadullahpk.alldocumentreader.xs.fc.xls.Reader.drawing.ChartReader;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Rectangle;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.font.FontTypefaceManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.AttrManage;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IAttributeSet;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.IElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.LeafElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.ParagraphElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.SectionElement;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.Style;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.model.StyleManage;
import com.ahmadullahpk.alldocumentreader.xs.system.AbortReaderError;
import com.ahmadullahpk.alldocumentreader.xs.system.AbstractReader;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import com.ahmadullahpk.alldocumentreader.xs.thirdpart.achartengine.chart.AbstractChart;
import com.ahmadullahpk.alldocumentreader.xs.wp.model.CellElement;
import com.ahmadullahpk.alldocumentreader.xs.wp.model.HFElement;
import com.ahmadullahpk.alldocumentreader.xs.wp.model.RowElement;
import com.ahmadullahpk.alldocumentreader.xs.wp.model.TableElement;
import com.ahmadullahpk.alldocumentreader.xs.wp.model.WPDocument;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class DOCXReader
extends AbstractReader {
    private boolean isProcessSectionAttribute;
    private boolean isProcessHF;
    private boolean isProcessWatermark;
    private int styleID;
    private long offset;
    private long textboxIndex;
    private String filePath;
    private SectionElement secElem;
    private ZipPackage zipPackage;
    private WPDocument wpdoc;
    private PackagePart packagePart;
    private PackagePart hfPart;
    private Map<String, Integer> styleStrID = new HashMap<String, Integer>();
    private Map<String, Integer> tableStyle = new HashMap<String, Integer>();
    private Map<Integer, Integer> tableGridCol = new HashMap<Integer, Integer>();
    Hashtable<String, String> bulletNumbersID = new Hashtable();
    private Map<String, Integer> themeColor;
    private List<IShape> relativeType = new ArrayList<IShape>();
    private Map<IShape, int[]> relativeValue = new HashMap<IShape, int[]>();

    public DOCXReader(IControl control, String filePath) {
        this.control = control;
        this.filePath = filePath;
    }

    @Override
    public Object getModel() throws Exception {
        if (this.wpdoc != null) {
            return this.wpdoc;
        }
        this.wpdoc = new WPDocument();
        this.openFile();
        return this.wpdoc;
    }

    private void openFile() throws Exception {
        this.zipPackage = new ZipPackage(this.filePath);
        if (this.zipPackage.getParts().size() == 0) {
            throw new Exception("Format error");
        }
        PackageRelationship coreRel = this.zipPackage.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").getRelationship(0);
        if (!coreRel.getTargetURI().toString().equals("/word/document.xml")) {
            throw new Exception("Format error");
        }
        this.packagePart = this.zipPackage.getPart(coreRel);
        this.processThemeColor();
        this.processBulletNumber();
        this.processStyle();
        this.secElem = new SectionElement();
        this.offset = 0L;
        SAXReader saxreader = new SAXReader();
        DOCXSaxHandler docxHandler = new DOCXSaxHandler();
        saxreader.addHandler("/document/body/tbl", docxHandler);
        saxreader.addHandler("/document/body/p", docxHandler);
        saxreader.addHandler("/document/body/sdt", docxHandler);
        Document doc = saxreader.read(this.packagePart.getInputStream());
        Element br = doc.getRootElement().element("background");
        if (br != null) {
            BackgroundAndFill fill = null;
            if (br.element("background") != null) {
                fill = this.processBackgroundAndFill(br.element("background"));
            } else {
                String value = br.attributeValue("color");
                if (value != null) {
                    fill = new BackgroundAndFill();
                    fill.setForegroundColor(Color.parseColor((String)("#" + value)));
                }
            }
            this.wpdoc.setPageBackground(fill);
        }
        this.processSection(doc.getRootElement().element("body"));
        this.processRelativeShapeSize();
    }

    private void processStyle() throws Exception {
        PackagePart part;
        PackageRelationship styleRel = this.packagePart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/styles").getRelationship(0);
        if (styleRel != null && (part = this.zipPackage.getPart(styleRel.getTargetURI())) != null) {
            SAXReader saxreader = new SAXReader();
            InputStream in = part.getInputStream();
            Document doc = saxreader.read(in);
            Element root = doc.getRootElement();
            List styles = root.elements("style");
            Element docDefaults = root.element("docDefaults");
            if (docDefaults != null) {
                Element rPr;
                Style style2 = new Style();
                this.styleStrID.put("docDefaults", this.styleID);
                style2.setId(this.styleID);
                ++this.styleID;
                style2.setType((byte)0);
                style2.setName("docDefaults");
                Element pPr = docDefaults.element("pPrDefault");
                if (pPr != null && (pPr = pPr.element("pPr")) != null) {
                    this.processParaAttribute(pPr, style2.getAttrbuteSet(), 0);
                }
                if ((rPr = docDefaults.element("rPrDefault")) != null && (rPr = rPr.element("rPr")) != null) {
                    this.processRunAttribute(rPr, style2.getAttrbuteSet());
                }
                StyleManage.instance().addStyle(style2);
            }
            for (Element styleEle : styles) {
                String val;
                Element shd;
                Element tcPr;
                Element tlb;
                if (this.abortReader) break;
                if ("table".equals(styleEle.attributeValue("type")) && (tlb = styleEle.element("tblStylePr")) != null && "firstRow".equals(tlb.attributeValue("type")) && (tcPr = tlb.element("tcPr")) != null && (shd = tcPr.element("shd")) != null && (val = shd.attributeValue("fill")) != null) {
                    this.tableStyle.put(styleEle.attributeValue("styleId"), Color.parseColor((String)("#" + val)));
                }
                Style style3 = new Style();
                String val2 = styleEle.attributeValue("styleId");
                if (val2 != null) {
                    Integer a = this.styleStrID.get(val2);
                    if (a == null) {
                        this.styleStrID.put(val2, this.styleID);
                        style3.setId(this.styleID);
                        ++this.styleID;
                    } else {
                        style3.setId(a);
                    }
                }
                style3.setType((byte)(!(val2 = styleEle.attributeValue("type")).equals("paragraph") ? 1 : 0));
                Element temp = styleEle.element("name");
                if (temp != null) {
                    style3.setName(temp.attributeValue("val"));
                }
                if ((temp = styleEle.element("basedOn")) != null) {
                    val2 = temp.attributeValue("val");
                    if (val2 != null) {
                        Integer a = this.styleStrID.get(val2);
                        if (a == null) {
                            this.styleStrID.put(val2, this.styleID);
                            style3.setBaseID(this.styleID);
                            ++this.styleID;
                        } else {
                            style3.setBaseID(a);
                        }
                    }
                } else if ("1".equals(styleEle.attributeValue("default"))) {
                    style3.setBaseID(0);
                }
                if ((temp = styleEle.element("pPr")) != null) {
                    this.processParaAttribute(temp, style3.getAttrbuteSet(), 0);
                }
                if ((temp = styleEle.element("rPr")) != null) {
                    this.processRunAttribute(temp, style3.getAttrbuteSet());
                }
                StyleManage.instance().addStyle(style3);
            }
            in.close();
        }
    }

    private void processBulletNumber() throws Exception {
        PackagePart part;
        PackageRelationship styleRel = this.packagePart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/numbering").getRelationship(0);
        if (styleRel != null && (part = this.zipPackage.getPart(styleRel.getTargetURI())) != null) {
            SAXReader saxreader = new SAXReader();
            InputStream in = part.getInputStream();
            Document doc = saxreader.read(in);
            Element root = doc.getRootElement();
            List nums = root.elements("num");
            for (Element num : nums) {
                Element temp = num.element("abstractNumId");
                if (temp == null) continue;
                String val = temp.attributeValue("val");
                String numID = num.attributeValue("numId");
                this.bulletNumbersID.put(numID, val);
            }
            nums = root.elements("abstractNum");
            for (Element num : nums) {
                Integer a;
                String styleID;
                Element styleLink;
                ListData listData = new ListData();
                String abstractNumId = num.attributeValue("abstractNumId");
                if (abstractNumId != null) {
                    listData.setListID(Integer.parseInt(abstractNumId));
                }
                List levels = num.elements("lvl");
                int len = levels.size();
                ListLevel[] listLevels = new ListLevel[len];
                listData.setSimpleList((byte)len);
                for (int i = 0; i < len; ++i) {
                    listLevels[i] = new ListLevel();
                    this.processListLevel(listLevels[i], (Element)levels.get(i));
                }
                listData.setLevels(listLevels);
                listData.setSimpleList((byte)len);
                if (len == 0 && (styleLink = num.element("numStyleLink")) != null && (styleID = styleLink.attributeValue("val")) != null && (a = this.styleStrID.get(styleID)) != null) {
                    listData.setLinkStyleID(a.shortValue());
                    Style style2 = StyleManage.instance().getStyle(a);
                    int styleListNumID = AttrManage.instance().getParaListID(style2.getAttrbuteSet());
                    if (styleListNumID >= 0) {
                        styleListNumID = Integer.parseInt(this.bulletNumbersID.get(String.valueOf(styleListNumID)));
                        AttrManage.instance().setParaListID(style2.getAttrbuteSet(), styleListNumID);
                    }
                }
                this.control.getSysKit().getListManage().putListData(listData.getListID(), listData);
            }
            in.close();
        }
    }

    private void processListLevel(ListLevel level, Element elem) {
        String val;
        Element temp = elem.element("start");
        if (temp != null) {
            level.setStartAt(Integer.parseInt(temp.attributeValue("val")));
        }
        if ((temp = elem.element("lvlJc")) != null) {
            val = temp.attributeValue("val");
            if ("left".equals(val)) {
                level.setAlign((byte)0);
            } else if ("center".equals(val)) {
                level.setAlign((byte)1);
            } else if ("right".equals(val)) {
                level.setAlign((byte)2);
            }
        }
        if ((temp = elem.element("suff")) != null) {
            val = temp.attributeValue("val");
            if ("space".equals(val)) {
                level.setFollowChar((byte)1);
            } else if ("nothing".equals(val)) {
                level.setFollowChar((byte)2);
            }
        }
        if ((temp = elem.element("numFmt")) != null) {
            level.setNumberFormat(this.convertedNumberFormat(temp.attributeValue("val")));
        }
        if ((temp = elem.element("lvlText")) != null) {
            StringBuilder sb = new StringBuilder();
            val = temp.attributeValue("val");
            for (int i = 0; i < val.length(); ++i) {
                int c = val.charAt(i);
                if (c == 37) {
                    int a = Integer.parseInt(val.substring(i + 1, i + 2));
                    sb.append((char)(a - 1));
                    ++i;
                    continue;
                }
                if (c == 61548) {
                    c = 9679;
                } else if (c == 61550) {
                    c = 9632;
                } else if (c == 61557) {
                    c = 9670;
                } else if (c == 61692) {
                    c = 8730;
                } else if (c == 61656) {
                    c = 9733;
                } else if (c == 61618) {
                    c = 9734;
                } else if (c >= 61440) {
                    c = 9679;
                }
                sb.append((char)c);
            }
            char[] c = new char[sb.length()];
            sb.getChars(0, sb.length(), c, 0);
            level.setNumberText(c);
        }
        if ((temp = elem.element("pPr")) != null && (temp = temp.element("ind")) != null) {
            val = temp.attributeValue("hanging");
            if (val != null) {
                level.setSpecialIndent(-Integer.parseInt(val));
            }
            if ((val = temp.attributeValue("left")) != null) {
                level.setTextIndent(Integer.parseInt(val));
            }
        }
    }

    private int convertedNumberFormat(String numFormat) {
        if ("decimal".equalsIgnoreCase(numFormat)) {
            return 0;
        }
        if ("upperRoman".equalsIgnoreCase(numFormat)) {
            return 1;
        }
        if ("lowerRoman".equalsIgnoreCase(numFormat)) {
            return 2;
        }
        if ("upperLetter".equalsIgnoreCase(numFormat)) {
            return 3;
        }
        if ("lowerLetter".equalsIgnoreCase(numFormat)) {
            return 4;
        }
        if ("chineseCountingThousand".equalsIgnoreCase(numFormat)) {
            return 39;
        }
        if ("chineseLegalSimplified".equalsIgnoreCase(numFormat)) {
            return 38;
        }
        if ("ideographTraditional".equalsIgnoreCase(numFormat)) {
            return 30;
        }
        if ("ideographZodiac".equalsIgnoreCase(numFormat)) {
            return 31;
        }
        if ("ordinal".equalsIgnoreCase(numFormat)) {
            return 5;
        }
        if ("cardinalText".equalsIgnoreCase(numFormat)) {
            return 6;
        }
        if ("ordinalText".equalsIgnoreCase(numFormat)) {
            return 7;
        }
        if ("decimalZero".equalsIgnoreCase(numFormat)) {
            return 22;
        }
        return 0;
    }

    private void processHeaderAndFooter(PackageRelationship hfRel, boolean isHeader) throws Exception {
        if (hfRel != null) {
            this.hfPart = this.zipPackage.getPart(hfRel.getTargetURI());
            if (this.hfPart != null) {
                this.isProcessHF = true;
                this.offset = isHeader ? 0x1000000000000000L : 0x2000000000000000L;
                SAXReader saxreader = new SAXReader();
                InputStream in = this.hfPart.getInputStream();
                Document doc = saxreader.read(in);
                Element root = doc.getRootElement();
                List paras = root.elements();
                HFElement hfElem = new HFElement(isHeader ? (short)5 : 6, 1);
                hfElem.setStartOffset(this.offset);
                this.processParagraphs(paras);
                hfElem.setEndOffset(this.offset);
                this.wpdoc.appendElement(hfElem, this.offset);
                in.close();
                this.isProcessHF = false;
            }
        }
    }

    private void processSection(Element body) throws Exception {
        this.secElem.setStartOffset(0L);
        this.secElem.setEndOffset(this.offset);
        this.wpdoc.appendSection(this.secElem);
        this.processSectionAttribute(body.element("sectPr"));
    }

    private void processSectionAttribute(Element sectPr) {
        List footers;
        String linePitch;
        String type;
        Element docGrid;
        Element borderElem;
        Element margin;
        if (sectPr == null || this.isProcessSectionAttribute) {
            return;
        }
        IAttributeSet attr = this.secElem.getAttribute();
        Element pgSz = sectPr.element("pgSz");
        if (pgSz != null) {
            AttrManage.instance().setPageWidth(attr, Integer.parseInt(pgSz.attributeValue("w")));
            AttrManage.instance().setPageHeight(attr, Integer.parseInt(pgSz.attributeValue("h")));
        }
        if ((margin = sectPr.element("pgMar")) != null) {
            AttrManage.instance().setPageMarginLeft(attr, Integer.parseInt(margin.attributeValue("left")));
            AttrManage.instance().setPageMarginRight(attr, Integer.parseInt(margin.attributeValue("right")));
            AttrManage.instance().setPageMarginTop(attr, Integer.parseInt(margin.attributeValue("top")));
            AttrManage.instance().setPageMarginBottom(attr, Integer.parseInt(margin.attributeValue("bottom")));
            if (margin.attributeValue("header") != null) {
                AttrManage.instance().setPageHeaderMargin(attr, Integer.parseInt(margin.attributeValue("header")));
            }
            if (margin.attributeValue("footer") != null) {
                AttrManage.instance().setPageFooterMargin(attr, Integer.parseInt(margin.attributeValue("footer")));
            }
        }
        if ((borderElem = sectPr.element("pgBorders")) != null) {
            Border border;
            Element bElem;
            Borders borders = new Borders();
            if ("page".equals(borderElem.attributeValue("offsetFrom"))) {
                borders.setOnType((byte)1);
            }
            if ((bElem = borderElem.element("top")) != null) {
                border = new Border();
                this.processBorder(bElem, border);
                borders.setTopBorder(border);
            }
            if ((bElem = borderElem.element("left")) != null) {
                border = new Border();
                this.processBorder(bElem, border);
                borders.setLeftBorder(border);
            }
            if ((bElem = borderElem.element("right")) != null) {
                border = new Border();
                this.processBorder(bElem, border);
                borders.setRightBorder(border);
            }
            if ((bElem = borderElem.element("bottom")) != null) {
                border = new Border();
                this.processBorder(bElem, border);
                borders.setBottomBorder(border);
            }
            AttrManage.instance().setPageBorder(attr, this.control.getSysKit().getBordersManage().addBorders(borders));
        }
        if ((docGrid = sectPr.element("docGrid")) != null && ("lines".equals(type = docGrid.attributeValue("type")) || "linesAndChars".equals(type) || "snapToChars".equals(type)) && (linePitch = docGrid.attributeValue("linePitch")) != null && linePitch.length() > 0) {
            AttrManage.instance().setPageLinePitch(attr, Integer.parseInt(linePitch));
            int i = 0;
            while ((long)i < this.textboxIndex) {
                IElement textboxSec = this.wpdoc.getTextboxSectionElementForIndex(i);
                IAttributeSet secElemAttr = this.secElem.getAttribute();
                AttrManage.instance().setPageLinePitch(textboxSec.getAttribute(), AttrManage.instance().getPageLinePitch(secElemAttr));
                ++i;
            }
        }
        long a = this.offset;
        List headers = sectPr.elements("headerReference");
        if (headers != null && headers.size() > 0) {
            String id2 = "";
            if (headers.size() == 1) {
                id2 = ((Element)headers.get(0)).attributeValue("id");
            } else {
                for (Object header : headers) {
                    if (!"default".equals(header.attributeValue("type"))) continue;
                    id2 = header.attributeValue("id");
                    break;
                }
            }
            if (id2 != null && id2.length() > 0) {
                try {
                    PackageRelationship hfRel = this.packagePart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/header").getRelationshipByID(id2);
                    if (hfRel != null) {
                        this.processHeaderAndFooter(hfRel, true);
                    }
                }
                catch (Exception e) {
                    this.control.getSysKit().getErrorKit().writerLog(e, true);
                }
            }
        }
        if ((footers = sectPr.elements("footerReference")) != null && footers.size() > 0) {
            String id3 = "";
            if (footers.size() == 1) {
                id3 = ((Element)footers.get(0)).attributeValue("id");
            } else {
                for (Element footer : footers) {
                    if (!"default".equals(footer.attributeValue("type"))) continue;
                    id3 = footer.attributeValue("id");
                    break;
                }
            }
            if (id3 != null && id3.length() > 0) {
                try {
                    PackageRelationship hfRel = this.packagePart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/footer").getRelationshipByID(id3);
                    if (hfRel != null) {
                        this.processHeaderAndFooter(hfRel, false);
                    }
                }
                catch (Exception e) {
                    this.control.getSysKit().getErrorKit().writerLog(e, true);
                }
            }
        }
        this.offset = a;
        this.isProcessSectionAttribute = true;
    }

    private void processBorder(Element borElem, Border border) {
        String value = borElem.attributeValue("color");
        if (value == null || "auto".equals(value)) {
            border.setColor(-16777216);
        } else {
            border.setColor(Color.parseColor((String)("#" + value)));
        }
        value = borElem.attributeValue("space");
        if (value == null) {
            border.setSpace((short)32);
        } else {
            border.setSpace((short)((float)Integer.parseInt(value) * 1.3333334f));
        }
    }

    private void processTable(Element table) {
        List grids;
        Element tblGrid;
        TableElement tableElem = new TableElement();
        tableElem.setStartOffset(this.offset);
        Element trPr = table.element("tblPr");
        String tableStyleId = "";
        if (trPr != null) {
            this.processTableAttribute(trPr, tableElem.getAttribute());
            Element tStyleId = trPr.element("tblStyle");
            if (tStyleId != null && (tableStyleId = tStyleId.attributeValue("val")) == null) {
                tableStyleId = "";
            }
        }
        if ((tblGrid = table.element("tblGrid")) != null && (grids = tblGrid.elements("gridCol")) != null) {
            for (int i = 0; i < grids.size(); ++i) {
                this.tableGridCol.put(i, Integer.parseInt(((Element)grids.get(i)).attributeValue("w")));
            }
        }
        List rows = table.elements("tr");
        boolean firstRow = true;
        for (Element row : rows) {
            this.processRow(row, tableElem, firstRow, tableStyleId);
            firstRow = false;
        }
        tableElem.setEndOffset(this.offset);
        this.wpdoc.appendParagraph(tableElem, this.offset);
    }

    private void processTableAttribute(Element tblPr, IAttributeSet attr) {
        String val;
        Element temp = tblPr.element("jc");
        if (temp != null) {
            val = temp.attributeValue("val");
            if ("center".equals(val)) {
                AttrManage.instance().setParaHorizontalAlign(attr, 1);
            } else if ("right".equals(val)) {
                AttrManage.instance().setParaHorizontalAlign(attr, 2);
            }
        }
        if ((temp = tblPr.element("tblInd")) != null && (val = temp.attributeValue("w")) != null) {
            AttrManage.instance().setParaIndentLeft(attr, Integer.parseInt(val));
        }
    }

    private void processRow(Element row, TableElement tableElem, boolean firstRow, String tableStyleId) {
        RowElement rowElem = new RowElement();
        rowElem.setStartOffset(this.offset);
        Element trPr = row.element("trPr");
        if (trPr != null) {
            this.processRowAttribute(trPr, rowElem.getAttribute());
        }
        List cells = row.elements("tc");
        int i = 0;
        for (Element cell : cells) {
            i += this.processCell(cell, rowElem, i, firstRow, tableStyleId);
        }
        rowElem.setEndOffset(this.offset);
        tableElem.appendRow(rowElem);
    }

    private void processRowAttribute(Element trPr, IAttributeSet attr) {
        Element temp = trPr.element("trHeight");
        if (temp != null) {
            AttrManage.instance().setTableRowHeight(attr, Integer.parseInt(temp.attributeValue("val")));
        }
    }

    private int processCell(Element cell, RowElement row, int gridColIndex, boolean firstRow, String tableStyleId) {
        CellElement cellElem = new CellElement();
        cellElem.setStartOffset(this.offset);
        int gridSpan = 0;
        Element tcPr = cell.element("tcPr");
        if (tcPr != null) {
            gridSpan = this.processCellAttribute(tcPr, cellElem.getAttribute(), gridColIndex);
        }
        this.processParagraphs_Table(cell.elements(), 1);
        cellElem.setEndOffset(this.offset);
        row.appendCell(cellElem);
        if (firstRow && this.tableStyle.containsKey(tableStyleId)) {
            AttrManage.instance().setTableCellBackground(cellElem.getAttribute(), this.tableStyle.get(tableStyleId));
        }
        if (gridSpan > 0) {
            for (int i = 1; i < gridSpan; ++i) {
                row.appendCell(new CellElement());
            }
        }
        return gridSpan;
    }

    private int processCellAttribute(Element tcPr, IAttributeSet attr, int gridColIndex) {
        int gridSpan = 1;
        Element temp = tcPr.element("gridSpan");
        if (temp != null) {
            gridSpan = Integer.parseInt(temp.attributeValue("val"));
        }
        if ((temp = tcPr.element("tcW")) != null) {
            int w = Integer.parseInt(temp.attributeValue("w"));
            String type = temp.attributeValue("type");
            if ("pct".equals(type) || "auto".equals(type)) {
                int tW = 0;
                for (int i = gridColIndex; i < gridColIndex + gridSpan; ++i) {
                    tW += this.tableGridCol.get(i).intValue();
                }
                w = Math.max(tW, w);
            }
            AttrManage.instance().setTableCellWidth(attr, w);
        } else {
            int tW = 0;
            for (int i = gridColIndex; i < gridColIndex + gridSpan; ++i) {
                tW += this.tableGridCol.get(i).intValue();
            }
            AttrManage.instance().setTableCellWidth(attr, tW);
        }
        temp = tcPr.element("vMerge");
        if (temp != null) {
            AttrManage.instance().setTableVerMerged(attr, true);
            if (temp.attributeValue("val") != null) {
                AttrManage.instance().setTableVerFirstMerged(attr, true);
            }
        }
        if ((temp = tcPr.element("vAlign")) != null) {
            String val = temp.attributeValue("val");
            if ("center".equals(val)) {
                AttrManage.instance().setTableCellVerAlign(attr, 1);
            } else if ("bottom".equals(val)) {
                AttrManage.instance().setTableCellVerAlign(attr, 2);
            }
        }
        return gridSpan;
    }

    private void processParagraphs_Table(List<Element> elems, int level) {
        for (Element elem : elems) {
            if ("sdt".equals(elem.getName()) && (elem = elem.element("sdtContent")) != null) {
                this.processParagraphs_Table(elem.elements(), level);
            }
            if ("p".equals(elem.getName())) {
                this.processParagraph(elem, level);
                continue;
            }
            if (!"tbl".equals(elem.getName())) continue;
            this.processEmbeddedTable(elem, level);
        }
    }

    private void processEmbeddedTable(Element table, int level) {
        List rows = table.elements("tr");
        for (Element row : rows) {
            List cells = row.elements("tc");
            for (Element cell : cells) {
                this.processParagraphs_Table(cell.elements(), level);
            }
        }
    }

    private void processParagraph(Element para, int level) {
        ParagraphElement paraElem = new ParagraphElement();
        long t = this.offset;
        paraElem.setStartOffset(this.offset);
        this.processParaAttribute(para.element("pPr"), paraElem.getAttribute(), level);
        this.processRun(para, paraElem, true);
        paraElem.setEndOffset(this.offset);
        if (this.offset > t) {
            this.wpdoc.appendParagraph(paraElem, this.offset);
        }
    }

    private void processParaAttribute(Element pPr, IAttributeSet attr, int level) {
        List tabs;
        String val;
        String val2;
        if (level > 0) {
            AttrManage.instance().setParaLevel(attr, level);
        }
        if (pPr == null) {
            return;
        }
        Element temp = pPr.element("pStyle");
        if (temp != null) {
            val2 = temp.attributeValue("val");
            if (val2 != null && val2.length() > 0) {
                AttrManage.instance().setParaStyleID(attr, this.styleStrID.get(val2));
            }
        } else {
            AttrManage.instance().setParaStyleID(attr, 0);
        }
        temp = pPr.element("spacing");
        if (temp != null) {
            val2 = temp.attributeValue("line");
            if (val2 != null) {
                int lineUnit = Integer.parseInt(val2);
                lineUnit = lineUnit == 0 ? 240 : lineUnit;
                val2 = temp.attributeValue("beforeLines");
                if (val2 != null && val2.length() > 0) {
                    AttrManage.instance().setParaBefore(attr, (int)((float)Integer.parseInt(val2) / 100.0f * (float)lineUnit));
                }
                if (val2 == null && (val2 = temp.attributeValue("before")) != null && val2.length() > 0) {
                    AttrManage.instance().setParaBefore(attr, Integer.parseInt(val2));
                }
                if ((val2 = temp.attributeValue("afterLines")) != null && val2.length() > 0) {
                    AttrManage.instance().setParaAfter(attr, (int)((float)Integer.parseInt(val2) / 100.0f * (float)lineUnit));
                }
                if (val2 == null && (val2 = temp.attributeValue("after")) != null && val2.length() > 0) {
                    AttrManage.instance().setParaAfter(attr, Integer.parseInt(val2));
                }
            } else {
                val2 = temp.attributeValue("before");
                if (val2 != null && val2.length() > 0) {
                    AttrManage.instance().setParaBefore(attr, Integer.parseInt(val2));
                } else {
                    val2 = temp.attributeValue("beforeLines");
                    if (val2 != null && val2.length() > 0) {
                        AttrManage.instance().setParaBefore(attr, (int)((float)Integer.parseInt(val2) / 100.0f * 240.0f));
                    }
                }
                val2 = temp.attributeValue("after");
                if (val2 != null && val2.length() > 0) {
                    AttrManage.instance().setParaAfter(attr, Integer.parseInt(val2));
                } else {
                    val2 = temp.attributeValue("afterLines");
                    if (val2 != null && val2.length() > 0) {
                        AttrManage.instance().setParaAfter(attr, (int)((float)Integer.parseInt(val2) / 100.0f * 240.0f));
                    }
                }
            }
            val2 = temp.attributeValue("lineRule");
            float lineSpace = 0.0f;
            if (temp.attributeValue("line") != null) {
                lineSpace = Float.parseFloat(temp.attributeValue("line"));
            }
            if ("auto".equals(val2)) {
                AttrManage.instance().setParaLineSpaceType(attr, 5);
                if (lineSpace != 0.0f) {
                    AttrManage.instance().setParaLineSpace(attr, lineSpace / 240.0f);
                }
            } else if ("atLeast".equals(val2)) {
                AttrManage.instance().setParaLineSpaceType(attr, 3);
                if (lineSpace != 0.0f) {
                    AttrManage.instance().setParaLineSpace(attr, lineSpace);
                }
            } else if ("exact".equals(val2)) {
                AttrManage.instance().setParaLineSpaceType(attr, 4);
                if (lineSpace != 0.0f) {
                    AttrManage.instance().setParaLineSpace(attr, -lineSpace);
                }
            } else {
                AttrManage.instance().setParaLineSpaceType(attr, 5);
                if (lineSpace != 0.0f) {
                    AttrManage.instance().setParaLineSpace(attr, -lineSpace / 240.0f);
                }
            }
        }
        if ((temp = pPr.element("ind")) != null) {
            IAttributeSet defaultAttr;
            int left = 0;
            int fontSize = 12;
            Style style2 = StyleManage.instance().getStyle(this.styleStrID.get("docDefaults"));
            if (style2 != null && (defaultAttr = style2.getAttrbuteSet()) != null) {
                fontSize = AttrManage.instance().getFontSize(defaultAttr, defaultAttr);
            }
            if ((val = temp.attributeValue("leftChars")) != null && val.length() > 0 && !val.equals("0")) {
                float leftChars = (float)Integer.parseInt(val) / 100.0f;
                AttrManage.instance().setParaIndentLeft(attr, Math.round((float)fontSize * leftChars * 20.0f));
            } else {
                val = temp.attributeValue("left");
                if (val != null && val != null && val.length() > 0) {
                    left = Integer.parseInt(val);
                    AttrManage.instance().setParaIndentLeft(attr, left);
                }
            }
            val = temp.attributeValue("rightChars");
            if (val != null && val.length() > 0 && !val.equals("0")) {
                float rightChars = (float)Integer.parseInt(val) / 100.0f;
                AttrManage.instance().setParaIndentRight(attr, Math.round((float)fontSize * rightChars * 20.0f));
            } else {
                val = temp.attributeValue("right");
                if (val != null && val != null && val.length() > 0) {
                    AttrManage.instance().setParaIndentRight(attr, Integer.parseInt(val));
                }
            }
            val = temp.attributeValue("firstLineChars");
            if (val != null && val.length() > 0 && !val.equals("0")) {
                float firstLineChars = (float)Integer.parseInt(val) / 100.0f;
                AttrManage.instance().setParaSpecialIndent(attr, Math.round((float)fontSize * firstLineChars * 20.0f));
            } else {
                val = temp.attributeValue("firstLine");
                if (val != null && val != null && val.length() > 0) {
                    AttrManage.instance().setParaSpecialIndent(attr, Integer.parseInt(val));
                }
            }
            val = temp.attributeValue("hangingChars");
            if (val != null && val.length() > 0 && !val.equals("0")) {
                float hangingChars = (float)Integer.parseInt(val) / 100.0f;
                int hanging = -Math.round((float)fontSize * hangingChars * 20.0f);
                AttrManage.instance().setParaSpecialIndent(attr, hanging);
                if (left == 0) {
                    left = AttrManage.instance().getParaIndentLeft(attr);
                }
                if (hanging < 0) {
                    AttrManage.instance().setParaIndentLeft(attr, left + hanging);
                }
            } else {
                val = temp.attributeValue("hanging");
                if (val != null && val != null && val.length() > 0) {
                    int sp = -Integer.parseInt(val);
                    AttrManage.instance().setParaSpecialIndent(attr, sp);
                    if (sp < 0) {
                        AttrManage.instance().setParaIndentLeft(attr, left + sp);
                    }
                }
            }
        }
        if ((temp = pPr.element("jc")) != null) {
            String value = temp.attributeValue("val");
            if ("left".equals(value) || "both".equals(value) || "distribute".equals(value)) {
                AttrManage.instance().setParaHorizontalAlign(attr, 0);
            } else if ("center".equals(value)) {
                AttrManage.instance().setParaHorizontalAlign(attr, 1);
            } else if ("right".equals(value)) {
                AttrManage.instance().setParaHorizontalAlign(attr, 2);
            }
        }
        if ((temp = pPr.element("numPr")) != null) {
            String bnID;
            String val3;
            Element t = temp.element("ilvl");
            if (t != null) {
                AttrManage.instance().setParaListLevel(attr, Integer.parseInt(t.attributeValue("val")));
            }
            if ((t = temp.element("numId")) != null && (val3 = t.attributeValue("val")) != null && (bnID = this.bulletNumbersID.get(val3)) != null) {
                AttrManage.instance().setParaListID(attr, Integer.parseInt(bnID));
            }
        } else {
            Style style3 = StyleManage.instance().getStyle(AttrManage.instance().getParaStyleID(attr));
            if (style3 != null) {
                int paraListLevel = AttrManage.instance().getParaListLevel(style3.getAttrbuteSet());
                int paraListID = AttrManage.instance().getParaListID(style3.getAttrbuteSet());
                if (paraListID > -1) {
                    if (paraListLevel < 0) {
                        paraListLevel = 0;
                    }
                    AttrManage.instance().setParaListID(attr, paraListID);
                }
                if (paraListLevel > -1) {
                    AttrManage.instance().setParaListLevel(attr, paraListLevel);
                }
            }
        }
        temp = pPr.element("tabs");
        if (temp != null && (tabs = temp.elements("tab")) != null) {
            for (Element tab : tabs) {
                if (!"clear".equals(tab.attributeValue("val")) || (val = tab.attributeValue("pos")) == null || val.length() <= 0) continue;
                AttrManage.instance().setParaTabsClearPostion(attr, Integer.parseInt(val));
            }
        }
        if (!this.isProcessSectionAttribute) {
            this.processSectionAttribute(pPr.element("sectPr"));
        }
    }

    private boolean processRun(Element para, ParagraphElement paraElem, boolean addBreakPage) {
        return this.processRun(para, paraElem, (byte)-1, addBreakPage);
    }

    private boolean processRun(Element para, ParagraphElement paraElem, byte pgNumberType, boolean addBreakPage) {
        List runs = para.elements();
        LeafElement leaf = null;
        boolean hasLeaf = false;
        String fieldCodeStr = "";
        String fieldTextStr = "";
        boolean hasField = false;
        boolean pageBreak = false;
        for (Element run : runs) {
            int hyIndex;
            int index;
            int len;
            String name = run.getName();
            if ("smartTag".equals(name)) {
                hasLeaf = this.processRun(run, paraElem, false);
                continue;
            }
            if ("hyperlink".equals(name)) {
                leaf = this.processHyperlinkRun(run, paraElem);
                hasLeaf = leaf != null;
                continue;
            }
            if ("bookmarkStart".equals(name)) {
                String val = run.attributeValue("name");
                if (val == null) continue;
                this.control.getSysKit().getBookmarkManage().addBookmark(new Bookmark(val, this.offset, this.offset));
                continue;
            }
            if ("fldSimple".equals(name)) {
                String instr = run.attributeValue("instr");
                byte pageNumberType = -1;
                if (instr != null) {
                    if (instr.contains("NUMPAGES")) {
                        pageNumberType = 2;
                    } else if (instr.contains("PAGE")) {
                        pageNumberType = 1;
                    }
                }
                hasLeaf = this.processRun(run, paraElem, pageNumberType, false);
                leaf = null;
                continue;
            }
            if ("sdt".equals(name)) {
                String docPartGallery;
                Element sdtContent = run.element("sdtContent");
                if (sdtContent == null) continue;
                Element ele = null;
                ele = run.element("sdtPr");
                if (ele != null && (ele = ele.element("docPartObj")) != null && (ele = ele.element("docPartGallery")) != null && (docPartGallery = ele.attributeValue("val")) != null) {
                    if (this.isProcessHF && docPartGallery.contains("Margins")) {
                        return false;
                    }
                    if (docPartGallery.contains("Watermarks")) {
                        this.isProcessWatermark = true;
                    }
                }
                hasLeaf = this.processRun(sdtContent, paraElem, false);
                leaf = null;
                continue;
            }
            if ("ins".equals(name)) {
                hasLeaf = this.processRun(run, paraElem, false);
                continue;
            }
            if (!"r".equals(name)) continue;
            Element fld = run.element("fldChar");
            if (fld != null) {
                String fldType = fld.attributeValue("fldCharType");
                if ("begin".equals(fldType)) {
                    hasField = true;
                    continue;
                }
                if ("separate".equals(fldType)) continue;
                if ("end".equals(fldType)) {
                    hasField = false;
                    if (fieldCodeStr == null) continue;
                    String str = "";
                    int encloseType = -1;
                    int pageNumberType = -1;
                    if (fieldCodeStr.indexOf(9675) > 0) {
                        str = fieldCodeStr.substring(fieldCodeStr.indexOf(",") + 1, fieldCodeStr.length() - 1);
                        encloseType = 0;
                    } else if (fieldCodeStr.indexOf(9633) > 0) {
                        str = fieldCodeStr.substring(fieldCodeStr.indexOf(",") + 1, fieldCodeStr.length() - 1);
                        encloseType = 1;
                    } else if (fieldCodeStr.indexOf(9651) > 0) {
                        str = fieldCodeStr.substring(fieldCodeStr.indexOf(",") + 1, fieldCodeStr.length() - 1);
                        encloseType = 2;
                    } else if (fieldCodeStr.indexOf(9671) > 0) {
                        str = fieldCodeStr.substring(fieldCodeStr.indexOf(",") + 1, fieldCodeStr.length() - 1);
                        encloseType = 3;
                    } else if (fieldCodeStr.contains("NUMPAGES")) {
                        str = fieldTextStr;
                        pageNumberType = 2;
                    } else if (fieldCodeStr.contains("PAGE")) {
                        str = fieldTextStr;
                        pageNumberType = 1;
                    } else {
                        str = fieldTextStr;
                    }
                    if (str.length() > 0) {
                        hasLeaf = true;
                        leaf = new LeafElement(str);
                        Element rPr = run.element("rPr");
                        if (rPr != null) {
                            this.processRunAttribute(rPr, leaf.getAttribute());
                        }
                        leaf.setStartOffset(this.offset);
                        this.offset += (long)str.length();
                        leaf.setEndOffset(this.offset);
                        if (encloseType >= 0) {
                            AttrManage.instance().setEncloseChanacterType(leaf.getAttribute(), encloseType);
                        } else if (this.isProcessHF && this.hfPart != null && pageNumberType > 0) {
                            AttrManage.instance().setFontPageNumberType(leaf.getAttribute(), pageNumberType);
                        }
                        paraElem.appendLeaf(leaf);
                    }
                    fieldCodeStr = "";
                    fieldTextStr = "";
                    continue;
                }
            }
            if (hasField) {
                Element fldCode = run.element("instrText");
                if (fldCode != null) {
                    fieldCodeStr = fieldCodeStr + fldCode.getText();
                    continue;
                }
                Element text = run.element("t");
                if (text == null) continue;
                fieldTextStr = fieldTextStr + text.getText();
                continue;
            }
            Element object = run.element("object");
            if (object != null) {
                Iterator it = object.elementIterator();
                while (it.hasNext()) {
                    this.processAutoShapeForPict((Element)it.next(), paraElem, null, 1.0f, 1.0f);
                }
                leaf = null;
                continue;
            }
            Element drawing = run.element("drawing");
            if (drawing != null) {
                this.processPictureAndDiagram(drawing, paraElem);
                leaf = null;
                continue;
            }
            Element pict = run.element("pict");
            if (pict != null) {
                Iterator it = pict.elementIterator();
                while (it.hasNext()) {
                    this.processAutoShapeForPict((Element)it.next(), paraElem, null, 1.0f, 1.0f);
                }
                leaf = null;
                continue;
            }
            Element alternateContent = run.element("AlternateContent");
            if (alternateContent != null) {
                this.processAlternateContent(alternateContent, paraElem);
                leaf = null;
                continue;
            }
            Element ruby = run.element("ruby");
            if (ruby != null && (ruby = ruby.element("rubyBase")) != null && (run = ruby.element("r")) == null) continue;
            String str = "";
            Element br = run.element("br");
            Element text = run.element("t");
            if (text != null) {
                str = text.getText();
                if (br != null) {
                    str = String.valueOf('\u000b') + str;
                }
            } else if (br != null) {
                if ("page".equals(br.attributeValue("type"))) {
                    pageBreak = true;
                    str = String.valueOf('\f');
                } else {
                    str = String.valueOf('\u000b');
                }
            }
            if ((len = str.length()) <= 0) continue;
            hasLeaf = true;
            leaf = new LeafElement(str);
            Element rPr = run.element("rPr");
            if (rPr != null) {
                this.processRunAttribute(rPr, leaf.getAttribute());
            }
            if (this.isProcessHF && this.hfPart != null && pgNumberType > 0) {
                AttrManage.instance().setFontPageNumberType(leaf.getAttribute(), pgNumberType);
            }
            leaf.setStartOffset(this.offset);
            this.offset += (long)len;
            leaf.setEndOffset(this.offset);
            paraElem.appendLeaf(leaf);
            if (fieldCodeStr == null) continue;
            String linkURL = null;
            if (fieldCodeStr.indexOf("mailto") >= 0) {
                linkURL = fieldCodeStr.substring(fieldCodeStr.indexOf("mailto"));
                index = linkURL.indexOf("\"");
                if (index > 0) {
                    linkURL = linkURL.substring(0, index);
                }
            } else if (fieldCodeStr.indexOf("HYPERLINK") >= 0 && (index = (linkURL = fieldCodeStr.substring(fieldCodeStr.indexOf("\"") + 1)).lastIndexOf("/")) > 0) {
                linkURL = linkURL.substring(0, index);
            }
            if (linkURL != null && (hyIndex = this.control.getSysKit().getHyperlinkManage().addHyperlink(linkURL, 1)) >= 0) {
                AttrManage.instance().setFontColor(leaf.getAttribute(), -16776961);
                AttrManage.instance().setFontUnderline(leaf.getAttribute(), 1);
                AttrManage.instance().setFontUnderlineColr(leaf.getAttribute(), -16776961);
                AttrManage.instance().setHyperlinkID(leaf.getAttribute(), hyIndex);
            }
            fieldCodeStr = "";
            fieldTextStr = "";
        }
        if (!hasLeaf) {
            leaf = new LeafElement("\n");
            Element ele = para.element("pPr");
            if (ele != null) {
                ele = ele.element("rPr");
            }
            if (ele != null) {
                this.processRunAttribute(ele, leaf.getAttribute());
            }
            leaf.setStartOffset(this.offset);
            ++this.offset;
            leaf.setEndOffset(this.offset);
            paraElem.appendLeaf(leaf);
            return hasLeaf;
        }
        if (addBreakPage && leaf != null && !pageBreak) {
            leaf.setText(leaf.getText(this.wpdoc) + "\n");
            ++this.offset;
        }
        return hasLeaf;
    }

    private LeafElement processHyperlinkRun(Element hyperlink, ParagraphElement paraElem) {
        String anchor;
        PackageRelationship hyRel = null;
        try {
            String id2 = hyperlink.attributeValue("id");
            if (id2 != null) {
                hyRel = this.packagePart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/hyperlink").getRelationshipByID(id2);
            }
        }
        catch (InvalidFormatException e) {
            this.control.getSysKit().getErrorKit().writerLog(e, true);
        }
        int hyIndex = -1;
        if (hyRel != null) {
            hyIndex = this.control.getSysKit().getHyperlinkManage().addHyperlink(hyRel.getTargetURI().toString(), 1);
        }
        if (hyIndex == -1 && (anchor = hyperlink.attributeValue("anchor")) != null) {
            hyIndex = this.control.getSysKit().getHyperlinkManage().addHyperlink(anchor, 5);
        }
        List runs = hyperlink.elements("r");
        LeafElement leaf = null;
        for (Element run : runs) {
            Element ruby;
            String text;
            Element fldCode = run.element("instrText");
            if (fldCode != null && (text = fldCode.getText()) != null && text.contains("PAGEREF")) {
                hyIndex = -1;
            }
            if ((ruby = run.element("ruby")) != null && (ruby = ruby.element("rubyBase")) != null && (run = ruby.element("r")) == null) continue;
            Element text2 = run.element("t");
            if (text2 == null) {
                Element drawing = run.element("drawing");
                if (drawing == null) continue;
                this.processPictureAndDiagram(drawing, paraElem);
                leaf = null;
                continue;
            }
            String str = text2.getText();
            int len = str.length();
            if (len <= 0) continue;
            leaf = new LeafElement(str);
            IAttributeSet attr = leaf.getAttribute();
            Element rPr = run.element("rPr");
            if (rPr != null) {
                this.processRunAttribute(rPr, attr);
            }
            leaf.setStartOffset(this.offset);
            this.offset += (long)len;
            leaf.setEndOffset(this.offset);
            paraElem.appendLeaf(leaf);
            if (hyIndex < 0) continue;
            AttrManage.instance().setFontColor(attr, -16776961);
            AttrManage.instance().setFontUnderline(attr, 1);
            AttrManage.instance().setFontUnderlineColr(attr, -16776961);
            AttrManage.instance().setHyperlinkID(attr, hyIndex);
        }
        return leaf;
    }

    private void addShape(AbstractShape shape, ParagraphElement paraElem) {
        if (shape != null && paraElem != null) {
            LeafElement leaf = new LeafElement(String.valueOf(1));
            leaf.setStartOffset(this.offset);
            ++this.offset;
            leaf.setEndOffset(this.offset);
            paraElem.appendLeaf(leaf);
            AttrManage.instance().setShapeID(leaf.getAttribute(), this.control.getSysKit().getWPShapeManage().addShape(shape));
        }
    }

    private PictureShape addPicture(Element pic, Rectangle rect) {
        Element blipFill;
        PictureShape shape = null;
        if (pic != null && rect != null && (blipFill = pic.element("blipFill")) != null) {
            String embed;
            PictureEffectInfo effectInfor = PictureEffectInfoFactory.getPictureEffectInfor(blipFill);
            Element blip = blipFill.element("blip");
            if (blip != null && (embed = blip.attributeValue("embed")) != null) {
                PackagePart picPart = null;
                picPart = this.isProcessHF && this.hfPart != null ? this.zipPackage.getPart(this.hfPart.getRelationship(embed).getTargetURI()) : this.zipPackage.getPart(this.packagePart.getRelationship(embed).getTargetURI());
                if (picPart != null) {
                    shape = new PictureShape();
                    try {
                        shape.setPictureIndex(this.control.getSysKit().getPictureManage().addPicture(picPart));
                    }
                    catch (Exception e) {
                        this.control.getSysKit().getErrorKit().writerLog(e);
                    }
                    shape.setZoomX((short)1000);
                    shape.setZoomY((short)1000);
                    shape.setPictureEffectInfor(effectInfor);
                    shape.setBounds(rect);
                }
            }
        }
        return shape;
    }

    private byte getRelative(String relativeFrom) {
        if ("margin".equalsIgnoreCase(relativeFrom)) {
            return 1;
        }
        if ("page".equalsIgnoreCase(relativeFrom)) {
            return 2;
        }
        if ("column".equalsIgnoreCase(relativeFrom)) {
            return 0;
        }
        if ("character".equalsIgnoreCase(relativeFrom)) {
            return 3;
        }
        if ("leftMargin".equalsIgnoreCase(relativeFrom)) {
            return 4;
        }
        if ("rightMargin".equalsIgnoreCase(relativeFrom)) {
            return 5;
        }
        if ("insideMargin".equalsIgnoreCase(relativeFrom)) {
            return 8;
        }
        if ("outsideMargin".equalsIgnoreCase(relativeFrom)) {
            return 9;
        }
        if ("paragraph".equalsIgnoreCase(relativeFrom)) {
            return 10;
        }
        if ("line".equalsIgnoreCase(relativeFrom)) {
            return 11;
        }
        if ("topMargin".equalsIgnoreCase(relativeFrom)) {
            return 6;
        }
        if ("bottomMargin".equalsIgnoreCase(relativeFrom)) {
            return 7;
        }
        return 0;
    }

    private byte getAlign(String align) {
        if ("left".equalsIgnoreCase(align)) {
            return 1;
        }
        if ("right".equalsIgnoreCase(align)) {
            return 3;
        }
        if ("top".equalsIgnoreCase(align)) {
            return 4;
        }
        if ("bottom".equalsIgnoreCase(align)) {
            return 5;
        }
        if ("center".equalsIgnoreCase(align)) {
            return 2;
        }
        if ("inside".equalsIgnoreCase(align)) {
            return 6;
        }
        if ("outside".equalsIgnoreCase(align)) {
            return 7;
        }
        return 0;
    }

    private void processWrapAndPosition_Drawing(WPAbstractShape shape, Element anchor, Rectangle rect) {
        String behindDoc = anchor.attributeValue("behindDoc");
        if ("1".equalsIgnoreCase(behindDoc)) {
            shape.setWrap((short)6);
        }
        shape.setWrap(this.getDrawingWrapType(anchor));
        Element positionHElement = null;
        Element positionVElement = null;
        List alternateContents = anchor.elements("AlternateContent");
        for (Element item : alternateContents) {
            Element choice = item.element("Choice");
            if (choice == null) continue;
            if (choice.element("positionH") != null) {
                positionHElement = choice.element("positionH");
            }
            if (choice.element("positionV") == null) continue;
            positionVElement = choice.element("positionV");
        }
        if (positionHElement == null) {
            positionHElement = anchor.element("positionH");
        }
        if (positionHElement != null) {
            shape.setHorizontalRelativeTo(this.getRelative(positionHElement.attributeValue("relativeFrom")));
            if (positionHElement.element("align") != null) {
                shape.setHorizontalAlignment(this.getAlign(positionHElement.element("align").getText()));
            } else if (positionHElement.element("posOffset") != null) {
                rect.translate(Math.round((float)Integer.parseInt(positionHElement.element("posOffset").getText()) * 96.0f / 914400.0f), 0);
            } else if (positionHElement.element("pctPosHOffset") != null) {
                shape.setHorRelativeValue(Integer.parseInt(positionHElement.element("pctPosHOffset").getText()) / 100);
                shape.setHorPositionType((byte)1);
            }
        }
        if (positionVElement == null) {
            positionVElement = anchor.element("positionV");
        }
        if (positionVElement != null) {
            shape.setVerticalRelativeTo(this.getRelative(positionVElement.attributeValue("relativeFrom")));
            if (positionVElement.element("align") != null) {
                shape.setVerticalAlignment(this.getAlign(positionVElement.element("align").getText()));
            } else if (positionVElement.element("posOffset") != null) {
                rect.translate(0, Math.round((float)Integer.parseInt(positionVElement.element("posOffset").getText()) * 96.0f / 914400.0f));
            } else if (positionVElement.element("pctPosVOffset") != null) {
                shape.setVerRelativeValue(Integer.parseInt(positionVElement.element("pctPosVOffset").getText()) / 100);
                shape.setVerPositionType((byte)1);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processPictureAndDiagram(Element drawing, ParagraphElement paraElem) {
        String val;
        Element dgm;
        Element graphicdata;
        Element graphic;
        Element inline = drawing.element("inline");
        boolean isInline = true;
        if (inline == null) {
            isInline = false;
            inline = drawing.element("anchor");
        }
        if (inline == null || (graphic = inline.element("graphic")) == null || (graphicdata = graphic.element("graphicData")) == null) return;
        Element pic = graphicdata.element("pic");
        if (pic != null) {
            PictureShape shape;
            String embed;
            Element blipFill;
            Element blip;
            Element spPr = pic.element("spPr");
            if (spPr == null) return;
            Object fill = null;
            PackagePart picPart = null;
            if (spPr.element("blipFill") != null && (blip = (blipFill = spPr.element("blipFill")).element("blip")) != null && (embed = blip.attributeValue("embed")) != null) {
                picPart = this.isProcessHF && this.hfPart != null ? this.hfPart : this.packagePart;
            }
            if ((shape = this.addPicture(pic, ReaderKit.instance().getShapeAnchor(spPr.element("xfrm"), 1.0f, 1.0f))) == null) return;
            AutoShapeDataKit.processPictureShape(this.control, this.zipPackage, picPart, spPr, this.themeColor, shape);
            WPPictureShape wpPictureShape = new WPPictureShape();
            wpPictureShape.setPictureShape(shape);
            wpPictureShape.setBounds(shape.getBounds());
            if (!isInline) {
                this.processWrapAndPosition_Drawing(wpPictureShape, inline, shape.getBounds());
            } else {
                wpPictureShape.setWrap((short)2);
            }
            this.addShape(wpPictureShape, paraElem);
            return;
        }
        if (graphicdata.element("chart") != null) {
            String id2;
            PackageRelationship ship;
            Element chartEle = graphicdata.element("chart");
            if (chartEle == null || chartEle.attribute("id") == null || (ship = this.packagePart.getRelationship(id2 = chartEle.attributeValue("id"))) == null) return;
            PackagePart chartPart = this.zipPackage.getPart(ship.getTargetURI());
            try {
                Element extent;
                AbstractChart abstrChart = ChartReader.instance().read(this.control, this.zipPackage, chartPart, this.themeColor, (byte)0);
                if (abstrChart == null) return;
                Rectangle bounds = new Rectangle();
                Element simplePos = inline.element("simplePos");
                if (simplePos != null) {
                    String y;
                    String x = simplePos.attributeValue("x");
                    if (x != null) {
                        bounds.x = (int)((float)Integer.parseInt(x) * 96.0f / 914400.0f);
                    }
                    if ((y = simplePos.attributeValue("y")) != null) {
                        bounds.y = (int)((float)Integer.parseInt(y) * 96.0f / 914400.0f);
                    }
                }
                if ((extent = inline.element("extent")) != null) {
                    String cy;
                    String cx = extent.attributeValue("cx");
                    if (cx != null) {
                        bounds.width = (int)((float)Integer.parseInt(cx) * 96.0f / 914400.0f);
                    }
                    if ((cy = extent.attributeValue("cy")) != null) {
                        bounds.height = (int)((float)Integer.parseInt(cy) * 96.0f / 914400.0f);
                    }
                }
                WPChartShape shape = new WPChartShape();
                shape.setAChart(abstrChart);
                shape.setBounds(bounds);
                if (!isInline) {
                    this.processWrapAndPosition_Drawing(shape, inline, bounds);
                } else {
                    shape.setWrap((short)2);
                }
                this.addShape(shape, paraElem);
                return;
            }
            catch (Exception e) {
                return;
            }
        }
        if (graphicdata.element("relIds") == null || (dgm = graphicdata.element("relIds")) == null || (val = dgm.attributeValue("dm")) == null) return;
        try {
            PackageRelationship diagramRel = this.packagePart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/diagramData").getRelationshipByID(val);
            if (diagramRel == null) return;
            Rectangle rect = new Rectangle();
            Element extent = inline.element("extent");
            if (extent != null) {
                if (extent.attribute("cx") != null && (val = extent.attributeValue("cx")) != null && val.length() > 0) {
                    rect.width = (int)((float)Integer.parseInt(val) * 96.0f / 914400.0f);
                }
                if (extent.attribute("cy") != null && (val = extent.attributeValue("cy")) != null && val.length() > 0) {
                    rect.height = (int)((float)Integer.parseInt(val) * 96.0f / 914400.0f);
                }
            }
            PackagePart dataPart = this.zipPackage.getPart(diagramRel.getTargetURI());
            this.processSmart(this.control, this.zipPackage, dataPart, paraElem, inline, rect, isInline);
            return;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void processSmart(IControl control, ZipPackage zipPackage, PackagePart dataPart, ParagraphElement paraElem, Element anchor, Rectangle rect, boolean isInline) throws Exception {
        InputStream in;
        if (dataPart != null && (in = dataPart.getInputStream()) != null) {
            Element spTree;
            String relId;
            SAXReader saxreader = new SAXReader();
            Document dataDoc = saxreader.read(in);
            in.close();
            Element root = dataDoc.getRootElement();
            BackgroundAndFill fill = AutoShapeDataKit.processBackground(control, zipPackage, dataPart, root.element("bg"), this.themeColor);
            Line line = LineKit.createLine(control, zipPackage, dataPart, root.element("whole").element("ln"), this.themeColor);
            PackagePart drawingPart = null;
            Element e = null;
            e = root.element("extLst");
            if (e != null && (e = e.element("ext")) != null && (e = e.element("dataModelExt")) != null && (relId = e.attributeValue("relId")) != null) {
                PackageRelationship smartArDrawingRel = this.packagePart.getRelationship(relId);
                drawingPart = zipPackage.getPart(smartArDrawingRel.getTargetURI());
            }
            if (drawingPart == null) {
                return;
            }
            in = drawingPart.getInputStream();
            Document drawingDoc = saxreader.read(in);
            in.close();
            if (drawingDoc != null && (root = drawingDoc.getRootElement()) != null && (spTree = root.element("spTree")) != null) {
                WPGroupShape groupShape = new WPGroupShape();
                WPAutoShape autoShape = new WPAutoShape();
                autoShape.addGroupShape(groupShape);
                short wrapType = 2;
                if (!isInline) {
                    this.processWrapAndPosition_Drawing(autoShape, anchor, rect);
                    wrapType = this.getDrawingWrapType(anchor);
                }
                groupShape.setBounds(rect);
                autoShape.setBackgroundAndFill(fill);
                autoShape.setLine(line);
                autoShape.setShapeType(1);
                if (wrapType != 2) {
                    groupShape.setWrapType(wrapType);
                    autoShape.setWrap(wrapType);
                } else {
                    groupShape.setWrapType((short)2);
                    autoShape.setWrap((short)2);
                }
                autoShape.setBounds(rect);
                Iterator it = spTree.elementIterator();
                while (it.hasNext()) {
                    this.processAutoShape2010(drawingPart, paraElem, (Element)it.next(), groupShape, 1.0f, 1.0f, 0, 0, false);
                }
                this.addShape(autoShape, paraElem);
            }
        }
    }

    private void processAutoShapeForPict(Element sp, ParagraphElement paraElem, WPGroupShape parent, float zoomX, float zoomY) {
        String name = sp.getName();
        if ("group".equalsIgnoreCase(name)) {
            String val = sp.attributeValue("id");
            if (val != null && (val.startsWith("Genko") || val.startsWith("Header") || val.startsWith("Footer"))) {
                return;
            }
            Rectangle rect = null;
            AbstractShape shape = null;
            WPGroupShape groupShape = new WPGroupShape();
            if (parent == null) {
                shape = new WPAutoShape();
                ((WPAutoShape)shape).addGroupShape(groupShape);
            } else {
                shape = groupShape;
            }
            rect = this.processAutoShapeStyle(sp, shape, parent, zoomX, zoomY);
            if (rect != null) {
                IShape[] shapes;
                String[] values;
                String temp;
                float x = 0.0f;
                float y = 0.0f;
                float w = 0.0f;
                float h = 0.0f;
                float[] zoom = new float[]{1.0f, 1.0f};
                Rectangle childRect = new Rectangle();
                if (sp.attribute("coordorigin") != null && (temp = sp.attributeValue("coordorigin")) != null && temp.length() > 0 && (values = temp.split(",")) != null) {
                    if (values.length == 2) {
                        if (values[0].length() > 0) {
                            x = Float.parseFloat(values[0]);
                        }
                        y = Float.parseFloat(values[1]);
                    } else if (values.length == 1) {
                        x = Float.parseFloat(values[0]);
                    }
                }
                if (sp.attribute("coordsize") != null && (temp = sp.attributeValue("coordsize")) != null && temp.length() > 0 && (values = temp.split(",")) != null) {
                    if (values.length == 2) {
                        if (values[0].length() > 0) {
                            w = Float.parseFloat(values[0]);
                        }
                        h = Float.parseFloat(values[1]);
                    } else if (values.length == 1) {
                        w = Float.parseFloat(values[0]);
                    }
                }
                if (w != 0.0f && h != 0.0f) {
                    zoom[0] = (float)(rect.width * 914400) / 96.0f / zoomX / w;
                    zoom[1] = (float)(rect.height * 914400) / 96.0f / zoomY / h;
                }
                rect = this.processGrpSpRect(parent, rect);
                childRect.x = (int)(x * zoom[0] * zoomX * 96.0f / 914400.0f);
                childRect.y = (int)(y * zoom[1] * zoomY * 96.0f / 914400.0f);
                childRect.width = (int)(w * zoom[0] * zoomX * 96.0f / 914400.0f);
                childRect.height = (int)(h * zoom[1] * zoomY * 96.0f / 914400.0f);
                if (parent == null) {
                    childRect.x += rect.x;
                    childRect.y += rect.y;
                }
                groupShape.setOffPostion(rect.x - childRect.x, rect.y - childRect.y);
                groupShape.setBounds(rect);
                groupShape.setParent(parent);
                groupShape.setRotation(shape.getRotation());
                groupShape.setFlipHorizontal(shape.getFlipHorizontal());
                groupShape.setFlipVertical(shape.getFlipVertical());
                if (parent == null) {
                    short wrapType = this.getShapeWrapType(sp);
                    groupShape.setWrapType(wrapType);
                    ((WPAutoShape)shape).setWrap(wrapType);
                } else {
                    groupShape.setWrapType(parent.getWrapType());
                }
                Iterator it = sp.elementIterator();
                while (it.hasNext()) {
                    this.processAutoShapeForPict((Element)it.next(), paraElem, groupShape, zoom[0] * zoomX, zoom[1] * zoomY);
                }
                for (IShape sh : shapes = groupShape.getShapes()) {
                    if (!(sh instanceof WPAbstractShape) || !(shape instanceof WPAbstractShape)) continue;
                    ((WPAbstractShape)sh).setWrap((short)((WPAbstractShape)shape).getWrap());
                    ((WPAbstractShape)sh).setHorPositionType(((WPAbstractShape)shape).getHorPositionType());
                    ((WPAbstractShape)sh).setHorizontalRelativeTo(((WPAbstractShape)shape).getHorizontalRelativeTo());
                    ((WPAbstractShape)sh).setHorRelativeValue(((WPAbstractShape)shape).getHorRelativeValue());
                    ((WPAbstractShape)sh).setHorizontalAlignment(((WPAbstractShape)shape).getHorizontalAlignment());
                    ((WPAbstractShape)sh).setVerPositionType(((WPAbstractShape)shape).getVerPositionType());
                    ((WPAbstractShape)sh).setVerticalRelativeTo(((WPAbstractShape)shape).getVerticalRelativeTo());
                    ((WPAbstractShape)sh).setVerRelativeValue(((WPAbstractShape)shape).getVerRelativeValue());
                    ((WPAbstractShape)sh).setVerticalAlignment(((WPAbstractShape)shape).getVerticalAlignment());
                }
                if (parent == null) {
                    this.addShape(shape, paraElem);
                } else {
                    parent.appendShapes(shape);
                }
            } else {
                shape.dispose();
                shape = null;
            }
        } else {
            WPAutoShape shape;
            String val = sp.attributeValue("id");
            if (val != null && (val.startsWith("Genko") || val.startsWith("Header") || val.startsWith("Footer"))) {
                return;
            }
            if ("shape".equalsIgnoreCase(name)) {
                if (sp.element("imagedata") != null) {
                    this.processPicture(sp, paraElem);
                } else {
                    WPAutoShape shape2 = this.processAutoShape(sp, paraElem, parent, zoomX, zoomY, this.hasTextbox2007(sp));
                    if (shape2 != null) {
                        this.processTextbox2007(this.packagePart, shape2, sp);
                    }
                }
            } else if (("line".equalsIgnoreCase(name) || "polyline".equalsIgnoreCase(name) || "curve".equalsIgnoreCase(name) || "rect".equalsIgnoreCase(name) || "roundrect".equalsIgnoreCase(name) || "oval".equalsIgnoreCase(name)) && (shape = this.processAutoShape(sp, paraElem, parent, zoomX, zoomY, this.hasTextbox2007(sp))) != null) {
                this.processTextbox2007(this.packagePart, shape, sp);
            }
        }
    }

    private short getShapeWrapType(Element sp) {
        String style2;
        Element wrap = sp.element("wrap");
        if (wrap != null) {
            String type = wrap.attributeValue("type");
            if ("none".equalsIgnoreCase(type)) {
                return 2;
            }
            if ("square".equalsIgnoreCase(type)) {
                return 1;
            }
            if ("tight".equalsIgnoreCase(type)) {
                return 0;
            }
            if ("topAndBottom".equalsIgnoreCase(type)) {
                return 5;
            }
            if ("through".equalsIgnoreCase(type)) {
                return 4;
            }
        }
        if ((style2 = sp.attributeValue("style")) != null) {
            String[] styles = style2.split(";");
            for (int i = styles.length - 1; i >= 0; --i) {
                if (!styles[i].contains("z-index:")) continue;
                int zIndex = Integer.parseInt(styles[i].replace("z-index:", ""));
                if (zIndex > 0) {
                    return 3;
                }
                return 6;
            }
        }
        return -1;
    }

    private short getDrawingWrapType(Element anchor) {
        if (anchor != null) {
            if (anchor.element("wrapNone") != null) {
                String behindDoc = anchor.attributeValue("behindDoc");
                if ("1".equalsIgnoreCase(behindDoc)) {
                    return 6;
                }
                return 3;
            }
            if (anchor.element("wrapSquare") != null) {
                return 1;
            }
            if (anchor.element("wrapTight") != null) {
                return 0;
            }
            if (anchor.element("wrapThrough") != null) {
                return 4;
            }
            if (anchor.element("wrapTopAndBottom") != null) {
                return 5;
            }
            return 2;
        }
        return -1;
    }

    private void processPicture(Element shape, ParagraphElement paraElem) {
        boolean isPictureControl = false;
        if (shape != null) {
            String id2;
            Element imagedata = shape.element("imagedata");
            if (imagedata == null && (imagedata = shape.element("rect")) != null) {
                isPictureControl = true;
                shape = imagedata;
                imagedata = imagedata.element("fill");
            }
            if (imagedata != null && (id2 = imagedata.attributeValue("id")) != null) {
                PackagePart picPart = null;
                picPart = this.isProcessHF && this.hfPart != null ? this.zipPackage.getPart(this.hfPart.getRelationship(id2).getTargetURI()) : this.zipPackage.getPart(this.packagePart.getRelationship(id2).getTargetURI());
                String style2 = shape.attributeValue("style");
                if (picPart != null && style2 != null) {
                    String s = shape.attributeValue("id");
                    if (s != null && s.indexOf("PictureWatermark") > 0) {
                        this.isProcessWatermark = true;
                    }
                    try {
                        int pictureIndex = this.control.getSysKit().getPictureManage().addPicture(picPart);
                        short wrapType = this.getShapeWrapType(shape);
                        WPAutoShape abstractShape = null;
                        if (this.isProcessWatermark) {
                            String gain;
                            abstractShape = new WatermarkShape();
                            String blacklevel = imagedata.attributeValue("blacklevel");
                            if (blacklevel != null) {
                                ((WatermarkShape)abstractShape).setBlacklevel(Float.parseFloat(blacklevel) / 100000.0f);
                            }
                            if ((gain = imagedata.attributeValue("gain")) != null) {
                                ((WatermarkShape)abstractShape).setGain(Float.parseFloat(gain) / 100000.0f);
                            }
                            ((WatermarkShape)abstractShape).setWatermarkType((byte)1);
                            ((WatermarkShape)abstractShape).setPictureIndex(pictureIndex);
                            abstractShape.setWrap(wrapType);
                        } else {
                            PictureEffectInfo effectInfor = PictureEffectInfoFactory.getPictureEffectInfor_ImageData(imagedata);
                            PictureShape pictureShape = new PictureShape();
                            pictureShape.setPictureIndex(pictureIndex);
                            pictureShape.setZoomX((short)1000);
                            pictureShape.setZoomY((short)1000);
                            pictureShape.setPictureEffectInfor(effectInfor);
                            abstractShape = new WPPictureShape();
                            ((WPPictureShape)abstractShape).setPictureShape(pictureShape);
                            ((WPPictureShape)abstractShape).setWrap(wrapType);
                        }
                        Rectangle rect = this.processAutoShapeStyle(shape, abstractShape, null, 1000.0f, 1000.0f);
                        if (!this.isProcessWatermark) {
                            PictureShape picShape = ((WPPictureShape)abstractShape).getPictureShape();
                            picShape.setBounds(rect);
                            picShape.setBackgroundAndFill(this.processBackgroundAndFill(shape));
                            picShape.setLine(this.processLine(shape));
                        }
                        this.addShape(abstractShape, paraElem);
                        this.isProcessWatermark = false;
                    }
                    catch (Exception e) {
                        this.control.getSysKit().getErrorKit().writerLog(e);
                    }
                }
            }
        }
    }

    private int getColor(String value, boolean filled) {
        char firstChar;
        if (value == null) {
            if (filled) {
                return -1;
            }
            return -16777216;
        }
        int index = value.indexOf(" ");
        if (index > 0) {
            value = value.substring(0, index);
        }
        if ((firstChar = value.charAt(0)) == '#') {
            if (value.length() > 6) {
                return Color.parseColor((String)value);
            }
            if (value.length() == 4) {
                StringBuilder builder = new StringBuilder();
                builder.append('#');
                for (int i = 1; i < 4; ++i) {
                    builder.append(value.charAt(i));
                    builder.append(value.charAt(i));
                }
                return Color.parseColor((String)builder.toString());
            }
        }
        if (value.contains("black") || value.contains("darken")) {
            return -16777216;
        }
        if (value.contains("green")) {
            return -16744448;
        }
        if (value.contains("silver")) {
            return -4144960;
        }
        if (value.contains("lime")) {
            return -16711936;
        }
        if (value.contains("gray")) {
            return -8355712;
        }
        if (value.contains("olive")) {
            return -8355840;
        }
        if (value.contains("white")) {
            return -1;
        }
        if (value.contains("yellow")) {
            return -256;
        }
        if (value.contains("maroon")) {
            return -8388608;
        }
        if (value.contains("navy")) {
            return -16777088;
        }
        if (value.contains("red")) {
            return -65536;
        }
        if (value.contains("blue")) {
            return -16776961;
        }
        if (value.contains("purple")) {
            return -8388480;
        }
        if (value.contains("teal")) {
            return -16744320;
        }
        if (value.contains("fuchsia")) {
            return -65281;
        }
        if (value.contains("aqua")) {
            return -16711681;
        }
        if (filled) {
            return -1;
        }
        return -16777216;
    }

    public void processRotation(AutoShape shape) {
        int shapeType;
        float angle = shape.getRotation();
        if (shape.getFlipHorizontal()) {
            angle = -angle;
        }
        if (shape.getFlipVertical()) {
            angle = -angle;
        }
        if (!((shapeType = shape.getShapeType()) != 32 && shapeType != 34 && shapeType != 38 || angle != 45.0f && angle != 135.0f && angle != 225.0f || shape.getFlipHorizontal() || shape.getFlipVertical())) {
            angle -= 90.0f;
        }
        shape.setRotation(angle);
    }

    private Rectangle processGrpSpRect(GroupShape parent, Rectangle rect) {
        if (parent != null) {
            rect.x += parent.getOffX();
            rect.y += parent.getOffY();
        }
        return rect;
    }

    private float processPolygonZoom(Element shape, AbstractShape autoShape, GroupShape parent, float zoomX, float zoomY) {
        String styleStr;
        Rectangle rect = null;
        if (shape != null && autoShape != null && shape.attribute("style") != null && shape.attribute("style") != null && (styleStr = shape.attributeValue("style")) != null) {
            String coordsize;
            float w = 0.0f;
            float h = 0.0f;
            float x = 0.0f;
            float y = 0.0f;
            String[] styles = styleStr.split(";");
            for (int i = 0; i < styles.length; ++i) {
                int index = -1;
                String[] temps = styles[i].split(":");
                if (temps == null || temps[0] == null || temps[1] == null) continue;
                if ("left".equalsIgnoreCase(temps[0])) {
                    index = temps[1].indexOf("pt");
                    if (index > 0) {
                        x += Float.parseFloat(temps[1].substring(0, index));
                        continue;
                    }
                    index = temps[1].indexOf("in");
                    if (index > 0) {
                        x += Float.parseFloat(temps[1].substring(0, index)) * 72.0f;
                        continue;
                    }
                    x += Float.parseFloat(temps[1]) * zoomX * 72.0f / 914400.0f;
                    continue;
                }
                if ("top".equalsIgnoreCase(temps[0])) {
                    index = temps[1].indexOf("pt");
                    if (index > 0) {
                        y += Float.parseFloat(temps[1].substring(0, index));
                        continue;
                    }
                    index = temps[1].indexOf("in");
                    if (index > 0) {
                        y += Float.parseFloat(temps[1].substring(0, index)) * 72.0f;
                        continue;
                    }
                    y += Float.parseFloat(temps[1]) * zoomY * 72.0f / 914400.0f;
                    continue;
                }
                if ("margin-left".equalsIgnoreCase(temps[0])) {
                    index = temps[1].indexOf("pt");
                    if (index > 0) {
                        x += Float.parseFloat(temps[1].substring(0, index));
                        continue;
                    }
                    index = temps[1].indexOf("in");
                    if (index > 0) {
                        x += Float.parseFloat(temps[1].substring(0, index)) * 72.0f;
                        continue;
                    }
                    x += Float.parseFloat(temps[1]) * 72.0f / 914400.0f;
                    continue;
                }
                if ("margin-top".equalsIgnoreCase(temps[0])) {
                    index = temps[1].indexOf("pt");
                    if (index > 0) {
                        y += Float.parseFloat(temps[1].substring(0, index));
                        continue;
                    }
                    index = temps[1].indexOf("in");
                    if (index > 0) {
                        y += Float.parseFloat(temps[1].substring(0, index)) * 72.0f;
                        continue;
                    }
                    y += Float.parseFloat(temps[1]) * 72.0f / 914400.0f;
                    continue;
                }
                if ("width".equalsIgnoreCase(temps[0])) {
                    index = temps[1].indexOf("pt");
                    if (index > 0) {
                        w = Float.parseFloat(temps[1].substring(0, index));
                        continue;
                    }
                    index = temps[1].indexOf("in");
                    if (index > 0) {
                        w = Float.parseFloat(temps[1].substring(0, index)) * 72.0f;
                        continue;
                    }
                    w = Float.parseFloat(temps[1]) * zoomX * 72.0f / 914400.0f;
                    continue;
                }
                if (!"height".equalsIgnoreCase(temps[0])) continue;
                index = temps[1].indexOf("pt");
                h = index > 0 ? Float.parseFloat(temps[1].substring(0, index)) : ((index = temps[1].indexOf("in")) > 0 ? Float.parseFloat(temps[1].substring(0, index)) * 72.0f : Float.parseFloat(temps[1]) * zoomY * 72.0f / 914400.0f);
            }
            rect = new Rectangle();
            rect.x = (int)(x * 1.3333334f);
            rect.y = (int)(y * 1.3333334f);
            rect.width = (int)(w * 1.3333334f);
            rect.height = (int)(h * 1.3333334f);
            if (autoShape.getType() != 7 && ((WPAutoShape)autoShape).getGroupShape() == null) {
                this.processGrpSpRect(parent, rect);
            }
            if (autoShape instanceof WPAutoShape && ((WPAutoShape)autoShape).getShapeType() == 233 && (coordsize = shape.attributeValue("coordsize")) != null && coordsize.length() > 0) {
                String[] size = coordsize.split(",");
                float width = Integer.parseInt(size[0]);
                float height = Integer.parseInt(size[1]);
                return Math.min(width / (float)rect.width, height / (float)rect.height);
            }
        }
        return 1.0f;
    }

    private float getValueInPt(String value, float zoom) {
        int index = -1;
        if (value.contains("pt")) {
            index = value.indexOf("pt");
            return Float.parseFloat(value.substring(0, index));
        }
        if (value.contains("in")) {
            index = value.indexOf("in");
            return Float.parseFloat(value.substring(0, index)) * 72.0f;
        }
        if (value.contains("mm")) {
            index = value.indexOf("mm");
            return Float.parseFloat(value.substring(0, index)) * 2.835f;
        }
        return Float.parseFloat(value) * zoom * 72.0f / 914400.0f;
    }

    private Rectangle processAutoShapeStyle(Element shape, AbstractShape autoShape, GroupShape parent, float zoomX, float zoomY) {
        String styleStr;
        Rectangle rect = null;
        if (shape != null && autoShape != null && shape.attribute("style") != null && shape.attribute("style") != null && (styleStr = shape.attributeValue("style")) != null) {
            String coordsize;
            float w = 0.0f;
            float h = 0.0f;
            float x = 0.0f;
            float y = 0.0f;
            String[] styles = styleStr.split(";");
            for (int i = 0; i < styles.length; ++i) {
                int[] relativeVal;
                int index = -1;
                String[] temps = styles[i].split(":");
                if (temps == null || temps[0] == null || temps[1] == null || "position".equalsIgnoreCase(temps[0])) continue;
                if ("left".equalsIgnoreCase(temps[0])) {
                    x += this.getValueInPt(temps[1], zoomX);
                    continue;
                }
                if ("top".equalsIgnoreCase(temps[0])) {
                    y += this.getValueInPt(temps[1], zoomY);
                    continue;
                }
                if ("text-align".equalsIgnoreCase(temps[0])) continue;
                if ("margin-left".equalsIgnoreCase(temps[0])) {
                    x += this.getValueInPt(temps[1], 1.0f);
                    continue;
                }
                if ("margin-top".equalsIgnoreCase(temps[0])) {
                    y += this.getValueInPt(temps[1], 1.0f);
                    continue;
                }
                if ("width".equalsIgnoreCase(temps[0])) {
                    w = this.getValueInPt(temps[1], zoomX);
                    continue;
                }
                if ("height".equalsIgnoreCase(temps[0])) {
                    h = this.getValueInPt(temps[1], zoomY);
                    continue;
                }
                if ("mso-width-percent".equalsIgnoreCase(temps[0])) {
                    if (!this.relativeType.contains(autoShape)) {
                        relativeVal = new int[4];
                        relativeVal[0] = (int)Float.parseFloat(temps[1]);
                        this.relativeType.add(autoShape);
                        this.relativeValue.put(autoShape, relativeVal);
                        continue;
                    }
                    this.relativeValue.get((Object)autoShape)[0] = (int)Float.parseFloat(temps[1]);
                    continue;
                }
                if ("mso-height-percent".equalsIgnoreCase(temps[0])) {
                    if (!this.relativeType.contains(autoShape)) {
                        relativeVal = new int[4];
                        relativeVal[2] = (int)Float.parseFloat(temps[1]);
                        this.relativeType.add(autoShape);
                        this.relativeValue.put(autoShape, relativeVal);
                        continue;
                    }
                    this.relativeValue.get((Object)autoShape)[2] = (int)Float.parseFloat(temps[1]);
                    continue;
                }
                if ("flip".equalsIgnoreCase(temps[0])) {
                    if ("x".equalsIgnoreCase(temps[1])) {
                        autoShape.setFlipHorizontal(true);
                        continue;
                    }
                    if (!"y".equalsIgnoreCase(temps[1])) continue;
                    autoShape.setFlipVertical(true);
                    continue;
                }
                if ("rotation".equalsIgnoreCase(temps[0])) {
                    if (temps[1].indexOf("fd") > 0) {
                        temps[1] = temps[1].substring(0, temps[1].length() - 2);
                        autoShape.setRotation(Integer.parseInt(temps[1]) / 60000);
                        continue;
                    }
                    autoShape.setRotation(Integer.parseInt(temps[1]));
                    continue;
                }
                if ("mso-width-relative".equalsIgnoreCase(temps[0]) || "mso-height-relative".equalsIgnoreCase(temps[0])) continue;
                if (parent == null && autoShape.getType() != 7 && "mso-position-horizontal".equalsIgnoreCase(temps[0])) {
                    ((WPAutoShape)autoShape).setHorizontalAlignment(this.getAlign(temps[1]));
                    continue;
                }
                if (parent == null && autoShape.getType() != 7 && "mso-left-percent".equalsIgnoreCase(temps[0])) {
                    ((WPAutoShape)autoShape).setHorRelativeValue(Integer.parseInt(temps[1]));
                    ((WPAutoShape)autoShape).setHorPositionType((byte)1);
                    continue;
                }
                if (parent == null && autoShape.getType() != 7 && "mso-position-horizontal-relative".equalsIgnoreCase(temps[0])) {
                    if ("margin".equalsIgnoreCase(temps[1])) {
                        ((WPAutoShape)autoShape).setHorizontalRelativeTo((byte)1);
                        continue;
                    }
                    if ("page".equalsIgnoreCase(temps[1])) {
                        ((WPAutoShape)autoShape).setHorizontalRelativeTo((byte)2);
                        continue;
                    }
                    if ("left-margin-area".equalsIgnoreCase(temps[1])) {
                        ((WPAutoShape)autoShape).setHorizontalRelativeTo((byte)4);
                        continue;
                    }
                    if ("right-margin-area".equalsIgnoreCase(temps[1])) {
                        ((WPAutoShape)autoShape).setHorizontalRelativeTo((byte)5);
                        continue;
                    }
                    if ("inner-margin-area".equalsIgnoreCase(temps[1])) {
                        ((WPAutoShape)autoShape).setHorizontalRelativeTo((byte)8);
                        continue;
                    }
                    if ("outer-margin-area".equalsIgnoreCase(temps[1])) {
                        ((WPAutoShape)autoShape).setHorizontalRelativeTo((byte)9);
                        continue;
                    }
                    if ("text".equalsIgnoreCase(temps[1])) {
                        ((WPAutoShape)autoShape).setHorizontalRelativeTo((byte)0);
                        continue;
                    }
                    if (!"char".equalsIgnoreCase(temps[1])) continue;
                    ((WPAutoShape)autoShape).setHorizontalRelativeTo((byte)3);
                    continue;
                }
                if (parent == null && autoShape.getType() != 7 && "mso-position-vertical".equalsIgnoreCase(temps[0])) {
                    ((WPAutoShape)autoShape).setVerticalAlignment(this.getAlign(temps[1]));
                    continue;
                }
                if (parent == null && autoShape.getType() != 7 && "mso-top-percent".equalsIgnoreCase(temps[0])) {
                    ((WPAutoShape)autoShape).setVerRelativeValue(Integer.parseInt(temps[1]));
                    ((WPAutoShape)autoShape).setVerPositionType((byte)1);
                    continue;
                }
                if (parent != null || autoShape.getType() == 7 || !"mso-position-vertical-relative".equalsIgnoreCase(temps[0])) continue;
                if ("line".equalsIgnoreCase(temps[1])) {
                    ((WPAutoShape)autoShape).setVerticalRelativeTo((byte)11);
                    continue;
                }
                if ("text".equalsIgnoreCase(temps[1])) {
                    ((WPAutoShape)autoShape).setVerticalRelativeTo((byte)10);
                    continue;
                }
                if ("margin".equalsIgnoreCase(temps[1])) {
                    ((WPAutoShape)autoShape).setVerticalRelativeTo((byte)1);
                    continue;
                }
                if ("page".equalsIgnoreCase(temps[1])) {
                    ((WPAutoShape)autoShape).setVerticalRelativeTo((byte)2);
                    continue;
                }
                if ("top-margin-area".equalsIgnoreCase(temps[1])) {
                    ((WPAutoShape)autoShape).setVerticalRelativeTo((byte)6);
                    continue;
                }
                if ("bottom-margin-area".equalsIgnoreCase(temps[1])) {
                    ((WPAutoShape)autoShape).setVerticalRelativeTo((byte)7);
                    continue;
                }
                if ("inner-margin-area".equalsIgnoreCase(temps[1])) {
                    ((WPAutoShape)autoShape).setVerticalRelativeTo((byte)8);
                    continue;
                }
                if (!"outer-margin-area".equalsIgnoreCase(temps[1])) continue;
                ((WPAutoShape)autoShape).setVerticalRelativeTo((byte)9);
            }
            rect = new Rectangle();
            rect.x = (int)(x * 1.3333334f);
            rect.y = (int)(y * 1.3333334f);
            rect.width = (int)(w * 1.3333334f);
            rect.height = (int)(h * 1.3333334f);
            if (autoShape.getType() != 7 && ((WPAutoShape)autoShape).getGroupShape() == null) {
                this.processGrpSpRect(parent, rect);
            }
            if (autoShape instanceof WPAutoShape && ((WPAutoShape)autoShape).getShapeType() == 233 && (coordsize = shape.attributeValue("coordsize")) != null && coordsize.length() > 0) {
                String[] size = coordsize.split(",");
                Matrix m = new Matrix();
                float width = Integer.parseInt(size[0]);
                float height = Integer.parseInt(size[1]);
                m.postScale((float)rect.width / width, (float)rect.height / height);
                List<ExtendPath> paths = ((WPAutoShape)autoShape).getPaths();
                for (ExtendPath path : paths) {
                    path.getPath().transform(m);
                }
            }
            autoShape.setBounds(rect);
        }
        return rect;
    }

    private byte getFillType(String type) {
        if ("gradient".equalsIgnoreCase(type)) {
            return 7;
        }
        if ("gradientRadial".equalsIgnoreCase(type)) {
            return 4;
        }
        if ("pattern".equalsIgnoreCase(type)) {
            return 1;
        }
        if ("tile".equalsIgnoreCase(type)) {
            return 2;
        }
        if ("frame".equalsIgnoreCase(type)) {
            return 3;
        }
        return 0;
    }

    private int getRadialGradientPositionType(Element fill) {
        String[] xy;
        int positionType = 0;
        String focusposition = fill.attributeValue("focusposition");
        if (focusposition != null && focusposition.length() > 0 && (xy = focusposition.split(",")) != null) {
            if (xy.length == 2) {
                if (".5".equalsIgnoreCase(xy[0]) && ".5".equalsIgnoreCase(xy[1])) {
                    positionType = 4;
                } else if ("1".equalsIgnoreCase(xy[0]) && "1".equalsIgnoreCase(xy[1])) {
                    positionType = 3;
                } else if ("".equalsIgnoreCase(xy[0]) && "1".equalsIgnoreCase(xy[1])) {
                    positionType = 2;
                } else if ("1".equalsIgnoreCase(xy[0]) && "".equalsIgnoreCase(xy[1])) {
                    positionType = 1;
                }
            } else if (xy.length == 1 && "1".equalsIgnoreCase(xy[0])) {
                positionType = 1;
            }
        }
        return positionType;
    }

    private int getAutoShapeType(Element shape) {
        int shapeType = 0;
        String name = shape.getName();
        if (name.equals("rect")) {
            shapeType = 1;
        } else if (name.equals("roundrect")) {
            shapeType = 2;
        } else if (name.equals("oval")) {
            shapeType = 3;
        } else if (name.equals("curve")) {
            shapeType = 248;
        } else if (name.equals("polyline")) {
            shapeType = 249;
        } else if (name.equals("line")) {
            shapeType = 247;
        }
        if (shape.attribute("type") != null) {
            String val = shape.attributeValue("type");
            if (val != null && val.length() > 9) {
                val = val.substring(9);
                shapeType = Integer.parseInt(val);
            }
        } else if (shape.attribute("path") != null) {
            shapeType = 233;
        }
        return shapeType;
    }

    private float getValue(String value) {
        int index = value.indexOf("pt");
        float w = 0.0f;
        w = index > 0 ? Float.parseFloat(value.substring(0, index)) : ((index = value.indexOf("in")) > 0 ? Float.parseFloat(value.substring(0, index)) * 72.0f : Float.parseFloat(value) * 72.0f / 914400.0f);
        return w * 1.3333334f;
    }

    private PointF[] processPoints(String text) {
        ArrayList<PointF> ptList = new ArrayList<PointF>();
        if (text != null) {
            String[] pts = text.split(",");
            int cnt = pts.length;
            for (int index = 0; index < cnt - 1; index += 2) {
                ptList.add(new PointF(this.getValue(pts[index]), this.getValue(pts[index + 1])));
            }
        }
        return ptList.toArray(new PointF[ptList.size()]);
    }

    private void processArrow(WPAutoShape autoShape, Element shape) {
        Element stroke = shape.element("stroke");
        if (stroke != null) {
            byte type = this.getArrowType(stroke.attributeValue("startarrow"));
            if (type > 0) {
                autoShape.createStartArrow(type, this.getArrowWidth(stroke.attributeValue("startarrowwidth")), this.getArrowLength(stroke.attributeValue("startarrowlength")));
            }
            if ((type = this.getArrowType(stroke.attributeValue("endarrow"))) > 0) {
                autoShape.createEndArrow(type, this.getArrowWidth(stroke.attributeValue("endarrowwidth")), this.getArrowLength(stroke.attributeValue("endarrowlength")));
            }
        }
    }

    private ExtendPath getArrowExtendPath(Path arrowPath, BackgroundAndFill fill, Line line, boolean border, byte arrowType) {
        ExtendPath pathExtend = new ExtendPath();
        pathExtend.setArrowFlag(true);
        pathExtend.setPath(arrowPath);
        if (fill != null || border) {
            if (border) {
                if (arrowType != 5) {
                    if (line != null) {
                        pathExtend.setBackgroundAndFill(line.getBackgroundAndFill());
                    } else if (fill != null) {
                        pathExtend.setBackgroundAndFill(fill);
                    }
                } else {
                    pathExtend.setLine(line);
                }
            } else if (fill != null) {
                pathExtend.setBackgroundAndFill(fill);
            }
        }
        return pathExtend;
    }

    private WPAutoShape processAutoShape(Element shape, ParagraphElement paraElem, WPGroupShape parent, float zoomX, float zoomY, boolean hasTextbox) {
        if (shape != null) {
            String val;
            Float[] values = null;
            boolean border = true;
            int shapeType = this.getAutoShapeType(shape);
            WPAutoShape autoShape = null;
            String[] adjustStr = null;
            if (shape.attribute("adj") != null && (val = shape.attributeValue("adj")) != null && val.length() > 0) {
                adjustStr = val.split(",");
            }
            if (adjustStr != null && adjustStr.length > 0) {
                values = new Float[adjustStr.length];
                for (int i = 0; i < adjustStr.length; ++i) {
                    String temp = adjustStr[i];
                    values[i] = temp != null && temp.length() > 0 ? Float.valueOf(Float.parseFloat(temp) / 21600.0f) : null;
                }
            }
            BackgroundAndFill fill = this.processBackgroundAndFill(shape);
            Line line = this.processLine(shape);
            if (shapeType == 32 || shapeType == 33 || shapeType == 34 || shapeType == 38) {
                autoShape = new WPAutoShape();
                autoShape.setShapeType(shapeType);
                autoShape.setLine(line);
                this.processArrow(autoShape, shape);
                if (autoShape.getShapeType() == 33 && values == null) {
                    autoShape.setAdjustData(new Float[]{Float.valueOf(1.0f)});
                } else {
                    autoShape.setAdjustData(values);
                }
            } else if (shapeType == 233) {
                autoShape = new WPAutoShape();
                autoShape.setShapeType(233);
                this.processArrow(autoShape, shape);
                String pathContext = shape.attributeValue("path");
                float pathzoom = this.processPolygonZoom(shape, autoShape, parent, zoomX, zoomY);
                int lineWidth = Math.round((float)(line != null ? line.getLineWidth() : 1) * pathzoom);
                PathWithArrow pathWithArrow = VMLPathParser.instance().createPath(autoShape, pathContext, lineWidth);
                if (pathWithArrow != null) {
                    Path[] paths = pathWithArrow.getPolygonPath();
                    if (paths != null) {
                        for (int i = 0; i < paths.length; ++i) {
                            ExtendPath pathExtend = new ExtendPath();
                            pathExtend.setPath(paths[i]);
                            if (line != null) {
                                pathExtend.setLine(line);
                            }
                            if (fill != null) {
                                pathExtend.setBackgroundAndFill(fill);
                            }
                            autoShape.appendPath(pathExtend);
                        }
                    }
                    if (pathWithArrow.getStartArrow() != null) {
                        autoShape.appendPath(this.getArrowExtendPath(pathWithArrow.getStartArrow(), fill, line, border, autoShape.getStartArrow().getType()));
                    }
                    if (pathWithArrow.getEndArrow() != null) {
                        autoShape.appendPath(this.getArrowExtendPath(pathWithArrow.getEndArrow(), fill, line, border, autoShape.getEndArrow().getType()));
                    }
                }
            } else if (shapeType == 247 || shapeType == 248 || shapeType == 249) {
                int lineWidth;
                autoShape = new WPAutoShape();
                autoShape.setShapeType(shapeType);
                this.processArrow(autoShape, shape);
                Path path = new Path();
                Path startArrowPath = null;
                Path endArrowPath = null;
                int n = lineWidth = line != null ? line.getLineWidth() : 1;
                if (shapeType == 20) {
                    ArrowPathAndTail arrowPathAndTail;
                    if (line != null) {
                        fill = line.getBackgroundAndFill();
                    }
                    from = this.processPoints(shape.attributeValue("from"))[0];
                    PointF to = this.processPoints(shape.attributeValue("to"))[0];
                    PointF startArrowTailCenter = null;
                    PointF endArrowTailCenter = null;
                    if (autoShape.getStartArrowhead()) {
                        arrowPathAndTail = LineArrowPathBuilder.getDirectLineArrowPath(to.x, to.y, from.x, from.y, autoShape.getStartArrow(), lineWidth);
                        startArrowPath = arrowPathAndTail.getArrowPath();
                        startArrowTailCenter = arrowPathAndTail.getArrowTailCenter();
                    }
                    if (autoShape.getEndArrowhead()) {
                        arrowPathAndTail = LineArrowPathBuilder.getDirectLineArrowPath(from.x, from.y, to.x, to.y, autoShape.getEndArrow(), lineWidth);
                        endArrowPath = arrowPathAndTail.getArrowPath();
                        endArrowTailCenter = arrowPathAndTail.getArrowTailCenter();
                    }
                    if (startArrowTailCenter != null) {
                        from = LineArrowPathBuilder.getReferencedPosition(from.x, from.y, startArrowTailCenter.x, startArrowTailCenter.y, autoShape.getStartArrow().getType());
                    }
                    if (endArrowTailCenter != null) {
                        to = LineArrowPathBuilder.getReferencedPosition(to.x, to.y, endArrowTailCenter.x, endArrowTailCenter.y, autoShape.getEndArrow().getType());
                    }
                    path.moveTo(from.x, from.y);
                    path.lineTo(to.x, to.y);
                } else if (shapeType == 248) {
                    ArrowPathAndTail arrowPathAndTail;
                    from = this.processPoints(shape.attributeValue("from"))[0];
                    PointF ctr1 = this.processPoints(shape.attributeValue("control1"))[0];
                    PointF ctr2 = this.processPoints(shape.attributeValue("control2"))[0];
                    PointF to = this.processPoints(shape.attributeValue("to"))[0];
                    PointF startArrowTailCenter = null;
                    PointF endArrowTailCenter = null;
                    if (autoShape.getStartArrowhead()) {
                        arrowPathAndTail = LineArrowPathBuilder.getCubicBezArrowPath(to.x, to.y, ctr2.x, ctr2.y, ctr1.x, ctr1.y, from.x, from.y, autoShape.getStartArrow(), lineWidth);
                        startArrowPath = arrowPathAndTail.getArrowPath();
                        startArrowTailCenter = arrowPathAndTail.getArrowTailCenter();
                    }
                    if (autoShape.getEndArrowhead()) {
                        arrowPathAndTail = LineArrowPathBuilder.getCubicBezArrowPath(from.x, from.y, ctr1.x, ctr1.y, ctr2.x, ctr2.y, to.x, to.y, autoShape.getEndArrow(), lineWidth);
                        endArrowPath = arrowPathAndTail.getArrowPath();
                        endArrowTailCenter = arrowPathAndTail.getArrowTailCenter();
                    }
                    if (startArrowTailCenter != null) {
                        from = LineArrowPathBuilder.getReferencedPosition(from.x, from.y, startArrowTailCenter.x, startArrowTailCenter.y, autoShape.getStartArrow().getType());
                    }
                    if (endArrowTailCenter != null) {
                        to = LineArrowPathBuilder.getReferencedPosition(to.x, to.y, endArrowTailCenter.x, endArrowTailCenter.y, autoShape.getEndArrow().getType());
                    }
                    path.moveTo(from.x, from.y);
                    path.cubicTo(ctr1.x, ctr1.y, ctr2.x, ctr2.y, to.x, to.y);
                } else if (shapeType == 249) {
                    ArrowPathAndTail arrowPathAndTail;
                    PointF[] pts = this.processPoints(shape.attributeValue("points"));
                    int ptCnt = pts.length;
                    PointF startArrowTailCenter = null;
                    PointF endArrowTailCenter = null;
                    if (autoShape.getStartArrowhead()) {
                        arrowPathAndTail = LineArrowPathBuilder.getDirectLineArrowPath(pts[1].x, pts[1].y, pts[0].x, pts[0].y, autoShape.getStartArrow(), lineWidth);
                        startArrowPath = arrowPathAndTail.getArrowPath();
                        startArrowTailCenter = arrowPathAndTail.getArrowTailCenter();
                    }
                    if (autoShape.getEndArrowhead()) {
                        arrowPathAndTail = LineArrowPathBuilder.getDirectLineArrowPath(pts[ptCnt - 2].x, pts[ptCnt - 2].y, pts[ptCnt - 1].x, pts[ptCnt - 1].y, autoShape.getEndArrow(), lineWidth);
                        endArrowPath = arrowPathAndTail.getArrowPath();
                        endArrowTailCenter = arrowPathAndTail.getArrowTailCenter();
                    }
                    if (startArrowTailCenter != null) {
                        pts[0] = LineArrowPathBuilder.getReferencedPosition(pts[0].x, pts[0].y, startArrowTailCenter.x, startArrowTailCenter.y, autoShape.getStartArrow().getType());
                    }
                    if (endArrowTailCenter != null) {
                        pts[ptCnt - 1] = LineArrowPathBuilder.getReferencedPosition(pts[ptCnt - 1].x, pts[ptCnt - 1].y, endArrowTailCenter.x, endArrowTailCenter.y, autoShape.getEndArrow().getType());
                    }
                    path.moveTo(pts[0].x, pts[0].y);
                    for (int index = 1; index < pts.length; ++index) {
                        path.lineTo(pts[index].x, pts[index].y);
                    }
                }
                ExtendPath pathExtend = new ExtendPath();
                pathExtend.setPath(path);
                if (line != null) {
                    pathExtend.setLine(line);
                }
                if (fill != null) {
                    pathExtend.setBackgroundAndFill(fill);
                }
                autoShape.appendPath(pathExtend);
                if (startArrowPath != null) {
                    autoShape.appendPath(this.getArrowExtendPath(startArrowPath, fill, line, border, autoShape.getStartArrow().getType()));
                }
                if (endArrowPath != null) {
                    autoShape.appendPath(this.getArrowExtendPath(endArrowPath, fill, line, border, autoShape.getEndArrow().getType()));
                }
            } else if (hasTextbox || fill != null || border) {
                String s = shape.attributeValue("id");
                if (s != null && s.indexOf("WaterMarkObject") > 0) {
                    this.isProcessWatermark = true;
                }
                autoShape = this.isProcessWatermark ? new WatermarkShape() : new WPAutoShape();
                autoShape.setShapeType(shapeType);
                this.processArrow(autoShape, shape);
                if (fill != null) {
                    autoShape.setBackgroundAndFill(fill);
                }
                if (line != null) {
                    autoShape.setLine(line);
                }
                autoShape.setAdjustData(values);
            }
            if (autoShape != null) {
                autoShape.setAuotShape07(true);
                if (parent == null) {
                    autoShape.setWrap(this.getShapeWrapType(shape));
                } else {
                    autoShape.setWrap(parent.getWrapType());
                }
                this.processAutoShapeStyle(shape, autoShape, parent, zoomX, zoomY);
                this.processRotation(autoShape);
                if (this.isProcessWatermark) {
                    this.processWatermark((WatermarkShape)autoShape, shape);
                    this.isProcessWatermark = false;
                }
                if (parent == null) {
                    this.addShape(autoShape, paraElem);
                } else {
                    parent.appendShapes(autoShape);
                }
            }
            return autoShape;
        }
        return null;
    }

    private void processWatermark(WatermarkShape waterMark, Element shape) {
        Element textpath = shape.element("textpath");
        if (textpath != null) {
            String[] styles;
            Element fill;
            waterMark.setWatermarkType((byte)0);
            String fillColor = shape.attributeValue("fillcolor");
            if (fillColor != null && fillColor.length() > 0) {
                waterMark.setFontColor(this.getColor(fillColor, false));
            }
            if ((fill = shape.element("fill")) != null) {
                waterMark.setOpacity(Float.parseFloat(fill.attributeValue("opacity")));
            }
            waterMark.setWatermartString(textpath.attributeValue("string"));
            String style2 = textpath.attributeValue("style");
            for (String item : styles = style2.split(";")) {
                String[] items = item.split(":");
                if (!"font-size".equalsIgnoreCase(items[0])) continue;
                int fontSize = Integer.parseInt(items[1].replace("pt", ""));
                if (fontSize == 1) {
                    waterMark.setAutoFontSize(true);
                    continue;
                }
                waterMark.setFontSize(fontSize);
            }
        }
    }

    private Line processLine(Element shape) {
        String val = shape.attributeValue("stroked");
        if ("f".equalsIgnoreCase(val) || "false".equalsIgnoreCase(val)) {
            return null;
        }
        String type = shape.attributeValue("type");
        List shapeTypes = shape.getParent().elements("shapetype");
        Element shapetype = null;
        if (type != null && shapeTypes != null) {
            for (Element shapeType : shapeTypes) {
                if (!type.equals("#" + shapeType.attributeValue("id"))) continue;
                shapetype = shapeType;
                break;
            }
        }
        if (shapetype != null && ("f".equalsIgnoreCase(val = shapetype.attributeValue("stroked")) || "false".equalsIgnoreCase(val))) {
            return null;
        }
        Line line = null;
        int lineColor = -16777216;
        val = shape.attributeValue("strokecolor");
        if (val != null && val.length() > 0) {
            lineColor = this.getColor(val, false);
        }
        BackgroundAndFill lineFill = new BackgroundAndFill();
        lineFill.setForegroundColor(lineColor);
        int lineWidth = 1;
        val = shape.attributeValue("strokeweight");
        if (shape.attributeValue("strokeweight") != null) {
            if (val.indexOf("pt") >= 0) {
                val = val.replace("pt", "");
            } else if (val.indexOf("mm") >= 0) {
                val = val.replace("mm", "");
            } else if (val.indexOf("cm") >= 0) {
                val = val.replace("cm", "");
            }
            lineWidth = Math.round(Float.parseFloat(val) * 1.3333334f);
        }
        boolean dash = false;
        Element stroke = null;
        if (shape.element("stroke") != null) {
            stroke = shape.element("stroke");
            dash = stroke.attributeValue("dashstyle") != null;
        }
        line = new Line();
        line.setBackgroundAndFill(lineFill);
        line.setLineWidth(lineWidth);
        line.setDash(dash);
        return line;
    }

    private BackgroundAndFill processBackgroundAndFill(Element shape) {
        String val;
        BackgroundAndFill fill = null;
        boolean filled = true;
        if (shape.attribute("filled") != null && (val = shape.attributeValue("filled")) != null && val.length() > 0 && (val.equals("f") || val.equals("false"))) {
            filled = false;
        }
        if (filled) {
            Element fillElem = shape.element("fill");
            if (fillElem != null && fillElem.attribute("id") != null && (val = fillElem.attributeValue("id")) != null && val.length() > 0) {
                PackagePart picPart = null;
                picPart = this.isProcessHF && this.hfPart != null ? this.zipPackage.getPart(this.hfPart.getRelationship(val).getTargetURI()) : this.zipPackage.getPart(this.packagePart.getRelationship(val).getTargetURI());
                if (picPart != null) {
                    fill = new BackgroundAndFill();
                    byte type = this.getFillType(fillElem.attributeValue("type"));
                    try {
                        if (type == 2) {
                            fill.setFillType((byte)2);
                            int index = this.control.getSysKit().getPictureManage().addPicture(picPart);
                            fill.setShader(new TileShader(this.control.getSysKit().getPictureManage().getPicture(index), 0, 1.0f, 1.0f));
                        } else if (type == 1) {
                            val = shape.attributeValue("fillcolor");
                            int foregroundColor = -1;
                            if (val != null && val.length() > 0) {
                                foregroundColor = this.getColor(val, false);
                            }
                            int backgroundColor = -1;
                            val = fillElem.attributeValue("color2");
                            if (val != null) {
                                backgroundColor = this.getColor(val, true);
                            }
                            fill.setFillType((byte)1);
                            int index = this.control.getSysKit().getPictureManage().addPicture(picPart);
                            fill.setShader(new PatternShader(this.control.getSysKit().getPictureManage().getPicture(index), backgroundColor, foregroundColor));
                        } else {
                            fill.setFillType((byte)3);
                            fill.setPictureIndex(this.control.getSysKit().getPictureManage().addPicture(picPart));
                        }
                    }
                    catch (Exception e) {
                        this.control.getSysKit().getErrorKit().writerLog(e);
                    }
                }
            }
            if (fill == null) {
                fill = new BackgroundAndFill();
                byte type = 0;
                if (fillElem != null) {
                    type = this.getFillType(fillElem.attributeValue("type"));
                }
                if (fillElem == null || type == 0) {
                    String opacityStr;
                    int fillColor = -1;
                    fill.setFillType((byte)0);
                    val = shape.attributeValue("fillcolor");
                    if (val != null && val.length() > 0) {
                        fillColor = this.getColor(val, true);
                    }
                    if (fillElem != null && (opacityStr = fillElem.attributeValue("opacity")) != null) {
                        float opacity = Float.parseFloat(opacityStr);
                        if (opacity > 1.0f) {
                            opacity /= 65536.0f;
                        }
                        fillColor = (byte)(opacity *= 255.0f) << 24 | fillColor & 0xFFFFFF;
                    }
                    fill.setForegroundColor(fillColor);
                } else {
                    Gradient gradient = this.readGradient(shape, fillElem, type);
                    fill.setFillType(type);
                    fill.setShader(gradient);
                }
            }
        }
        return fill;
    }

    private Gradient readGradient(Element shape, Element fillElem, byte type) {
        int focus = 0;
        String sFocus = fillElem.attributeValue("focus");
        if (sFocus != null) {
            focus = Integer.parseInt(sFocus.replace("%", ""));
        }
        int angle = 0;
        String sAngle = fillElem.attributeValue("angle");
        if (sAngle != null) {
            angle = Integer.parseInt(sAngle);
        }
        switch (angle) {
            case -90: 
            case 0: {
                angle += 90;
                break;
            }
            case -45: {
                angle = 135;
                break;
            }
            case -135: {
                angle = 45;
            }
        }
        int[] colors = null;
        float[] positions = null;
        String intermediateColors = fillElem.attributeValue("colors");
        if (intermediateColors != null) {
            String[] positionColor = intermediateColors.split(";");
            int length = positionColor.length;
            colors = new int[length];
            positions = new float[length];
            int index = 0;
            String pos = null;
            Object color2 = null;
            for (int i = 0; i < length; ++i) {
                index = positionColor[i].indexOf(" ");
                pos = positionColor[i].substring(0, index);
                positions[i] = pos.contains("f") ? Float.parseFloat(pos) / 100000.0f : Float.parseFloat(pos);
                colors[i] = this.getColor(positionColor[i].substring(index + 1, positionColor[i].length()), true);
            }
        } else {
            int color3 = this.getColor(shape.attributeValue("fillcolor"), true);
            int color2 = 0;
            String sColor2 = fillElem.attributeValue("color2");
            if (sColor2 != null) {
                sColor2 = sColor2.replace("fill ", "");
                int index1 = sColor2.indexOf("(");
                int index2 = sColor2.indexOf(")");
                if (index1 >= 0 && index2 >= 0) {
                    String string2 = sColor2.substring(index1 + 1, index2);
                }
                color2 = this.getColor(sColor2, true);
            }
            colors = new int[]{color3, color2};
            positions = new float[]{0.0f, 1.0f};
        }
        Gradient gradient = null;
        if (type == 7) {
            gradient = new LinearGradientShader(angle, colors, positions);
        } else if (type == 4) {
            int posType = this.getRadialGradientPositionType(fillElem);
            gradient = new RadialGradientShader(posType, colors, positions);
        }
        if (gradient != null) {
            gradient.setFocus(focus);
        }
        return gradient;
    }

    private AbstractShape processAutoShape2010(ParagraphElement paraElem, Element sp, WPGroupShape parent, float zoomX, float zoomY, int x, int y, boolean bResetRect) {
        return this.processAutoShape2010(this.packagePart, paraElem, sp, parent, zoomX, zoomY, x, y, bResetRect);
    }

    private AbstractShape processAutoShape2010(PackagePart packagePart, ParagraphElement paraElem, Element sp, WPGroupShape parent, float zoomX, float zoomY, int x, int y, boolean bResetRect) {
        Rectangle rect = null;
        AbstractShape shape = null;
        if (sp != null) {
            Element temp = null;
            String name = sp.getName();
            if (name.equals("wsp") || name.equals("sp") || name.equals("pic")) {
                temp = sp.element("spPr");
            } else if (name.equals("wgp") || name.equals("grpSp")) {
                temp = sp.element("grpSpPr");
            }
            if (temp != null && (rect = ReaderKit.instance().getShapeAnchor(temp.element("xfrm"), zoomX, zoomY)) != null) {
                if (bResetRect) {
                    rect.x += x;
                    rect.y += y;
                }
                rect = this.processGrpSpRect(parent, rect);
            }
            if (rect != null && (name.equals("wgp") || name.equals("grpSp"))) {
                float[] zoomXY = null;
                Rectangle childRect = null;
                Element grpSpPr = sp.element("grpSpPr");
                if (grpSpPr != null) {
                    zoomXY = ReaderKit.instance().getAnchorFitZoom(grpSpPr.element("xfrm"));
                    childRect = ReaderKit.instance().getChildShapeAnchor(grpSpPr.element("xfrm"), zoomXY[0] * zoomX, zoomXY[1] * zoomY);
                    if (bResetRect) {
                        childRect.x += x;
                        childRect.y += y;
                    }
                    WPGroupShape grpShape = new WPGroupShape();
                    grpShape.setOffPostion(rect.x - childRect.x, rect.y - childRect.y);
                    grpShape.setBounds(rect);
                    ReaderKit.instance().processRotation(grpSpPr, grpShape);
                    Iterator it = sp.elementIterator();
                    while (it.hasNext()) {
                        this.processAutoShape2010(packagePart, paraElem, (Element)it.next(), grpShape, zoomXY[0] * zoomX, zoomXY[1] * zoomY, 0, 0, false);
                    }
                    if (parent == null) {
                        shape = new WPAutoShape();
                        ((WPAutoShape)shape).addGroupShape(grpShape);
                    } else {
                        shape = grpShape;
                    }
                }
            } else if (rect != null) {
                if (name.equals("wsp") || name.equals("sp")) {
                    try {
                        if (this.isProcessHF && this.hfPart != null) {
                            shape = AutoShapeDataKit.getAutoShape(this.control, this.zipPackage, this.hfPart, sp, rect, this.themeColor, 0, this.hasTextbox2010(sp));
                            if (shape != null) {
                                this.processTextbox2010(packagePart, (WPAutoShape)shape, sp);
                            }
                        } else {
                            shape = AutoShapeDataKit.getAutoShape(this.control, this.zipPackage, packagePart, sp, rect, this.themeColor, 0, this.hasTextbox2010(sp));
                            if (shape != null) {
                                this.processTextbox2010(packagePart, (WPAutoShape)shape, sp);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                } else if (name.equals("pic")) {
                    shape = this.addPicture(sp, rect);
                }
            }
            if (shape != null) {
                if (parent == null) {
                    this.addShape(shape, paraElem);
                } else {
                    shape.setParent(parent);
                    if (shape instanceof WPAutoShape) {
                        ((WPAutoShape)shape).setWrap(parent.getWrapType());
                    }
                    parent.appendShapes(shape);
                }
            }
        }
        return shape;
    }

    private void processAlternateContent(Element alternateContent, ParagraphElement paraElem) {
        Element drawing;
        Element choice;
        if (alternateContent != null && (choice = alternateContent.element("Choice")) != null && (drawing = choice.element("drawing")) != null) {
            Element anchor = drawing.element("anchor");
            short wrapType = -1;
            if (anchor == null) {
                anchor = drawing.element("inline");
                wrapType = 2;
            }
            if (anchor != null) {
                Element graphicData;
                String val;
                Element docPr = anchor.element("docPr");
                if (docPr != null && (val = docPr.attributeValue("name")) != null && (val.startsWith("Genko") || val.startsWith("Header") || val.startsWith("Footer"))) {
                    return;
                }
                Element graphic = anchor.element("graphic");
                if (graphic != null && (graphicData = graphic.element("graphicData")) != null) {
                    Iterator it = graphicData.elementIterator();
                    while (it.hasNext()) {
                        AbstractShape shape = this.processAutoShape2010(paraElem, (Element)it.next(), null, 1.0f, 1.0f, 0, 0, true);
                        if (shape == null) continue;
                        if (shape instanceof WPAutoShape && ((WPAutoShape)shape).getGroupShape() != null) {
                            WPGroupShape grp = ((WPAutoShape)shape).getGroupShape();
                            if (wrapType == -1) {
                                wrapType = this.getDrawingWrapType(anchor);
                            }
                            grp.setWrapType(wrapType);
                            this.setShapeWrapType(grp, wrapType);
                        }
                        this.processWrapAndPosition_Drawing((WPAutoShape)shape, anchor, shape.getBounds());
                    }
                }
            }
        }
    }

    private void setShapeWrapType(WPGroupShape groupShape, short wrapType) {
        for (IShape item : groupShape.getShapes()) {
            if (item instanceof WPAbstractShape) {
                ((WPAbstractShape)item).setWrap(wrapType);
                continue;
            }
            if (!(item instanceof WPGroupShape)) continue;
            this.setShapeWrapType((WPGroupShape)item, wrapType);
        }
    }

    private void processRunAttribute(Element rPr, IAttributeSet attr) {
        Element s;
        String underlineType;
        Element u;
        Element temp;
        String val;
        Element szCs = rPr.element("szCs");
        Element sz = rPr.element("sz");
        if (szCs != null || sz != null) {
            float szSize = 12.0f;
            if (szCs != null) {
                val = szCs.attributeValue("val");
                szSize = Math.max(szSize, Float.parseFloat(val) / 2.0f);
            }
            if (sz != null) {
                val = sz.attributeValue("val");
                szSize = Math.max(szSize, Float.parseFloat(val) / 2.0f);
            }
            AttrManage.instance().setFontSize(attr, (int)szSize);
        }
        if ((temp = rPr.element("rFonts")) != null) {
            int index;
            val = temp.attributeValue("hAnsi");
            if (val == null) {
                val = temp.attributeValue("eastAsia");
            }
            if (val != null && (index = FontTypefaceManage.instance().addFontName(val)) >= 0) {
                AttrManage.instance().setFontName(attr, index);
            }
        }
        if ((temp = rPr.element("color")) != null) {
            val = temp.attributeValue("val");
            if ("auto".equals(val) || "FFFFFF".equals(val)) {
                AttrManage.instance().setFontColor(attr, -16777216);
            } else {
                AttrManage.instance().setFontColor(attr, Color.parseColor((String)("#" + val)));
            }
        }
        if ((temp = rPr.element("b")) != null) {
            AttrManage.instance().setFontBold(attr, true);
        }
        if ((temp = rPr.element("i")) != null) {
            AttrManage.instance().setFontItalic(attr, true);
        }
        if ((u = rPr.element("u")) != null && (underlineType = u.attributeValue("val")) != null) {
            AttrManage.instance().setFontUnderline(attr, 1);
            val = u.attributeValue("color");
            if (val != null && val.length() > 0) {
                AttrManage.instance().setFontUnderlineColr(attr, Color.parseColor((String)("#" + val)));
            }
        }
        if ((temp = rPr.element("strike")) != null) {
            AttrManage.instance().setFontStrike(attr, !"0".equals(temp.attributeValue("val")));
        }
        if ((temp = rPr.element("dstrike")) != null) {
            AttrManage.instance().setFontDoubleStrike(attr, !"0".equals(temp.attributeValue("val")));
        }
        if ((s = rPr.element("vertAlign")) != null) {
            val = s.attributeValue("val");
            AttrManage.instance().setFontScript(attr, val.equals("superscript") ? 1 : 2);
        }
        if ((temp = rPr.element("rStyle")) != null && (val = temp.attributeValue("val")) != null && val.length() > 0) {
            AttrManage.instance().setParaStyleID(attr, this.styleStrID.get(val));
        }
        if ((temp = rPr.element("highlight")) != null) {
            AttrManage.instance().setFontHighLight(attr, FCKit.convertColor(temp.attributeValue("val")));
        }
    }

    private int processValue(String val, boolean isLeftRight) {
        int a;
        int n = a = isLeftRight ? 144 : 72;
        if (val != null) {
            a = ReaderKit.instance().isDecimal(val) ? (int)((float)Integer.parseInt(val) * 96.0f / 914400.0f * 15.0f) : (int)((float)Integer.parseInt(val, 16) * 96.0f / 914400.0f * 15.0f);
        }
        return a;
    }

    private void processParagraphs(List<Element> elems) {
        for (Element elem : elems) {
            if ("sdt".equals(elem.getName()) && (elem = elem.element("sdtContent")) != null) {
                this.processParagraphs(elem.elements());
            }
            if ("p".equals(elem.getName())) {
                this.processParagraph(elem, 0);
                continue;
            }
            if (!"tbl".equals(elem.getName())) continue;
            this.processTable(elem);
        }
    }

    private boolean hasTextbox2007(Element sp) {
        Element txbx = sp.element("textbox");
        if (txbx != null) {
            Element txbxContent = txbx.element("txbxContent");
            if (txbxContent != null) {
                return true;
            }
        } else if (sp.element("textpath") != null) {
            String context = sp.element("textpath").attributeValue("string");
            return context != null && context.length() > 0;
        }
        return false;
    }

    private boolean processTextbox2007(PackagePart packagePart, WPAutoShape wpShape, Element sp) {
        Element txbx = sp.element("textbox");
        if (txbx != null) {
            Element txbxContent = txbx.element("txbxContent");
            if (txbxContent != null) {
                long oldOffset = this.offset;
                this.offset = 0x5000000000000000L + (this.textboxIndex << 32);
                wpShape.setElementIndex((int)this.textboxIndex);
                SectionElement textboxElement = new SectionElement();
                textboxElement.setStartOffset(this.offset);
                this.wpdoc.appendElement(textboxElement, this.offset);
                this.processParagraphs(txbxContent.elements());
                IAttributeSet attr = textboxElement.getAttribute();
                AttrManage.instance().setPageWidth(attr, (int)((float)wpShape.getBounds().width * 15.0f));
                AttrManage.instance().setPageHeight(attr, (int)((float)wpShape.getBounds().height * 15.0f));
                int leftMargin = 144;
                int topMargin = 72;
                int rightMargin = 144;
                int bottomMargin = 72;
                String inset = txbx.attributeValue("inset");
                if (inset != null) {
                    String[] insets = inset.split(",");
                    if (insets.length > 0 && insets[0].length() > 0) {
                        leftMargin = Math.round(this.getValueInPt(insets[0], 1.0f) * 20.0f);
                    }
                    if (insets.length > 1 && insets[1].length() > 0) {
                        topMargin = Math.round(this.getValueInPt(insets[1], 1.0f) * 20.0f);
                    }
                    if (insets.length > 2 && insets[2].length() > 0) {
                        rightMargin = Math.round(this.getValueInPt(insets[2], 1.0f) * 20.0f);
                    }
                    if (insets.length > 3 && insets[3].length() > 0) {
                        bottomMargin = Math.round(this.getValueInPt(insets[3], 1.0f) * 20.0f);
                    }
                }
                AttrManage.instance().setPageMarginTop(attr, topMargin);
                AttrManage.instance().setPageMarginBottom(attr, bottomMargin);
                AttrManage.instance().setPageMarginLeft(attr, leftMargin);
                AttrManage.instance().setPageMarginRight(attr, rightMargin);
                String styleStr = sp.attributeValue("style");
                if (styleStr != null) {
                    String[] styles = styleStr.split(";");
                    for (int i = 0; i < styles.length; ++i) {
                        String[] temps = styles[i].split(":");
                        if (temps == null || temps[0] == null || temps[1] == null || "text-align".equalsIgnoreCase(temps[0])) continue;
                        if ("v-text-anchor".equalsIgnoreCase(temps[0])) {
                            if ("middle".equals(temps[1])) {
                                AttrManage.instance().setPageVerticalAlign(attr, (byte)1);
                                continue;
                            }
                            if ("bottom".equals(temps[1])) {
                                AttrManage.instance().setPageVerticalAlign(attr, (byte)2);
                                continue;
                            }
                            if (!"top".equals(temps[1])) continue;
                            AttrManage.instance().setPageVerticalAlign(attr, (byte)0);
                            continue;
                        }
                        if (!"mso-wrap-style".equalsIgnoreCase(temps[0])) continue;
                        wpShape.setTextWrapLine(!"none".equalsIgnoreCase(temps[1]));
                    }
                }
                wpShape.setElementIndex((int)this.textboxIndex);
                textboxElement.setEndOffset(this.offset);
                ++this.textboxIndex;
                this.offset = oldOffset;
                return true;
            }
        } else if (sp.element("textpath") != null) {
            String context = sp.element("textpath").attributeValue("string");
            wpShape.setBackgroundAndFill(null);
            long oldOffset = this.offset;
            this.offset = 0x5000000000000000L + (this.textboxIndex << 32);
            wpShape.setElementIndex((int)this.textboxIndex);
            SectionElement textboxElement = new SectionElement();
            textboxElement.setStartOffset(this.offset);
            this.wpdoc.appendElement(textboxElement, this.offset);
            ParagraphElement paraElem = new ParagraphElement();
            long t = this.offset;
            paraElem.setStartOffset(this.offset);
            LeafElement leaf = null;
            int len = context.length();
            if (len > 0) {
                leaf = new LeafElement(context);
                String val = sp.attributeValue("fillcolor");
                if (val != null && val.length() > 0) {
                    AttrManage.instance().setFontColor(leaf.getAttribute(), this.getColor(val, true));
                }
                float width = (float)wpShape.getBounds().getWidth() - 19.2f;
                float height = (float)wpShape.getBounds().getHeight() - 9.6f;
                int fontsize = 12;
                Paint paint = PaintKit.instance().getPaint();
                paint.setTextSize((float)fontsize);
                Paint.FontMetrics fm = paint.getFontMetrics();
                while ((float)((int)paint.measureText(context)) < width && (float)((int)Math.ceil(fm.descent - fm.ascent)) < height) {
                    paint.setTextSize((float)(++fontsize));
                    fm = paint.getFontMetrics();
                }
                AttrManage.instance().setFontSize(leaf.getAttribute(), (int)((float)(fontsize - 1) * 0.75f));
                leaf.setStartOffset(this.offset);
                this.offset += (long)len;
                leaf.setEndOffset(this.offset);
                paraElem.appendLeaf(leaf);
            }
            paraElem.setEndOffset(this.offset);
            if (this.offset > t) {
                this.wpdoc.appendParagraph(paraElem, this.offset);
            }
            IAttributeSet attr = textboxElement.getAttribute();
            AttrManage.instance().setPageWidth(attr, (int)((float)wpShape.getBounds().width * 15.0f));
            AttrManage.instance().setPageHeight(attr, (int)((float)wpShape.getBounds().height * 15.0f));
            AttrManage.instance().setPageMarginTop(attr, 72);
            AttrManage.instance().setPageMarginBottom(attr, 72);
            AttrManage.instance().setPageMarginLeft(attr, 144);
            AttrManage.instance().setPageMarginRight(attr, 144);
            String styleStr = sp.attributeValue("style");
            if (styleStr != null) {
                String[] styles = styleStr.split(";");
                for (int i = 0; i < styles.length; ++i) {
                    String[] temps = styles[i].split(":");
                    if (temps == null || temps[0] == null || temps[1] == null || "text-align".equalsIgnoreCase(temps[0])) continue;
                    if ("v-text-anchor".equalsIgnoreCase(temps[0])) {
                        if ("middle".equals(temps[1])) {
                            AttrManage.instance().setPageVerticalAlign(attr, (byte)1);
                            continue;
                        }
                        if ("bottom".equals(temps[1])) {
                            AttrManage.instance().setPageVerticalAlign(attr, (byte)2);
                            continue;
                        }
                        if (!"top".equals(temps[1])) continue;
                        AttrManage.instance().setPageVerticalAlign(attr, (byte)0);
                        continue;
                    }
                    if (!"mso-wrap-style".equalsIgnoreCase(temps[0])) continue;
                    wpShape.setTextWrapLine(!"none".equalsIgnoreCase(temps[1]));
                }
            }
            wpShape.setElementIndex((int)this.textboxIndex);
            textboxElement.setEndOffset(this.offset);
            ++this.textboxIndex;
            this.offset = oldOffset;
            return true;
        }
        return false;
    }

    private boolean hasTextbox2010(Element sp) {
        Element txbxContent;
        Element txbx = sp.element("txbx");
        return txbx != null && (txbxContent = txbx.element("txbxContent")) != null;
    }

    private boolean processTextbox2010(PackagePart packagePart, WPAutoShape wpShape, Element sp) {
        Element txbxContent;
        Element txbx = sp.element("txbx");
        if (txbx != null && (txbxContent = txbx.element("txbxContent")) != null) {
            long oldOffset = this.offset;
            this.offset = 0x5000000000000000L + (this.textboxIndex << 32);
            wpShape.setElementIndex((int)this.textboxIndex);
            SectionElement textboxElement = new SectionElement();
            textboxElement.setStartOffset(this.offset);
            this.wpdoc.appendElement(textboxElement, this.offset);
            List elems = txbxContent.elements();
            this.processParagraphs(elems);
            IAttributeSet attr = textboxElement.getAttribute();
            AttrManage.instance().setPageWidth(attr, (int)((float)wpShape.getBounds().width * 15.0f));
            AttrManage.instance().setPageHeight(attr, (int)((float)wpShape.getBounds().height * 15.0f));
            Element bodyPr = sp.element("bodyPr");
            if (bodyPr != null) {
                AttrManage.instance().setPageMarginTop(attr, this.processValue(bodyPr.attributeValue("tIns"), false));
                AttrManage.instance().setPageMarginBottom(attr, this.processValue(bodyPr.attributeValue("bIns"), false));
                AttrManage.instance().setPageMarginLeft(attr, this.processValue(bodyPr.attributeValue("lIns"), true));
                AttrManage.instance().setPageMarginRight(attr, this.processValue(bodyPr.attributeValue("rIns"), true));
                String val = bodyPr.attributeValue("anchor");
                if ("ctr".equals(val)) {
                    AttrManage.instance().setPageVerticalAlign(attr, (byte)1);
                } else if ("b".equals(val)) {
                    AttrManage.instance().setPageVerticalAlign(attr, (byte)2);
                } else if ("t".equals(val)) {
                    AttrManage.instance().setPageVerticalAlign(attr, (byte)0);
                }
                val = bodyPr.attributeValue("wrap");
                wpShape.setTextWrapLine(val == null || "square".equalsIgnoreCase(val));
                wpShape.setElementIndex((int)this.textboxIndex);
            }
            textboxElement.setEndOffset(this.offset);
            ++this.textboxIndex;
            this.offset = oldOffset;
            return true;
        }
        return false;
    }

    @Override
    public boolean searchContent(File file, String key) throws Exception {
        boolean isContain = false;
        this.zipPackage = new ZipPackage(this.filePath);
        PackageRelationship coreRel = this.zipPackage.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument").getRelationship(0);
        this.packagePart = this.zipPackage.getPart(coreRel);
        SAXReader saxreader = new SAXReader();
        InputStream in = this.packagePart.getInputStream();
        Document poiDoc = saxreader.read(in);
        Element root = poiDoc.getRootElement();
        Element body = root.element("body");
        StringBuilder sb = new StringBuilder();
        if (body != null) {
            List paras = body.elements("p");
            for (Element para : paras) {
                List runs = para.elements("r");
                for (Element run : runs) {
                    Element text = run.element("t");
                    if (text == null) continue;
                    sb.append(text.getText());
                }
                if (sb.indexOf(key) >= 0) {
                    isContain = true;
                    break;
                }
                sb.delete(0, sb.length());
            }
        }
        this.zipPackage = null;
        this.packagePart = null;
        in.close();
        return isContain;
    }

    private void processThemeColor() throws Exception {
        PackagePart themePart;
        PackageRelationship themeShip;
        if (this.packagePart != null && (themeShip = this.packagePart.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/theme").getRelationship(0)) != null && (themePart = this.zipPackage.getPart(themeShip.getTargetURI())) != null) {
            this.themeColor = ThemeReader.instance().getThemeColorMap(themePart);
            if (this.themeColor != null) {
                this.themeColor.put("bg1", this.themeColor.get("lt1"));
                this.themeColor.put("tx1", this.themeColor.get("dk1"));
                this.themeColor.put("bg2", this.themeColor.get("lt2"));
                this.themeColor.put("tx2", this.themeColor.get("dk2"));
            }
        }
    }

    private void processRelativeShapeSize() {
        int w = AttrManage.instance().getPageWidth(this.secElem.getAttribute());
        int h = AttrManage.instance().getPageHeight(this.secElem.getAttribute());
        for (IShape shape : this.relativeType) {
            int[] val = this.relativeValue.get(shape);
            Rectangle r = shape.getBounds();
            if (val[0] > 0) {
                r.width = (int)((float)w * 0.06666667f * (float)val[0] / 1000.0f);
            }
            if (val[2] <= 0) continue;
            r.height = (int)((float)h * 0.06666667f * (float)val[2] / 1000.0f);
        }
    }

    private byte getArrowType(String arrowType) {
        if ("block".equalsIgnoreCase(arrowType)) {
            return 1;
        }
        if ("classic".equalsIgnoreCase(arrowType)) {
            return 2;
        }
        if ("oval".equalsIgnoreCase(arrowType)) {
            return 4;
        }
        if ("diamond".equalsIgnoreCase(arrowType)) {
            return 3;
        }
        if ("open".equalsIgnoreCase(arrowType)) {
            return 5;
        }
        return 0;
    }

    private int getArrowWidth(String width) {
        if ("narrow".equalsIgnoreCase(width)) {
            return 0;
        }
        if ("wide".equalsIgnoreCase(width)) {
            return 2;
        }
        return 1;
    }

    private int getArrowLength(String length) {
        if ("short".equalsIgnoreCase(length)) {
            return 0;
        }
        if ("long".equalsIgnoreCase(length)) {
            return 2;
        }
        return 1;
    }

    @Override
    public void dispose() {
        if (this.isReaderFinish()) {
            this.filePath = null;
            this.zipPackage = null;
            this.wpdoc = null;
            this.packagePart = null;
            if (this.styleStrID != null) {
                this.styleStrID.clear();
                this.styleStrID = null;
            }
            if (this.tableGridCol != null) {
                this.tableGridCol.clear();
                this.tableGridCol = null;
            }
            this.tableGridCol = null;
            this.control = null;
            if (this.relativeType != null) {
                this.relativeType.clear();
                this.relativeType = null;
            }
            if (this.relativeValue != null) {
                this.relativeValue.clear();
                this.relativeValue = null;
            }
            if (this.bulletNumbersID != null) {
                this.bulletNumbersID.clear();
                this.bulletNumbersID = null;
            }
        }
    }

    class DOCXSaxHandler
    implements ElementHandler {
        DOCXSaxHandler() {
        }

        @Override
        public void onStart(ElementPath elementPath) {
        }

        @Override
        public void onEnd(ElementPath elementPath) {
            if (DOCXReader.this.abortReader) {
                throw new AbortReaderError("abort Reader");
            }
            Element elem = elementPath.getCurrent();
            String name = elem.getName();
            elem.elements();
            if ("p".equals(name)) {
                DOCXReader.this.processParagraph(elem, 0);
            }
            if ("sdt".equals(elem.getName())) {
                if ((elem = elem.element("sdtContent")) != null) {
                    DOCXReader.this.processParagraphs(elem.elements());
                }
            } else if ("tbl".equals(name)) {
                DOCXReader.this.processTable(elem);
            } else if ("pict".equals(name)) {
                ParagraphElement paraElem = new ParagraphElement();
                long t = DOCXReader.this.offset;
                paraElem.setStartOffset(DOCXReader.this.offset);
                DOCXReader.this.processPicture(elem, paraElem);
                paraElem.setEndOffset(DOCXReader.this.offset);
                if (DOCXReader.this.offset > t) {
                    DOCXReader.this.wpdoc.appendParagraph(paraElem, DOCXReader.this.offset);
                }
            }
            elem.detach();
        }
    }
}

