/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc.ddf;

import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherComplexProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherProperties;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.HexDump;
import com.ahmadullahpk.alldocumentreader.xs.fc.util.LittleEndian;

public final class EscherArrayProperty
extends EscherComplexProperty {
    private static final int FIXED_SIZE = 6;
    private boolean sizeIncludesHeaderSize = true;
    private boolean emptyComplexPart = false;

    public EscherArrayProperty(short id2, byte[] complexData) {
        super(id2, EscherArrayProperty.checkComplexData(complexData));
        this.emptyComplexPart = complexData.length == 0;
    }

    public EscherArrayProperty(short propertyNumber, boolean isBlipId, byte[] complexData) {
        super(propertyNumber, isBlipId, EscherArrayProperty.checkComplexData(complexData));
    }

    private static byte[] checkComplexData(byte[] complexData) {
        if (complexData == null || complexData.length == 0) {
            return new byte[6];
        }
        return complexData;
    }

    public int getNumberOfElementsInArray() {
        this._complexData = EscherArrayProperty.checkComplexData(this._complexData);
        return LittleEndian.getUShort(this._complexData, 0);
    }

    public void setNumberOfElementsInArray(int numberOfElements) {
        int expectedArraySize = numberOfElements * EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements()) + 6;
        if (expectedArraySize != this._complexData.length) {
            byte[] newArray = new byte[expectedArraySize];
            System.arraycopy(this._complexData, 0, newArray, 0, this._complexData.length);
            this._complexData = newArray;
        }
        LittleEndian.putShort(this._complexData, 0, (short)numberOfElements);
    }

    public int getNumberOfElementsInMemory() {
        this._complexData = EscherArrayProperty.checkComplexData(this._complexData);
        return LittleEndian.getUShort(this._complexData, 2);
    }

    public void setNumberOfElementsInMemory(int numberOfElements) {
        int expectedArraySize = numberOfElements * EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements()) + 6;
        if (expectedArraySize != this._complexData.length) {
            byte[] newArray = new byte[expectedArraySize];
            System.arraycopy(this._complexData, 0, newArray, 0, expectedArraySize);
            this._complexData = newArray;
        }
        LittleEndian.putShort(this._complexData, 2, (short)numberOfElements);
    }

    public short getSizeOfElements() {
        this._complexData = EscherArrayProperty.checkComplexData(this._complexData);
        return LittleEndian.getShort(this._complexData, 4);
    }

    public void setSizeOfElements(int sizeOfElements) {
        LittleEndian.putShort(this._complexData, 4, (short)sizeOfElements);
        int expectedArraySize = this.getNumberOfElementsInArray() * EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements()) + 6;
        if (expectedArraySize != this._complexData.length) {
            byte[] newArray = new byte[expectedArraySize];
            System.arraycopy(this._complexData, 0, newArray, 0, 6);
            this._complexData = newArray;
        }
    }

    public byte[] getElement(int index) {
        byte[] result;
        int actualSize = EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements());
        int srcPos = 6 + index * actualSize;
        if (srcPos + (result = new byte[actualSize]).length <= this._complexData.length) {
            System.arraycopy(this._complexData, srcPos, result, 0, result.length);
        }
        return result;
    }

    public void setElement(int index, byte[] element) {
        int actualSize = EscherArrayProperty.getActualSizeOfElements(this.getSizeOfElements());
        System.arraycopy(element, 0, this._complexData, 6 + index * actualSize, actualSize);
    }

    @Override
    public String toString() {
        StringBuffer results = new StringBuffer();
        results.append("    {EscherArrayProperty:\n");
        results.append("     Num Elements: " + this.getNumberOfElementsInArray() + '\n');
        results.append("     Num Elements In Memory: " + this.getNumberOfElementsInMemory() + '\n');
        results.append("     Size of elements: " + this.getSizeOfElements() + '\n');
        for (int i = 0; i < this.getNumberOfElementsInArray(); ++i) {
            results.append("     Element " + i + ": " + HexDump.toHex(this.getElement(i)) + '\n');
        }
        results.append("}\n");
        return "propNum: " + this.getPropertyNumber() + ", propName: " + EscherProperties.getPropertyName(this.getPropertyNumber()) + ", complex: " + this.isComplex() + ", blipId: " + this.isBlipId() + ", data: " + '\n' + results.toString();
    }

    public int setArrayData(byte[] data, int offset) {
        if (this.emptyComplexPart) {
            this._complexData = new byte[0];
        } else {
            short numElements = LittleEndian.getShort(data, offset);
            LittleEndian.getShort(data, offset + 2);
            short sizeOfElements = LittleEndian.getShort(data, offset + 4);
            int arraySize = EscherArrayProperty.getActualSizeOfElements(sizeOfElements) * numElements;
            if (arraySize == this._complexData.length) {
                this._complexData = new byte[arraySize + 6];
                this.sizeIncludesHeaderSize = false;
            }
            System.arraycopy(data, offset, this._complexData, 0, this._complexData.length);
        }
        return this._complexData.length;
    }

    @Override
    public int serializeSimplePart(byte[] data, int pos) {
        LittleEndian.putShort(data, pos, this.getId());
        int recordSize = this._complexData.length;
        if (!this.sizeIncludesHeaderSize) {
            recordSize -= 6;
        }
        LittleEndian.putInt(data, pos + 2, recordSize);
        return 6;
    }

    public static int getActualSizeOfElements(short sizeOfElements) {
        if (sizeOfElements < 0) {
            return (short)(-sizeOfElements >> 2);
        }
        return sizeOfElements;
    }
}

