/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc;

import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.AutoShapeDataKit;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.Gradient;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.LinearGradientShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.RadialGradientShader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.TileShader;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.Picture;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.ReaderKit;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGMaster;
import java.util.List;
import java.util.Map;

public class ShaderKit {
    public static Gradient readGradient(PGMaster master, Element gradFill) {
        Element gsLstElement = gradFill.element("gsLst");
        List gsLst = gsLstElement.elements("gs");
        if (gsLst == null || gsLst.size() == 0) {
            return null;
        }
        int gsCnt = gsLst.size();
        int[] colors = new int[gsCnt];
        float[] positions = new float[gsCnt];
        for (int i = 0; i < gsCnt; ++i) {
            Element gs = (Element)gsLst.get(i);
            String pos = gs.attributeValue("pos");
            positions[i] = (float)Integer.parseInt(pos) / 100000.0f;
            colors[i] = ReaderKit.instance().getColor(master, gs);
        }
        Element ele = gradFill.element("lin");
        if (ele != null) {
            float angle = Integer.parseInt(ele.attributeValue("ang")) / 60000;
            return new LinearGradientShader(angle, colors, positions);
        }
        ele = gradFill.element("path");
        if (ele != null) {
            byte type = ShaderKit.getGradientType(gradFill);
            int radialCenterType = ShaderKit.getRadialCenterType(ele.element("fillToRect"));
            if (type == 4 || type == 5 || type == 6) {
                return new RadialGradientShader(radialCenterType, colors, positions);
            }
        }
        return null;
    }

    public static Gradient readGradient(Map<String, Integer> schemeColor, Element gradFill) {
        Element gsLstElement = gradFill.element("gsLst");
        List gsLst = gsLstElement.elements("gs");
        if (gsLst == null || gsLst.size() == 0) {
            return null;
        }
        int gsCnt = gsLst.size();
        int[] colors = new int[gsCnt];
        float[] positions = new float[gsCnt];
        for (int i = 0; i < gsCnt; ++i) {
            Element gs = (Element)gsLst.get(i);
            String pos = gs.attributeValue("pos");
            positions[i] = (float)Integer.parseInt(pos) / 100000.0f;
            colors[i] = AutoShapeDataKit.getColor(schemeColor, gs);
        }
        Element ele = gradFill.element("lin");
        if (ele != null) {
            float angle = Integer.parseInt(ele.attributeValue("ang")) / 60000;
            return new LinearGradientShader(angle, colors, positions);
        }
        ele = gradFill.element("path");
        if (ele != null) {
            byte type = ShaderKit.getGradientType(gradFill);
            int radialCenterType = ShaderKit.getRadialCenterType(ele.element("fillToRect"));
            if (type == 4 || type == 5 || type == 6) {
                return new RadialGradientShader(radialCenterType, colors, positions);
            }
        } else {
            return new LinearGradientShader(270.0f, colors, positions);
        }
        return null;
    }

    public static byte getGradientType(Element gradFill) {
        Element ele = gradFill.element("lin");
        if (ele != null) {
            return 7;
        }
        ele = gradFill.element("path");
        if (ele != null) {
            String path = ele.attributeValue("path");
            if ("circle".equalsIgnoreCase(path)) {
                return 4;
            }
            if ("rect".equalsIgnoreCase(path)) {
                return 5;
            }
            if ("shape".equalsIgnoreCase(path)) {
                return 6;
            }
        }
        return 7;
    }

    private static int getRadialCenterType(Element fillToRect) {
        if (fillToRect != null) {
            String l = fillToRect.attributeValue("l");
            String t = fillToRect.attributeValue("t");
            String r = fillToRect.attributeValue("r");
            String b = fillToRect.attributeValue("b");
            if ("100000".equalsIgnoreCase(r) && "100000".equalsIgnoreCase(b)) {
                return 0;
            }
            if ("100000".equalsIgnoreCase(l) && "100000".equalsIgnoreCase(b)) {
                return 1;
            }
            if ("100000".equalsIgnoreCase(r) && "100000".equalsIgnoreCase(t)) {
                return 2;
            }
            if ("100000".equalsIgnoreCase(l) && "100000".equalsIgnoreCase(t)) {
                return 3;
            }
            if ("50000".equalsIgnoreCase(l) && "50000".equalsIgnoreCase(t) && "50000".equalsIgnoreCase(r) && "50000".equalsIgnoreCase(b)) {
                return 4;
            }
        }
        return 0;
    }

    public static TileShader readTile(Picture picture, Element tile) {
        int flip = ShaderKit.getFlipType(tile.attributeValue("flip"));
        float horiRatio = (float)Integer.parseInt(tile.attributeValue("sx")) / 100000.0f;
        float vertRatio = (float)Integer.parseInt(tile.attributeValue("sy")) / 100000.0f;
        int offsetX = Math.round((float)Integer.parseInt(tile.attributeValue("tx")) * 96.0f / 914400.0f);
        int offsetY = Math.round((float)Integer.parseInt(tile.attributeValue("ty")) * 96.0f / 914400.0f);
        return new TileShader(picture, flip, horiRatio, vertRatio, offsetX, offsetY);
    }

    private static int getFlipType(String flip) {
        if ("x".equalsIgnoreCase(flip)) {
            return 1;
        }
        if ("y".equalsIgnoreCase(flip)) {
            return 2;
        }
        if ("xy".equalsIgnoreCase(flip)) {
            return 3;
        }
        return 0;
    }
}

