/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.fc;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Rect;
import com.ahmadullahpk.alldocumentreader.xs.fc.fs.filesystem.CFBFileSystem;
import com.ahmadullahpk.alldocumentreader.xs.fc.fs.filesystem.Property;
import com.ahmadullahpk.alldocumentreader.xs.fc.fs.storage.LittleEndian;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackagePart;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.PackageRelationship;
import com.ahmadullahpk.alldocumentreader.xs.fc.openxml4j.opc.ZipPackage;
import com.ahmadullahpk.alldocumentreader.xs.fc.pdf.PDFLib;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.PPTReader;
import com.ahmadullahpk.alldocumentreader.xs.java.awt.Dimension;
import com.ahmadullahpk.alldocumentreader.xs.pg.control.PGEditor;
import com.ahmadullahpk.alldocumentreader.xs.pg.model.PGModel;
import com.ahmadullahpk.alldocumentreader.xs.pg.view.SlideDrawKit;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;

public class ReaderThumbnail {
    private static ReaderThumbnail kit = new ReaderThumbnail();

    public static ReaderThumbnail instance() {
        return kit;
    }

    public Bitmap getThumbnailForPPT(String filePath, int width, int height) throws Exception {
        FileInputStream fis = new FileInputStream(new File(filePath));
        CFBFileSystem poifs = new CFBFileSystem(fis, true);
        Property property = poifs.getProperty("\u0005SummaryInformation");
        if (property != null) {
            byte[] data = property.getDocumentRawData();
            int offset = 0;
            int byteOrder = LittleEndian.getUShort(data, offset);
            int format = LittleEndian.getUShort(data, offset += 2);
            int osVersion = (int)LittleEndian.getUInt(data, offset += 2);
            offset += 4;
            int sectionCount = LittleEndian.getInt(data, offset += 16);
            offset += 4;
            if (sectionCount < 0) {
                return null;
            }
            for (int i = 0; i < sectionCount; ++i) {
                Bitmap thumbnail = this.readSection(data, offset, width, height);
                if (thumbnail != null) {
                    return thumbnail;
                }
                offset += 20;
            }
        }
        return null;
    }

    private Bitmap readSection(byte[] data, int offset, int width, int height) {
        int section_offset;
        int read_off = offset;
        read_off += 16;
        read_off = section_offset = (int)LittleEndian.getUInt(data, read_off);
        int size = (int)LittleEndian.getUInt(data, read_off);
        int propertyCount = (int)LittleEndian.getUInt(data, read_off += 4);
        int pro_off = read_off += 4;
        int propertyID = -1;
        int propertyOffset = 0;
        for (int i = 0; i < propertyCount; ++i) {
            propertyID = (int)LittleEndian.getUInt(data, pro_off);
            propertyOffset = (int)LittleEndian.getUInt(data, pro_off += 4);
            pro_off += 4;
            if (propertyID == 17) break;
        }
        if (propertyID == 17) {
            int tOffset = propertyOffset + section_offset;
            int type = (int)LittleEndian.getUInt(data, tOffset);
            int tSize = (int)LittleEndian.getUInt(data, tOffset += 4);
            int osType = (int)LittleEndian.getUInt(data, tOffset += 4);
            int picType = (int)LittleEndian.getUInt(data, tOffset += 4);
            tOffset += 4;
            if (osType == -1) {
                int pic_data_offset = propertyOffset + section_offset;
                if (picType == 3) {
                    pic_data_offset += 24;
                } else if (picType == 14 || picType == 819) {
                    // empty if block
                }
                if (pic_data_offset > propertyOffset + section_offset) {
                    try {
                        if (picType != 3 && picType == 819) {
                            return BitmapFactory.decodeByteArray((byte[])data, (int)pic_data_offset, (int)(data.length - pic_data_offset));
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        }
        return null;
    }

    private Bitmap getThumbnailForPPT_Small(String filePath, int width, int height) {
        try {
            PPTReader reader = new PPTReader(null, filePath, true);
            PGModel model = (PGModel)reader.getModel();
            if (model != null) {
                Dimension d = model.getPageSize();
                float zoom = (float)Math.min((double)width / d.getWidth(), (double)height / d.getHeight());
                PGEditor editor = new PGEditor(null);
                Bitmap bitmap = SlideDrawKit.instance().getThumbnail(model, editor, model.getSlide(0), zoom);
                return bitmap;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Bitmap getThumbnailForPPTX(String filePath) throws Exception {
        ZipPackage zipPackage = new ZipPackage(filePath);
        PackageRelationship thumbnail = zipPackage.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/metadata/thumbnail").getRelationship(0);
        if (thumbnail == null) {
            return null;
        }
        PackagePart part = zipPackage.getPart(thumbnail.getTargetURI());
        if (part == null) {
            return null;
        }
        return BitmapFactory.decodeStream((InputStream)part.getInputStream());
    }

    public Bitmap getThumbnailForPDF(String filePath, float zoom) throws Exception {
        try {
            PDFLib lib = PDFLib.getPDFLib();
            lib.openFileSync(filePath);
            if (lib.hasPasswordSync()) {
                return null;
            }
            Rect rect = lib.getAllPagesSize()[0];
            int w = (int)((float)rect.width() * zoom);
            int h = (int)((float)rect.height() * zoom);
            Bitmap bitmap = null;
            try {
                bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                lib.drawPageSync(bitmap, 0, w, h, 0, 0, w, h, 1);
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
            return bitmap;
        }
        catch (Exception e) {
            return null;
        }
    }
}

