/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.pictureefftect;

import android.graphics.Color;
import com.ahmadullahpk.alldocumentreader.xs.common.pictureefftect.PictureCroppedInfo;
import com.ahmadullahpk.alldocumentreader.xs.common.pictureefftect.PictureEffectInfo;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherOptRecord;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.ddf.EscherSimpleProperty;
import com.ahmadullahpk.alldocumentreader.xs.fc.dom4j.Element;
import com.ahmadullahpk.alldocumentreader.xs.fc.hwpf.usermodel.Picture;
import com.ahmadullahpk.alldocumentreader.xs.fc.ppt.reader.ReaderKit;

public class PictureEffectInfoFactory {
    public static PictureEffectInfo getPictureEffectInfor(Element blipFill) {
        Element blip;
        if (blipFill == null) {
            return null;
        }
        PictureEffectInfo effectInfor = new PictureEffectInfo();
        boolean validateInfor = false;
        Element e = blipFill.element("srcRect");
        String value = null;
        if (e != null) {
            float left = 0.0f;
            value = e.attributeValue("l");
            if (value != null) {
                left = (float)Integer.parseInt(value) / 100000.0f;
            }
            float top = 0.0f;
            value = e.attributeValue("t");
            if (value != null) {
                top = (float)Integer.parseInt(value) / 100000.0f;
            }
            float right = 0.0f;
            value = e.attributeValue("r");
            if (value != null) {
                right = (float)Integer.parseInt(value) / 100000.0f;
            }
            float bottom = 0.0f;
            value = e.attributeValue("b");
            if (value != null) {
                bottom = (float)Integer.parseInt(value) / 100000.0f;
            }
            if (left != 0.0f || top != 0.0f || right != 0.0f || bottom != 0.0f) {
                PictureCroppedInfo croppedInfor = new PictureCroppedInfo(left, top, right, bottom);
                validateInfor = true;
                effectInfor.setPictureCroppedInfor(croppedInfor);
            }
        }
        if ((blip = blipFill.element("blip")).element("grayscl") != null) {
            validateInfor = true;
            effectInfor.setGrayScale(true);
        }
        if ((e = blip.element("biLevel")) != null && (value = e.attributeValue("thresh")) != null) {
            validateInfor = true;
            effectInfor.setBlackWhiteThreshold((float)Integer.parseInt(value) / 100000.0f * 255.0f);
        }
        if ((e = blip.element("lum")) != null) {
            value = e.attributeValue("bright");
            if (value != null) {
                validateInfor = true;
                float b = (float)Integer.parseInt(value) / 100000.0f;
                effectInfor.setBrightness(b * 255.0f);
            }
            if ((value = e.attributeValue("contrast")) != null) {
                validateInfor = true;
                float c = (float)Integer.parseInt(value) / 100000.0f;
                if (c > 0.0f) {
                    effectInfor.setContrast(1.0f + c * 9.0f);
                } else {
                    effectInfor.setContrast(1.0f + c);
                }
            }
        }
        if ((e = blip.element("clrChange")) != null && (e = e.element("clrFrom")) != null) {
            validateInfor = true;
            effectInfor.setTransparentColor(ReaderKit.instance().getColor(null, e));
        }
        if (validateInfor) {
            return effectInfor;
        }
        return null;
    }

    public static PictureEffectInfo getPictureEffectInfor_ImageData(Element imagedata) {
        if (imagedata != null) {
            String chromakey;
            String grayscale;
            PictureEffectInfo effectInfor = new PictureEffectInfo();
            boolean validateInfor = false;
            float left = 0.0f;
            String value = imagedata.attributeValue("cropleft");
            if (value != null) {
                left = Float.parseFloat(value) / 65535.0f;
            }
            value = imagedata.attributeValue("croptop");
            float top = 0.0f;
            if (value != null) {
                top = Float.parseFloat(value) / 65535.0f;
            }
            value = imagedata.attributeValue("cropright");
            float right = 0.0f;
            if (value != null) {
                right = Float.parseFloat(value) / 65535.0f;
            }
            value = imagedata.attributeValue("cropbottom");
            float bottom = 0.0f;
            if (value != null) {
                bottom = Float.parseFloat(value) / 65535.0f;
            }
            if (left != 0.0f || top != 0.0f || right != 0.0f || bottom != 0.0f) {
                PictureCroppedInfo croppedInfor = new PictureCroppedInfo(left, top, right, bottom);
                validateInfor = true;
                effectInfor.setPictureCroppedInfor(croppedInfor);
            }
            if ((value = imagedata.attributeValue("blacklevel")) != null) {
                validateInfor = true;
                float blacklevel = 0.0f;
                blacklevel = value.contains("f") ? Float.parseFloat(value) / 65535.0f * 2.0f : Float.parseFloat(value) * 2.0f;
                effectInfor.setBrightness(blacklevel * 255.0f);
            }
            if ((value = imagedata.attributeValue("gain")) != null) {
                validateInfor = true;
                float gain = 0.0f;
                gain = value.contains("f") ? Float.parseFloat(value) / 65535.0f : Float.parseFloat(value);
                effectInfor.setContrast(gain);
            }
            if ((grayscale = imagedata.attributeValue("grayscale")) != null && (grayscale.equalsIgnoreCase("t") || grayscale.equalsIgnoreCase("true"))) {
                validateInfor = true;
                String bilevel = imagedata.attributeValue("bilevel");
                if (bilevel != null && (bilevel.equalsIgnoreCase("t") || bilevel.equalsIgnoreCase("true"))) {
                    effectInfor.setBlackWhiteThreshold(128.0f);
                } else {
                    effectInfor.setGrayScale(true);
                }
            }
            if ((chromakey = imagedata.attributeValue("chromakey")) != null) {
                validateInfor = true;
                effectInfor.setTransparentColor(Color.parseColor((String)chromakey));
            }
            if (validateInfor) {
                return effectInfor;
            }
        }
        return null;
    }

    public static EscherProperty getEscherProperty(EscherOptRecord opt, int propId) {
        if (opt != null) {
            for (EscherProperty prop : opt.getEscherProperties()) {
                if (prop.getPropertyNumber() != propId) continue;
                return prop;
            }
        }
        return null;
    }

    public static PictureEffectInfo getPictureEffectInfor(Picture pic) {
        if (pic == null) {
            return null;
        }
        PictureEffectInfo effectInfor = new PictureEffectInfo();
        boolean validateInfor = false;
        Object value = null;
        float left = pic.getDxaCropLeft();
        float top = pic.getDyaCropTop();
        float right = pic.getDxaCropRight();
        float bottom = pic.getDyaCropBottom();
        if (left != 0.0f || top != 0.0f || right != 0.0f || bottom != 0.0f) {
            PictureCroppedInfo croppedInfor = new PictureCroppedInfo(left, top, right, bottom);
            validateInfor = true;
            effectInfor.setPictureCroppedInfor(croppedInfor);
        }
        if (pic.isSetBright()) {
            validateInfor = true;
            effectInfor.setBrightness(pic.getBright());
        }
        if (pic.isSetContrast()) {
            validateInfor = true;
            effectInfor.setContrast(pic.getContrast());
        }
        if (pic.isSetGrayScl()) {
            validateInfor = true;
            effectInfor.setGrayScale(true);
        }
        if (pic.isSetThreshold()) {
            validateInfor = true;
            effectInfor.setBlackWhiteThreshold(pic.getThreshold());
        }
        if (validateInfor) {
            return effectInfor;
        }
        return null;
    }

    public static PictureEffectInfo getPictureEffectInfor(EscherOptRecord opt) {
        float bottom;
        if (opt == null) {
            return null;
        }
        PictureEffectInfo effectInfor = new PictureEffectInfo();
        boolean validateInfor = false;
        Object value = null;
        EscherSimpleProperty prop = (EscherSimpleProperty)PictureEffectInfoFactory.getEscherProperty(opt, 258);
        float left = prop == null ? 0.0f : (float)prop.getPropertyValue() / 65536.0f;
        prop = (EscherSimpleProperty)PictureEffectInfoFactory.getEscherProperty(opt, 256);
        float top = prop == null ? 0.0f : (float)prop.getPropertyValue() / 65536.0f;
        prop = (EscherSimpleProperty)PictureEffectInfoFactory.getEscherProperty(opt, 259);
        float right = prop == null ? 0.0f : (float)prop.getPropertyValue() / 65536.0f;
        prop = (EscherSimpleProperty)PictureEffectInfoFactory.getEscherProperty(opt, 257);
        float f = bottom = prop == null ? 0.0f : (float)prop.getPropertyValue() / 65536.0f;
        if (left != 0.0f || top != 0.0f || right != 0.0f || bottom != 0.0f) {
            PictureCroppedInfo croppedInfor = new PictureCroppedInfo(left, top, right, bottom);
            validateInfor = true;
            effectInfor.setPictureCroppedInfor(croppedInfor);
        }
        if ((prop = (EscherSimpleProperty)PictureEffectInfoFactory.getEscherProperty(opt, 319)) != null) {
            int propValue = prop.getPropertyValue() & 0xF;
            if (propValue == 4) {
                validateInfor = true;
                effectInfor.setGrayScale(true);
            } else if (propValue == 6) {
                validateInfor = true;
                effectInfor.setBlackWhiteThreshold(128.0f);
            }
        }
        if ((prop = (EscherSimpleProperty)PictureEffectInfoFactory.getEscherProperty(opt, 265)) != null) {
            validateInfor = true;
            effectInfor.setBrightness((float)prop.getPropertyValue() / 32768.0f * 255.0f);
        }
        if ((prop = (EscherSimpleProperty)PictureEffectInfoFactory.getEscherProperty(opt, 264)) != null) {
            validateInfor = true;
            effectInfor.setContrast(Math.min((float)prop.getPropertyValue() / 65536.0f, 10.0f));
        }
        if ((prop = (EscherSimpleProperty)PictureEffectInfoFactory.getEscherProperty(opt, 263)) != null) {
            validateInfor = true;
            int color2 = prop.getPropertyValue();
            int r = color2 & 0xFF;
            int g = (color2 & 0xFF00) >> 8;
            int b = (color2 & 0xFF0000) >> 16;
            effectInfor.setTransparentColor(Color.rgb((int)r, (int)g, (int)b));
        }
        if (validateInfor) {
            return effectInfor;
        }
        return null;
    }
}

