/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.bulletnumber;

import com.ahmadullahpk.alldocumentreader.xs.common.bulletnumber.ListData;
import com.ahmadullahpk.alldocumentreader.xs.common.bulletnumber.ListLevel;
import com.ahmadullahpk.alldocumentreader.xs.simpletext.view.DocAttr;

public class ListKit {
    private static final char[] ENGLISH_LETTERS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final String[] ROMAN_LETTERS = new String[]{"m", "cm", "d", "cd", "c", "xc", "l", "xl", "x", "ix", "v", "iv", "i"};
    private static final int[] ROMAN_VALUES = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    private static final char[] CN_SIMPLIFIED = new char[]{'\u96f6', '\u58f9', '\u8d30', '\u53c1', '\u8086', '\u4f0d', '\u9646', '\u67d2', '\u634c', '\u7396'};
    private static final char[] CN_SIMPLIFIED_SERIES = new char[]{'\u62fe', '\u4f70', '\u4edf', '\u842c'};
    private static final char[] CN_THOUSAND = new char[]{'\u3007', '\u4e00', '\u4e8c', '\u4e09', '\u56db', '\u4e94', '\u516d', '\u4e03', '\u516b', '\u4e5d', '\u5341'};
    private static final char[] CN_THOUSAND_SERIES = new char[]{'\u5341', '\u767e', '\u5343', '\u4e07'};
    private static final String[] TRADITIONAL = new String[]{"\u7532", "\u4e59", "\u4e19", "\u4e01", "\u620a", "\u5df1", "\u5e9a", "\u8f9b", "\u58ec", "\u7678"};
    private static final String[] ZODIAC = new String[]{"\u5b50", "\u4e11", "\u5bc5", "\u536f", "\u8fb0", "\u5df3", "\u5348", "\u672a", "\u7533", "\u9149", "\u620c", "\u4ea5"};
    private static ListKit kit = new ListKit();

    public static ListKit instance() {
        return kit;
    }

    public String getNumberStr(int num, int style2) {
        switch (style2) {
            case 1: {
                return this.getRoman(num).toUpperCase();
            }
            case 2: {
                return this.getRoman(num);
            }
            case 3: {
                return this.getLetters(num).toUpperCase();
            }
            case 4: {
                return this.getLetters(num);
            }
            case 5: {
                return this.getOrdinal(num);
            }
            case 6: {
                return this.getCardinalText(num);
            }
            case 22: {
                return (num < 10 ? "0" : "") + String.valueOf(num);
            }
            case 30: {
                return num <= 10 ? TRADITIONAL[num - 1] : String.valueOf(num);
            }
            case 31: {
                return num <= 12 ? ZODIAC[num - 1] : String.valueOf(num);
            }
            case 38: {
                return this.getChineseLegalSimplified(num);
            }
            case 39: {
                return this.getChineseCountingThousand(num);
            }
        }
        return String.valueOf(num);
    }

    public String getLetters(int number) {
        int base = 26;
        if (number <= 0 || number > 780) {
            return String.valueOf(ENGLISH_LETTERS[0]);
        }
        if (number <= 26) {
            return String.valueOf(ENGLISH_LETTERS[number - 1]);
        }
        StringBuilder sb = new StringBuilder();
        int t = number / 26;
        int mod = number % 26;
        mod = mod == 0 ? 26 : mod;
        for (int i = 0; i < t; ++i) {
            sb.append(ENGLISH_LETTERS[mod - 1]);
        }
        return sb.toString();
    }

    public String getRoman(int number) {
        if (number <= 0) {
            return ROMAN_LETTERS[ROMAN_LETTERS.length - 1];
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < ROMAN_LETTERS.length; ++i) {
            String letter = ROMAN_LETTERS[i];
            int value = ROMAN_VALUES[i];
            while (number >= value) {
                number -= value;
                sb.append(letter);
            }
        }
        return sb.toString();
    }

    public String getChineseLegalSimplified(int number) {
        if (number <= 0 || number > 99999) {
            return String.valueOf(CN_SIMPLIFIED[0]);
        }
        if (number <= 9) {
            return String.valueOf(CN_SIMPLIFIED[number]);
        }
        StringBuilder sb = new StringBuilder();
        String numStr = String.valueOf(number);
        int len = numStr.length();
        boolean isAddZero = false;
        for (int i = 0; i < len; ++i) {
            int t = numStr.charAt(i) - 48;
            if (t > 0) {
                sb.append(CN_SIMPLIFIED[t]);
                if (len - i - 2 >= 0) {
                    sb.append(CN_SIMPLIFIED_SERIES[len - i - 2]);
                }
                isAddZero = true;
                continue;
            }
            if (!isAddZero || i == len - 1) continue;
            sb.append(CN_SIMPLIFIED[0]);
            isAddZero = false;
        }
        if (sb.charAt(sb.length() - 1) == CN_SIMPLIFIED[0]) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public String getChineseCountingThousand(int number) {
        if (number <= 0 || number > 99999) {
            return String.valueOf(CN_THOUSAND[0]);
        }
        if (number <= 9) {
            return String.valueOf(CN_THOUSAND[number]);
        }
        StringBuilder sb = new StringBuilder();
        String numStr = String.valueOf(number);
        int len = numStr.length();
        boolean isAddZero = false;
        for (int i = 0; i < len; ++i) {
            int t = numStr.charAt(i) - 48;
            if (t > 0) {
                sb.append(CN_THOUSAND[t]);
                if (len - i - 2 >= 0) {
                    sb.append(CN_THOUSAND_SERIES[len - i - 2]);
                }
                isAddZero = true;
                continue;
            }
            if (!isAddZero || i == len - 1) continue;
            sb.append(CN_THOUSAND[0]);
            isAddZero = false;
        }
        if (sb.charAt(sb.length() - 1) == CN_THOUSAND[0]) {
            sb.deleteCharAt(sb.length() - 1);
        }
        if (number > 10 && number < 20 && sb.charAt(0) == CN_THOUSAND[1]) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public String getOrdinal(int number) {
        int t = number % 10;
        String suff = "";
        suff = t == 1 ? "st" : (t == 2 ? "nd" : (t == 3 ? "rd" : "th"));
        return String.valueOf(number) + suff;
    }

    public String getBulletText(ListData listData, ListLevel listLevel, DocAttr docAttr, int currentLevel) {
        char[] xst;
        if (listLevel.getNumberText() == null) {
            return "";
        }
        StringBuffer bulletBuffer = new StringBuffer();
        for (char ch : xst = listLevel.getNumberText()) {
            if (ch >= '\u0000' && ch < '\t') {
                ListLevel numLevel = listData.getLevel(ch);
                int num = numLevel.getStartAt() + (docAttr.rootType == 1 ? numLevel.getNormalParaCount() : numLevel.getParaCount());
                if (ch < currentLevel && num > numLevel.getStartAt()) {
                    --num;
                }
                bulletBuffer.append(this.getNumberStr(num, numLevel.getNumberFormat()));
                continue;
            }
            bulletBuffer.append(ch);
        }
        byte follow = listLevel.getFollowChar();
        switch (follow) {
            case 1: {
                bulletBuffer.append(" ");
                break;
            }
        }
        return bulletBuffer.toString();
    }

    public String getCardinalText(int num) {
        String numberStr;
        String lStr = numberStr = String.valueOf(num);
        String lStrRev = this.reverseString(lStr);
        String[] a = new String[5];
        switch (lStrRev.length() % 3) {
            case 1: {
                lStrRev = lStrRev + "00";
                break;
            }
            case 2: {
                lStrRev = lStrRev + "0";
                break;
            }
        }
        String StrInt = "";
        for (int i = 0; i <= lStrRev.length() / 3 - 1; ++i) {
            a[i] = this.reverseString(lStrRev.substring(3 * i, 3 * i + 3));
            if (!a[i].equals("000")) {
                if (i != 0) {
                    StrInt = this.w3(a[i]) + " " + this.dw(String.valueOf(i)) + " " + StrInt;
                    continue;
                }
                StrInt = this.w3(a[i]);
                continue;
            }
            StrInt = this.w3(a[i]) + StrInt;
        }
        return this.toUpperCaseFirstOne(StrInt);
    }

    private String reverseString(String str) {
        int i;
        int lenInt = str.length();
        String[] z = new String[str.length()];
        for (i = 0; i < lenInt; ++i) {
            z[i] = str.substring(i, i + 1);
        }
        str = "";
        for (i = lenInt - 1; i >= 0; --i) {
            str = str + z[i];
        }
        return str;
    }

    private String zr4(String y) {
        String[] z = new String[]{"", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
        return z[Integer.parseInt(y.substring(0, 1))];
    }

    private String zr3(String y) {
        String[] z = new String[]{"", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine"};
        return z[Integer.parseInt(y.substring(2, 3))];
    }

    private String zr2(String y) {
        String[] z = new String[20];
        z[10] = "ten";
        z[11] = "eleven";
        z[12] = "twelve";
        z[13] = "thirteen";
        z[14] = "fourteen";
        z[15] = "fifteen";
        z[16] = "sixteen";
        z[17] = "seventeen";
        z[18] = "eighteen";
        z[19] = "nineteen";
        return z[Integer.parseInt(y.substring(1, 3))];
    }

    private String zr1(String y) {
        String[] z = new String[10];
        z[1] = "ten";
        z[2] = "twenty";
        z[3] = "thirty";
        z[4] = "forty";
        z[5] = "fifty";
        z[6] = "sixty";
        z[7] = "seventy";
        z[8] = "eighty";
        z[9] = "ninety";
        return z[Integer.parseInt(y.substring(1, 2))];
    }

    private String dw(String y) {
        String[] z = new String[5];
        z[0] = "";
        z[1] = "thousand";
        z[2] = "million";
        z[3] = "billion";
        return z[Integer.parseInt(y)];
    }

    private String w2(String y) {
        String tempstr = y.substring(1, 2).equals("0") ? this.zr3(y) : (y.substring(1, 2).equals("1") ? this.zr2(y) : (y.substring(2, 3).equals("0") ? this.zr1(y) : this.zr1(y) + "-" + this.zr3(y)));
        return tempstr;
    }

    private String w3(String y) {
        String tempstr = y.substring(0, 1).equals("0") ? this.w2(y) : (y.substring(1, 3).equals("00") ? this.zr4(y) + " hundred" : this.zr4(y) + " hundred " + this.w2(y));
        return tempstr;
    }

    public String toUpperCaseFirstOne(String s) {
        if (s.equals("")) {
            return String.valueOf(0);
        }
        return Character.toUpperCase(s.charAt(0)) + s.substring(1);
    }
}

