/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.bg;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapShader;
import android.graphics.Rect;
import android.graphics.Shader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.AShader;
import com.ahmadullahpk.alldocumentreader.xs.common.picture.Picture;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;
import java.io.FileInputStream;
import java.io.InputStream;

public class TileShader
extends AShader {
    public static final int Flip_None = 0;
    public static final int Flip_Horizontal = 1;
    public static final int Flip_Vertical = 2;
    public static final int Flip_Both = 3;
    private Picture picture;
    private int flip;
    private float horiRatio;
    private float vertRatio;
    private int offsetX;
    private int offsetY;

    public TileShader(Picture picture, int flip, float horiRatio, float vertRatio) {
        this.picture = picture;
        this.flip = flip;
        this.horiRatio = horiRatio;
        this.vertRatio = vertRatio;
    }

    public TileShader(Picture picture, int flip, float horiRatio, float vertRatio, int offsetX, int offsetY) {
        this(picture, flip, horiRatio, vertRatio);
        this.offsetX = offsetX;
        this.offsetY = offsetY;
    }

    @Override
    public Shader createShader(IControl control, int viewIndex, Rect rect) {
        try {
            Bitmap bmp = TileShader.getBitmap(control, viewIndex, this.picture, rect, null);
            int width = bmp.getWidth();
            int height = bmp.getHeight();
            bmp = Bitmap.createScaledBitmap((Bitmap)bmp, (int)Math.round((float)width * this.horiRatio), (int)Math.round((float)height * this.vertRatio), (boolean)true);
            Shader.TileMode tileX = Shader.TileMode.REPEAT;
            Shader.TileMode tileY = Shader.TileMode.REPEAT;
            switch (this.flip) {
                case 1: {
                    tileX = Shader.TileMode.MIRROR;
                }
                case 2: {
                    tileY = Shader.TileMode.MIRROR;
                }
                case 3: {
                    tileX = Shader.TileMode.MIRROR;
                    tileY = Shader.TileMode.MIRROR;
                }
            }
            this.shader = new BitmapShader(bmp, tileX, tileY);
            return this.shader;
        }
        catch (Exception e) {
            return null;
        }
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public void setOffsetX(int offsetX) {
        this.offsetX = offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public void setOffsetY(int offsetY) {
        this.offsetY = offsetY;
    }

    public static Bitmap getBitmap(IControl control, int viewIndex, Picture picture, Rect rect, BitmapFactory.Options options) {
        try {
            String path = picture.getTempFilePath();
            Bitmap sBitmap = control.getSysKit().getPictureManage().getBitmap(path);
            if (sBitmap == null) {
                byte imageType = picture.getPictureType();
                if (imageType == 3 || imageType == 2) {
                    String dst = control.getSysKit().getPictureManage().convertVectorgraphToPng(viewIndex, imageType, path, rect.width(), rect.height(), true);
                    FileInputStream in = new FileInputStream(dst);
                    sBitmap = BitmapFactory.decodeStream((InputStream)in, null, (BitmapFactory.Options)options);
                } else {
                    FileInputStream in = new FileInputStream(path);
                    sBitmap = BitmapFactory.decodeStream((InputStream)in, null, (BitmapFactory.Options)options);
                }
                if (sBitmap == null) {
                    return null;
                }
                control.getSysKit().getPictureManage().addBitmap(path, sBitmap);
            }
            return sBitmap;
        }
        catch (OutOfMemoryError e) {
            if (control.getSysKit().getPictureManage().hasBitmap()) {
                control.getSysKit().getPictureManage().clearBitmap();
                return TileShader.getBitmap(control, viewIndex, picture, rect, options);
            }
            if (options == null) {
                options = new BitmapFactory.Options();
                options.inSampleSize = 2;
            } else {
                options.inSampleSize *= 2;
            }
            return TileShader.getBitmap(control, viewIndex, picture, rect, options);
        }
        catch (Exception e) {
            return null;
        }
    }
}

