/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.bg;

import android.graphics.RadialGradient;
import android.graphics.Rect;
import android.graphics.Shader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.Gradient;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;

public class RadialGradientShader
extends Gradient {
    public static final int Center_TL = 0;
    public static final int Center_TR = 1;
    public static final int Center_BL = 2;
    public static final int Center_BR = 3;
    public static final int Center_Center = 4;
    private int positionType;

    public RadialGradientShader(int positionType, int[] colors, float[] positions) {
        super(colors, positions);
        this.positionType = positionType;
    }

    @Override
    public int getGradientType() {
        return 4;
    }

    @Override
    public Shader createShader(IControl control, int viewIndex, Rect rect) {
        int[] coordinate = this.getCircleCoordinate();
        if (this.positionType == 4 && this.getFocus() == 0) {
            int size = this.colors.length;
            int nTem = 0;
            for (int i = 0; i < size / 2; ++i) {
                nTem = this.colors[i];
                this.colors[i] = this.colors[size - 1 - i];
                this.colors[size - 1 - i] = nTem;
            }
        }
        this.shader = new RadialGradient((float)coordinate[0], (float)coordinate[1], (float)coordinate[2], this.colors, this.positions, Shader.TileMode.REPEAT);
        return this.shader;
    }

    private int[] getCircleCoordinate() {
        int radius = (int)Math.ceil(Math.sqrt(Math.pow(100.0, 2.0) * 2.0));
        switch (this.positionType) {
            case 1: {
                return new int[]{100, 0, radius};
            }
            case 2: {
                return new int[]{0, 100, radius};
            }
            case 3: {
                return new int[]{100, 100, radius};
            }
            case 4: {
                return new int[]{50, 50, radius / 2};
            }
        }
        return new int[]{0, 0, radius};
    }
}

