/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.bg;

import android.graphics.LinearGradient;
import android.graphics.Rect;
import android.graphics.Shader;
import com.ahmadullahpk.alldocumentreader.xs.common.bg.Gradient;
import com.ahmadullahpk.alldocumentreader.xs.system.IControl;

public class LinearGradientShader
extends Gradient {
    private float angle;

    public LinearGradientShader(float angle, int[] colors, float[] positions) {
        super(colors, positions);
        this.angle = angle;
    }

    @Override
    public int getGradientType() {
        return 7;
    }

    public int getAngle() {
        return (int)this.angle;
    }

    @Override
    public Shader createShader(IControl control, int viewIndex, Rect rect) {
        try {
            int[] coordinate = this.getLinearGradientCoordinate();
            this.shader = new LinearGradient((float)coordinate[0], (float)coordinate[1], (float)coordinate[2], (float)coordinate[3], this.colors, this.positions, Shader.TileMode.MIRROR);
            return this.shader;
        }
        catch (Exception e) {
            return null;
        }
    }

    private int[] getLinearGradientCoordinate() {
        switch (Math.round((this.angle + 22.0f) % 360.0f / 45.0f)) {
            case 0: {
                return new int[]{0, 0, 100, 0};
            }
            case 1: {
                return new int[]{0, 0, 100, 100};
            }
            case 2: {
                return new int[]{0, 0, 0, 100};
            }
            case 3: {
                return new int[]{100, 0, 0, 100};
            }
            case 4: {
                return new int[]{100, 0, 0, 0};
            }
            case 5: {
                return new int[]{100, 100, 0, 0};
            }
            case 6: {
                return new int[]{0, 100, 0, 0};
            }
        }
        return new int[]{0, 100, 100, 0};
    }
}

