/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.starAndBanner.star;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.Rect;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.starAndBanner.star.EarlyStarPathBuilder;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.starAndBanner.star.LaterStarPathBuilder;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;

public class StarPathBuilder {
    private static Matrix sm = new Matrix();
    private static Path path = new Path();

    public static Path getStarPath(AutoShape shape, Rect rect) {
        path.reset();
        switch (shape.getShapeType()) {
            case 71: {
                return StarPathBuilder.getIrregularSeal1Path(shape, rect);
            }
            case 72: {
                return StarPathBuilder.getIrregularSeal2Path(shape, rect);
            }
            case 12: 
            case 58: 
            case 59: 
            case 60: 
            case 92: 
            case 187: 
            case 235: 
            case 236: 
            case 237: 
            case 238: 
            case 239: {
                if (shape.isAutoShape07()) {
                    return LaterStarPathBuilder.getStarPath(shape, rect);
                }
                return EarlyStarPathBuilder.getStarPath(shape, rect);
            }
        }
        return path;
    }

    private static Path getIrregularSeal1Path(AutoShape shape, Rect rect) {
        float len = 380.0f;
        path.moveTo(66.0f, 206.0f);
        path.lineTo(0.0f, 150.0f);
        path.lineTo(83.0f, 134.0f);
        path.lineTo(8.0f, 41.0f);
        path.lineTo(128.0f, 112.0f);
        path.lineTo(147.0f, 42.0f);
        path.lineTo(190.0f, 103.0f);
        path.lineTo(255.0f, 0.0f);
        path.lineTo(250.0f, 93.0f);
        path.lineTo(323.0f, 78.0f);
        path.lineTo(294.0f, 128.0f);
        path.lineTo(370.0f, 142.0f);
        path.lineTo(310.0f, 185.0f);
        path.lineTo(380.0f, 233.0f);
        path.lineTo(296.0f, 228.0f);
        path.lineTo(319.0f, 318.0f);
        path.lineTo(247.0f, 255.0f);
        path.lineTo(233.0f, 346.0f);
        path.lineTo(185.0f, 263.0f);
        path.lineTo(149.0f, 380.0f);
        path.lineTo(135.0f, 275.0f);
        path.lineTo(84.0f, 309.0f);
        path.lineTo(99.0f, 245.0f);
        path.lineTo(0.0f, 256.0f);
        path.close();
        sm.reset();
        sm.postScale((float)rect.width() / len, (float)rect.height() / len);
        path.transform(sm);
        path.offset((float)rect.left, (float)rect.top);
        return path;
    }

    private static Path getIrregularSeal2Path(AutoShape shape, Rect rect) {
        float len = 380.0f;
        path.moveTo(70.0f, 203.0f);
        path.lineTo(20.0f, 143.0f);
        path.lineTo(95.0f, 137.0f);
        path.lineTo(79.0f, 64.0f);
        path.lineTo(151.0f, 113.0f);
        path.lineTo(170.0f, 32.0f);
        path.lineTo(202.0f, 76.0f);
        path.lineTo(260.0f, 0.0f);
        path.lineTo(255.0f, 101.0f);
        path.lineTo(316.0f, 55.0f);
        path.lineTo(287.0f, 114.0f);
        path.lineTo(380.0f, 115.0f);
        path.lineTo(298.0f, 164.0f);
        path.lineTo(321.0f, 198.0f);
        path.lineTo(287.0f, 215.0f);
        path.lineTo(331.0f, 273.0f);
        path.lineTo(257.0f, 251.0f);
        path.lineTo(262.0f, 304.0f);
        path.lineTo(215.0f, 280.0f);
        path.lineTo(204.0f, 330.0f);
        path.lineTo(174.0f, 304.0f);
        path.lineTo(153.0f, 345.0f);
        path.lineTo(132.0f, 317.0f);
        path.lineTo(86.0f, 380.0f);
        path.lineTo(85.0f, 319.0f);
        path.lineTo(23.0f, 313.0f);
        path.lineTo(58.0f, 269.0f);
        path.lineTo(0.0f, 225.0f);
        path.close();
        sm.reset();
        sm.postScale((float)rect.width() / len, (float)rect.height() / len);
        path.transform(sm);
        path.offset((float)rect.left, (float)rect.top);
        return path;
    }

    public static Path getStarPath(int A, int B, int a, int b, int starPoints) {
        float offDegree = 360.0f / (float)(starPoints * 2);
        path.moveTo(0.0f, (float)(-B));
        float x = 0.0f;
        float y = 0.0f;
        float degree = 270.0f;
        if (a > 0 && b > 0) {
            int index = 1;
            while (index++ < starPoints) {
                if ((degree = (degree + offDegree) % 360.0f) == 90.0f) {
                    x = 0.0f;
                    y = b;
                } else {
                    x = (float)((double)(a * b) / Math.sqrt(Math.pow(b, 2.0) + Math.pow((double)a * Math.tan((double)degree * Math.PI / 180.0), 2.0)));
                    if (degree > 90.0f && degree < 270.0f) {
                        x = -x;
                    }
                    y = (float)((double)x * Math.tan((double)degree * Math.PI / 180.0));
                }
                path.lineTo(x, y);
                degree = (degree + offDegree) % 360.0f;
                if (degree == 90.0f) {
                    x = 0.0f;
                    y = B;
                } else {
                    x = (float)((double)(A * B) / Math.sqrt(Math.pow(B, 2.0) + Math.pow((double)A * Math.tan((double)degree * Math.PI / 180.0), 2.0)));
                    if (degree > 90.0f && degree < 270.0f) {
                        x = -x;
                    }
                    y = (float)((double)x * Math.tan((double)degree * Math.PI / 180.0));
                }
                path.lineTo(x, y);
            }
            degree = 270.0f - offDegree;
            x = -((float)((double)(a * b) / Math.sqrt(Math.pow(b, 2.0) + Math.pow((double)a * Math.tan((double)degree * Math.PI / 180.0), 2.0))));
            y = (float)((double)x * Math.tan((double)degree * Math.PI / 180.0));
            path.lineTo(x, y);
        } else {
            int index = 1;
            while (index++ < starPoints) {
                degree = (degree + offDegree) % 360.0f;
                path.lineTo(0.0f, 0.0f);
                degree = (degree + offDegree) % 360.0f;
                if (degree == 90.0f) {
                    x = 0.0f;
                    y = B;
                } else {
                    x = (float)((double)(A * B) / Math.sqrt(Math.pow(B, 2.0) + Math.pow((double)A * Math.tan((double)degree * Math.PI / 180.0), 2.0)));
                    if (degree > 90.0f && degree < 270.0f) {
                        x = -x;
                    }
                    y = (float)((double)x * Math.tan((double)degree * Math.PI / 180.0));
                }
                path.lineTo(x, y);
            }
            path.lineTo(0.0f, 0.0f);
        }
        path.close();
        return path;
    }
}

