/*
 * Decompiled with CFR 0.152.
 */
package com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.starAndBanner.star;

import android.graphics.Matrix;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.RectF;
import com.ahmadullahpk.alldocumentreader.xs.common.autoshape.pathbuilder.starAndBanner.star.StarPathBuilder;
import com.ahmadullahpk.alldocumentreader.xs.common.shape.AutoShape;

public class EarlyStarPathBuilder {
    private static Matrix sm = new Matrix();
    public static RectF s_rect = new RectF();

    public static Path getStarPath(AutoShape shape, Rect rect) {
        switch (shape.getShapeType()) {
            case 187: {
                return EarlyStarPathBuilder.getStar4Path(shape, rect);
            }
            case 12: 
            case 235: {
                return EarlyStarPathBuilder.getStar5Path(shape, rect);
            }
            case 58: {
                return EarlyStarPathBuilder.getStar8Path(shape, rect);
            }
            case 59: {
                return EarlyStarPathBuilder.getStar16Path(shape, rect);
            }
            case 92: {
                return EarlyStarPathBuilder.getStar24Path(shape, rect);
            }
            case 60: {
                return EarlyStarPathBuilder.getStar32Path(shape, rect);
            }
        }
        return null;
    }

    private static Path getStar4Path(AutoShape shape, Rect rect) {
        float len;
        Float[] values = shape.getAdjustData();
        float width = len = (float)Math.min(rect.width(), rect.height());
        float height = len;
        float a = 0.0f;
        float b = 0.0f;
        if (values != null && values.length == 1) {
            if (values[0].floatValue() > 0.5f) {
                values[0] = Float.valueOf(0.5f);
            }
            a = len * (0.5f - values[0].floatValue());
            b = len * (0.5f - values[0].floatValue());
        } else {
            a = len * 0.125f;
            b = len * 0.125f;
        }
        float outA = width / 2.0f;
        float outB = height / 2.0f;
        Path path = StarPathBuilder.getStarPath((int)outA, (int)outB, (int)a, (int)b, 4);
        sm.reset();
        sm.postScale((float)rect.width() / len, (float)rect.height() / len);
        path.transform(sm);
        path.offset((float)rect.centerX(), (float)rect.centerY());
        return path;
    }

    private static Path getStar5Path(AutoShape shape, Rect rect) {
        float len;
        Float[] values = shape.getAdjustData();
        float width = len = (float)Math.min(rect.width(), rect.height());
        float height = len;
        float a = 0.0f;
        float b = 0.0f;
        a = (width *= 1.05146f) * 0.2f;
        b = (height *= 1.10557f) * 0.2f;
        float outA = width / 2.0f;
        float outB = height / 2.0f;
        Path path = StarPathBuilder.getStarPath((int)outA, (int)outB, (int)a, (int)b, 5);
        sm.reset();
        sm.postScale((float)rect.width() / len, (float)rect.height() / len);
        path.transform(sm);
        height = height * (float)rect.height() / len;
        path.offset((float)rect.centerX(), (float)rect.centerY() + (height - (float)rect.height()) / 2.0f);
        return path;
    }

    private static Path getStar8Path(AutoShape shape, Rect rect) {
        float len;
        Float[] values = shape.getAdjustData();
        float width = len = (float)Math.min(rect.width(), rect.height());
        float height = len;
        float a = 0.0f;
        float b = 0.0f;
        if (values != null && values.length == 1) {
            if (values[0].floatValue() > 0.5f) {
                values[0] = Float.valueOf(0.5f);
            }
            a = width * (0.5f - values[0].floatValue());
            b = height * (0.5f - values[0].floatValue());
        } else {
            a = width * 0.375f;
            b = height * 0.375f;
        }
        float outA = width / 2.0f;
        float outB = height / 2.0f;
        Path path = StarPathBuilder.getStarPath((int)outA, (int)outB, (int)a, (int)b, 8);
        sm.reset();
        sm.postScale((float)rect.width() / len, (float)rect.height() / len);
        path.transform(sm);
        path.offset((float)rect.centerX(), (float)rect.centerY());
        return path;
    }

    private static Path getStar16Path(AutoShape shape, Rect rect) {
        float len;
        Float[] values = shape.getAdjustData();
        float width = len = (float)Math.min(rect.width(), rect.height());
        float height = len;
        float a = 0.0f;
        float b = 0.0f;
        if (values != null && values.length == 1) {
            if (values[0].floatValue() > 0.5f) {
                values[0] = Float.valueOf(0.5f);
            }
            a = width * (0.5f - values[0].floatValue());
            b = height * (0.5f - values[0].floatValue());
        } else {
            a = width * 0.375f;
            b = height * 0.375f;
        }
        Path path = StarPathBuilder.getStarPath((int)width / 2, (int)height / 2, (int)a, (int)b, 16);
        sm.reset();
        sm.postScale((float)rect.width() / len, (float)rect.height() / len);
        path.transform(sm);
        path.offset((float)rect.centerX(), (float)rect.centerY());
        return path;
    }

    private static Path getStar24Path(AutoShape shape, Rect rect) {
        float len;
        Float[] values = shape.getAdjustData();
        float width = len = (float)Math.min(rect.width(), rect.height());
        float height = len;
        float a = 0.0f;
        float b = 0.0f;
        if (values != null && values.length == 1) {
            if (values[0].floatValue() > 0.5f) {
                values[0] = Float.valueOf(0.5f);
            }
            a = width * (0.5f - values[0].floatValue());
            b = height * (0.5f - values[0].floatValue());
        } else {
            a = width * 0.375f;
            b = height * 0.375f;
        }
        Path path = StarPathBuilder.getStarPath((int)width / 2, (int)height / 2, (int)a, (int)b, 24);
        sm.reset();
        sm.postScale((float)rect.width() / len, (float)rect.height() / len);
        path.transform(sm);
        path.offset((float)rect.centerX(), (float)rect.centerY());
        return path;
    }

    private static Path getStar32Path(AutoShape shape, Rect rect) {
        float len;
        Float[] values = shape.getAdjustData();
        float width = len = (float)Math.min(rect.width(), rect.height());
        float height = len;
        float a = 0.0f;
        float b = 0.0f;
        if (values != null && values.length == 1) {
            if (values[0].floatValue() > 0.5f) {
                values[0] = Float.valueOf(0.5f);
            }
            a = width * (0.5f - values[0].floatValue());
            b = height * (0.5f - values[0].floatValue());
        } else {
            a = width * 0.375f;
            b = height * 0.375f;
        }
        Path path = StarPathBuilder.getStarPath((int)width / 2, (int)height / 2, (int)a, (int)b, 32);
        sm.reset();
        sm.postScale((float)rect.width() / len, (float)rect.height() / len);
        path.transform(sm);
        path.offset((float)rect.centerX(), (float)rect.centerY());
        return path;
    }
}

